/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import wiremock.org.eclipse.jetty.client.HttpChannel;
import wiremock.org.eclipse.jetty.client.HttpConnection;
import wiremock.org.eclipse.jetty.client.HttpDestination;
import wiremock.org.eclipse.jetty.client.HttpExchange;
import wiremock.org.eclipse.jetty.client.HttpRequest;
import wiremock.org.eclipse.jetty.client.SendFailure;
import wiremock.org.eclipse.jetty.client.api.Connection;
import wiremock.org.eclipse.jetty.client.api.Request;
import wiremock.org.eclipse.jetty.client.api.Response;
import wiremock.org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import wiremock.org.eclipse.jetty.io.AbstractConnection;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.util.Attachable;
import wiremock.org.eclipse.jetty.util.Promise;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection,
Connection.UpgradeFrom,
Sweeper.Sweepable,
Attachable {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Promise<Connection> promise;
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private long idleTimeout;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();

    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        super(endPoint, destination.getHttpClient().getExecutor());
        this.promise = promise;
        this.delegate = new Delegate(destination);
        this.channel = this.newHttpChannel();
    }

    protected HttpChannelOverHTTP newHttpChannel() {
        return new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    protected void addBytesIn(long bytesIn) {
        this.bytesIn.add(bytesIn);
    }

    @Override
    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    protected void addBytesOut(long bytesOut) {
        this.bytesOut.add(bytesOut);
    }

    @Override
    public long getMessagesIn() {
        return this.getHttpChannel().getMessagesIn();
    }

    @Override
    public long getMessagesOut() {
        return this.getHttpChannel().getMessagesOut();
    }

    @Override
    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    protected SendFailure send(HttpExchange exchange) {
        return this.delegate.send(exchange);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void setAttachment(Object obj) {
        this.delegate.setAttachment(obj);
    }

    @Override
    public Object getAttachment() {
        return this.delegate.getAttachment();
    }

    @Override
    public boolean onIdleExpired() {
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        boolean close = this.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(new TimeoutException("Idle timeout " + idleTimeout + " ms"));
        }
        return false;
    }

    protected boolean onIdleTimeout(long idleTimeout) {
        return this.delegate.onIdleTimeout(idleTimeout);
    }

    @Override
    public void onFillable() {
        this.channel.receive();
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        HttpReceiverOverHTTP receiver = this.channel.getHttpReceiver();
        return receiver.onUpgradeFrom();
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove(this);
            this.abort(failure);
            this.channel.destroy();
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", this);
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", this);
            }
        }
    }

    protected boolean abort(Throwable failure) {
        HttpExchange exchange = this.channel.getHttpExchange();
        return exchange != null && exchange.getRequest().abort(failure);
    }

    @Override
    public boolean sweep() {
        if (!this.closed.get()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    public void remove() {
        this.getHttpDestination().remove(this);
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x(l:%s <-> r:%s,closed=%b)=>%s", this.getClass().getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress(), this.closed.get(), this.channel);
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        @Override
        protected Iterator<HttpChannel> getHttpChannels() {
            return Collections.singleton(HttpConnectionOverHTTP.this.channel).iterator();
        }

        @Override
        protected SendFailure send(HttpExchange exchange) {
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.this.idleTimeout = endPoint.getIdleTimeout();
            long requestIdleTimeout = request.getIdleTimeout();
            if (requestIdleTimeout >= 0L) {
                endPoint.setIdleTimeout(requestIdleTimeout);
            }
            return this.send(HttpConnectionOverHTTP.this.channel, exchange);
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
            this.destroy();
        }

        @Override
        public boolean isClosed() {
            return HttpConnectionOverHTTP.this.isClosed();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

