/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.standalone.CommandLineOptions;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;

public class WireMockServerRunner {
    private static final String BANNER = " /$$      /$$ /$$                     /$$      /$$                     /$$      \n| $$  /$ | $$|__/                    | $$$    /$$$                    | $$      \n| $$ /$$$| $$ /$$  /$$$$$$   /$$$$$$ | $$$$  /$$$$  /$$$$$$   /$$$$$$$| $$   /$$\n| $$/$$ $$ $$| $$ /$$__  $$ /$$__  $$| $$ $$/$$ $$ /$$__  $$ /$$_____/| $$  /$$/\n| $$$$_  $$$$| $$| $$  \\__/| $$$$$$$$| $$  $$$| $$| $$  \\ $$| $$      | $$$$$$/ \n| $$$/ \\  $$$| $$| $$      | $$_____/| $$\\  $ | $$| $$  | $$| $$      | $$_  $$ \n| $$/   \\  $$| $$| $$      |  $$$$$$$| $$ \\/  | $$|  $$$$$$/|  $$$$$$$| $$ \\  $$\n|__/     \\__/|__/|__/       \\_______/|__/     |__/ \\______/  \\_______/|__/  \\__/";
    private WireMockServer wireMockServer;

    public void run(String ... args) {
        CommandLineOptions options = new CommandLineOptions(args);
        if (options.help()) {
            System.out.println(options.helpText());
            return;
        }
        FileSource fileSource = options.filesRoot();
        fileSource.createIfNecessary();
        FileSource filesFileSource = fileSource.child("__files");
        filesFileSource.createIfNecessary();
        FileSource mappingsFileSource = fileSource.child("mappings");
        mappingsFileSource.createIfNecessary();
        this.wireMockServer = new WireMockServer(options);
        if (options.recordMappingsEnabled()) {
            this.wireMockServer.enableRecordMappings(mappingsFileSource, filesFileSource);
        }
        if (options.specifiesProxyUrl()) {
            this.addProxyMapping(options.proxyUrl());
        }
        try {
            this.wireMockServer.start();
            boolean https = options.httpsSettings().enabled();
            options.setResultingPort(https ? this.wireMockServer.httpsPort() : this.wireMockServer.port());
            if (!options.bannerDisabled()) {
                System.out.println(BANNER);
                System.out.println();
            } else {
                System.out.println();
                System.out.println("The WireMock server is started .....");
            }
            System.out.println(options);
        }
        catch (FatalStartupException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void addProxyMapping(final String baseUrl) {
        this.wireMockServer.loadMappingsUsing(new MappingsLoader(){

            @Override
            public void loadMappingsInto(StubMappings stubMappings) {
                RequestPattern requestPattern = RequestPatternBuilder.newRequestPattern(RequestMethod.ANY, WireMock.anyUrl()).build();
                ResponseDefinition responseDef = ResponseDefinitionBuilder.responseDefinition().proxiedFrom(baseUrl).build();
                StubMapping proxyBasedMapping = new StubMapping(requestPattern, responseDef);
                proxyBasedMapping.setPriority(10);
                stubMappings.addMapping(proxyBasedMapping);
            }
        });
    }

    public void stop() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    public boolean isRunning() {
        if (this.wireMockServer == null) {
            return false;
        }
        return this.wireMockServer.isRunning();
    }

    public int port() {
        return this.wireMockServer.port();
    }

    public static void main(String ... args) {
        new WireMockServerRunner().run(args);
    }

    static {
        System.setProperty("wiremock.org.mortbay.log.class", "com.github.tomakehurst.wiremock.jetty.LoggerAdapter");
    }
}

