/*
 * Copyright (C) 2011 Thomas Akehurst
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;

import java.text.ParseException;
import java.util.Date;

import static com.github.tomakehurst.wiremock.common.Exceptions.throwUnchecked;

public class Dates {

    public static Date parse(String dateString) {
        try {
            return new ISO8601DateFormat().parse(dateString);
        } catch (ParseException e) {
            return throwUnchecked(e, Date.class);
        }
    }

    public static String format(Date date) {
        return ISO8601Utils.format(date);
    }
}
