/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.tensor;

import com.github.tjake.jlama.math.VectorMath;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.tensor.AbstractTensor;
import com.github.tjake.jlama.tensor.FloatBufferTensor;
import com.github.tjake.jlama.tensor.Q4ByteBufferTensor;
import com.github.tjake.jlama.tensor.TensorShape;
import com.github.tjake.jlama.util.UnsafeDirectByteBuffer;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorSpecies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Q8ByteBufferTensor
extends AbstractTensor<ByteVector, Byte> {
    private static final Logger logger = LoggerFactory.getLogger(Q8ByteBufferTensor.class);
    public static final int BLOCK_SIZE = 32;
    public static final float I_BLOCK_SIZE = 0.03125f;
    final ByteBuffer b;
    final FloatBufferTensor blockF;
    private final String name;
    private final MemorySegment segment;

    public Q8ByteBufferTensor(AbstractTensor ft) {
        this(ft.shape);
        Preconditions.checkArgument((ft.dType != DType.I8 ? 1 : 0) != 0, (Object)"This should never happen, likely a bug");
        Preconditions.checkArgument((ft.size() % 32L == 0L ? 1 : 0) != 0, (Object)"I8 buffer must be a multiple of BLOCK_SIZE");
        ArrayList<int[]> startBlockCursors = new ArrayList<int[]>();
        int[] cursor = new int[ft.shape.dims()];
        int c = 0;
        do {
            if (c++ % 32 != 0) continue;
            startBlockCursors.add(Arrays.copyOf(cursor, cursor.length));
        } while (ft.iterate(cursor));
        VectorMath.pfor(0, startBlockCursors.size(), i -> {
            int[] blockStartCursor = (int[])startBlockCursors.get(i);
            this.processBlock(ft, blockStartCursor);
        });
    }

    void processBlock(AbstractTensor ft, int[] blockStartCursor) {
        int[] cursor = Arrays.copyOf(blockStartCursor, blockStartCursor.length);
        float max = Float.MIN_VALUE;
        for (int i = 0; i < 32; ++i) {
            float absv;
            float v = ft.get(cursor);
            float f = absv = v < 0.0f ? -v : v;
            if (absv > max) {
                max = absv;
            }
            ft.iterate(cursor);
        }
        float iscale = 127.0f / max;
        float scale = iscale != 0.0f ? 1.0f / iscale : 0.0f;
        this.blockF.set(scale, Q4ByteBufferTensor.makeBlockShape(blockStartCursor));
        int i = ft.getOffset(blockStartCursor);
        int j = 0;
        while (j < 32) {
            float f0 = ft.get(blockStartCursor) * iscale;
            this.b.put(i, (byte)Math.round(f0));
            ft.iterate(blockStartCursor);
            ++j;
            ++i;
        }
    }

    public Q8ByteBufferTensor(int ... shape) {
        this(TensorShape.of(shape));
    }

    public Q8ByteBufferTensor(TensorShape shape) {
        super(DType.I8, shape, true);
        Preconditions.checkArgument((this.size() % 32L == 0L ? 1 : 0) != 0, (Object)"Tensor must be a multiple of BLOCK_SIZE");
        this.blockF = new FloatBufferTensor(Q4ByteBufferTensor.makeBlockShape(shape));
        this.name = "tmp";
        this.b = UnsafeDirectByteBuffer.allocateAlignedByteBuffer(Ints.checkedCast((long)this.size()), 64L).order(ByteOrder.LITTLE_ENDIAN);
        this.segment = MemorySegment.ofBuffer(this.b);
    }

    public Q8ByteBufferTensor(String name, ByteBuffer b, FloatBufferTensor blockF, TensorShape shape, boolean cacheSlices) {
        super(DType.I8, shape, cacheSlices);
        this.name = name;
        this.blockF = blockF;
        if (b.isDirect()) {
            this.b = b;
        } else {
            this.b = ByteBuffer.allocateDirect(b.remaining()).order(ByteOrder.LITTLE_ENDIAN);
            this.b.duplicate().put(b);
        }
        this.segment = MemorySegment.ofBuffer(this.b);
    }

    @Override
    protected AbstractTensor make(TensorShape shape) {
        return new Q8ByteBufferTensor(shape);
    }

    @Override
    protected AbstractTensor make(int offset, int length, TensorShape shape, boolean cacheSlices) {
        FloatBufferTensor newBlockF = (FloatBufferTensor)this.blockF.make((int)((float)offset * 0.03125f), (int)((float)length * 0.03125f), Q4ByteBufferTensor.makeBlockShape(shape), cacheSlices);
        return new Q8ByteBufferTensor(this.name, this.b.slice(offset, length), newBlockF, shape, cacheSlices);
    }

    @Override
    public float get(int ... dims) {
        Preconditions.checkArgument((dims.length <= this.shape.dims() ? 1 : 0) != 0, (Object)"Too many dimensions specified");
        Preconditions.checkArgument((dims.length == this.shape.dims() ? 1 : 0) != 0, (Object)"Must specify all dimensions");
        int i = this.getOffset(dims);
        float d = this.blockF.get(Q4ByteBufferTensor.makeBlockShape(dims));
        return (float)this.b.get(i) * d;
    }

    public final FloatBufferTensor getBlockF() {
        return this.blockF;
    }

    public final float getFactorForIndex(int d, int i) {
        int ix = (int)((float)i * 0.03125f);
        if ((long)ix >= this.blockF.size()) {
            throw new RuntimeException();
        }
        return this.blockF.get(d, ix);
    }

    @Override
    public void set(float v, int ... dims) {
        Preconditions.checkArgument((dims.length <= this.shape.dims() ? 1 : 0) != 0, (Object)"Too many dimensions specified for tensor");
        Preconditions.checkArgument((dims.length == this.shape.dims() ? 1 : 0) != 0, (Object)"Must specify all dimensions");
        Preconditions.checkArgument((!this.b.isReadOnly() ? 1 : 0) != 0, (Object)"Can't modify a read only buffer");
        int i = this.getOffset(dims);
        float d = this.blockF.get(Q4ByteBufferTensor.makeBlockShape(dims));
        float max = d * 127.0f;
        if (!(v <= max)) {
            throw new UnsupportedOperationException();
        }
        float id = d != 0.0f ? 1.0f / d : d;
        this.b.put(i, (byte)(v * id));
    }

    @Override
    public ByteVector getVector(VectorSpecies<Byte> species, int ... voffset) {
        int offset = this.getOffset(voffset);
        return ByteVector.fromMemorySegment(species, (MemorySegment)this.segment, (long)this.getMemorySegmentOffset(offset), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void intoTensor(ByteVector vector, int ... aoffset) {
        Preconditions.checkArgument((!this.b.isReadOnly() ? 1 : 0) != 0);
        int offset = this.getOffset(aoffset);
        vector.intoMemorySegment(this.segment, (long)this.getMemorySegmentOffset(offset), ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void intoTensor(ByteVector vector, VectorMask<Byte> msk, int ... aoffset) {
        Preconditions.checkArgument((!this.b.isReadOnly() ? 1 : 0) != 0);
        int offset = this.getOffset(aoffset);
        vector.intoMemorySegment(this.segment, (long)this.getMemorySegmentOffset(offset), ByteOrder.LITTLE_ENDIAN, msk);
    }

    @Override
    public MemorySegment getMemorySegment() {
        return this.segment;
    }

    @Override
    public int getMemorySegmentOffset(int offset) {
        return offset;
    }

    @Override
    public void copyFrom(AbstractTensor src, int srcOffset, int destOffset, int length) {
        Preconditions.checkArgument((this.dType == src.dType ? 1 : 0) != 0, (Object)"different types");
        Preconditions.checkArgument((!this.b.isReadOnly() ? 1 : 0) != 0, (Object)"Read-only");
        this.segment.asSlice((long)this.getMemorySegmentOffset(destOffset), length).copyFrom(src.getMemorySegment().asSlice((long)src.getMemorySegmentOffset(srcOffset), length));
    }

    @Override
    public void clear() {
        Preconditions.checkArgument((!this.b.isReadOnly() ? 1 : 0) != 0, (Object)"Can't clear a read-only buffer");
        this.segment.fill((byte)0);
    }

    public String toString() {
        byte[] sample = new byte[Math.min(10, this.b.remaining())];
        this.b.duplicate().get(sample);
        return "ByteBufferTensor{name='" + this.name + "'shape=" + String.valueOf(this.shape) + ", b=" + Arrays.toString(sample) + "...}";
    }
}

