/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.safetensors.prompt;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.tjake.jlama.safetensors.prompt.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.objects.collections.PyMap;
import java.util.Map;

@JsonPropertyOrder(value={"name", "description", "parameters"})
public class Function
extends PyMap {
    public static final String JSON_PROPERTY_NAME = "name";
    private final String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private final String description;
    public static final String JSON_PROPERTY_PARAMETERS = "parameters";
    private final Parameters parameters;

    public static Builder builder() {
        return new Builder();
    }

    private Function(String name, String description, Parameters parameters) {
        super((Map)ImmutableMap.builder().put((Object)JSON_PROPERTY_NAME, (Object)name).put((Object)JSON_PROPERTY_DESCRIPTION, (Object)description).put((Object)JSON_PROPERTY_PARAMETERS, (Object)parameters).build());
        this.name = name;
        this.description = description;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public static class Builder {
        private String name;
        private String description = "";
        private Parameters.Builder parameters = Parameters.builder();

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addParameter(String name, String type, String description, boolean required) {
            this.parameters.addProperty(name, type, description, required);
            return this;
        }

        public Builder addParameter(String name, Map<String, Object> properties, boolean required) {
            this.parameters.addProperty(name, properties, required);
            return this;
        }

        public Function build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"name is required");
            return new Function(this.name, this.description, this.parameters.build());
        }
    }
}

