/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.model.granite;

import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.CausalSelfAttention;
import com.github.tjake.jlama.model.MLPBlock;
import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.model.RMSNorm;
import com.github.tjake.jlama.model.TransformerBlock;
import com.github.tjake.jlama.model.functions.EmbedInput;
import com.github.tjake.jlama.model.llama.LlamaModel;
import com.github.tjake.jlama.safetensors.Config;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.WeightLoader;
import com.github.tjake.jlama.safetensors.tokenizer.Tokenizer;
import com.github.tjake.jlama.tensor.AbstractTensor;
import com.github.tjake.jlama.tensor.operations.TensorOperationsProvider;
import java.util.Optional;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraniteModel
extends LlamaModel {
    private static final Logger logger = LoggerFactory.getLogger(GraniteModel.class);

    public GraniteModel(Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    public GraniteModel(AbstractModel.InferenceType inferenceType, Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(inferenceType, config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    @Override
    public ModelSupport.ModelType getModelType() {
        return ModelSupport.ModelType.GRANITE;
    }

    @Override
    protected TransformerBlock[] loadTransformerBlockWeights() {
        DType qType = this.modelQType.orElse(this.modelDType);
        if (qType != this.modelDType) {
            logger.info("Quantizing model with {} - Please hold...", (Object)qType);
        }
        TransformerBlock[] transformerBlocks = new TransformerBlock[this.c.dctx().numberOfLayers];
        IntStream.range(this.c.dctx().layerStart, this.c.dctx().layerEnd).parallel().forEach(i -> {
            int relativeLayer = i - this.c.dctx().layerStart;
            String base = "model.layers." + i + ".";
            String prefix = base + "self_attn.";
            CausalSelfAttention attention = new CausalSelfAttention(this, relativeLayer, this.weights.load(prefix + "q_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "k_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "v_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "o_proj.weight", this.c.dctx(), false, true).quantize(qType));
            prefix = base + "mlp.";
            MLPBlock mlp = new MLPBlock(this, this.c.activationFunction, this.weights.load(prefix + "gate_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "down_proj.weight", this.c.dctx(), false, true).quantize(qType), this.weights.load(prefix + "up_proj.weight", this.c.dctx(), true, false).quantize(qType));
            transformerBlocks[relativeLayer] = new TransformerBlock(this, relativeLayer, Optional.of(new RMSNorm(this, this.weights.load(base + "input_layernorm.weight").quantize(qType))), attention, Optional.empty(), Optional.of(new RMSNorm(this, this.weights.load(base + "post_attention_layernorm.weight").quantize(qType))), mlp, Optional.empty(), Optional.empty());
        });
        return transformerBlocks;
    }

    @Override
    protected EmbedInput loadInputWeights() {
        EmbedInput embedInput = super.loadInputWeights();
        if (this.c.embeddingMultiplier != null) {
            return (inputToken, position) -> {
                AbstractTensor input = embedInput.inputTokenToEmbedding(inputToken, position);
                TensorOperationsProvider.get().scale(this.c.embeddingMultiplier.floatValue(), input, 0, this.c.embeddingLength);
                return input;
            };
        }
        return embedInput;
    }

    @Override
    protected boolean addBosToken() {
        return false;
    }
}

