/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.model.gemma2;

import com.github.tjake.jlama.math.FloatConversions;
import com.github.tjake.jlama.model.AbstractModel;
import com.github.tjake.jlama.model.CausalSelfAttention;
import com.github.tjake.jlama.model.LayerNorm;
import com.github.tjake.jlama.model.MLPBlock;
import com.github.tjake.jlama.model.ModelSupport;
import com.github.tjake.jlama.model.RMSNorm;
import com.github.tjake.jlama.model.TransformerBlock;
import com.github.tjake.jlama.model.functions.EmbedInput;
import com.github.tjake.jlama.model.functions.SampleOutput;
import com.github.tjake.jlama.model.llama.LlamaModel;
import com.github.tjake.jlama.safetensors.Config;
import com.github.tjake.jlama.safetensors.DType;
import com.github.tjake.jlama.safetensors.WeightLoader;
import com.github.tjake.jlama.safetensors.tokenizer.Tokenizer;
import com.github.tjake.jlama.tensor.AbstractTensor;
import com.github.tjake.jlama.tensor.operations.TensorOperationsProvider;
import java.util.Optional;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gemma2Model
extends LlamaModel {
    private static final Logger logger = LoggerFactory.getLogger(Gemma2Model.class);
    private final float embeddingScalingFactor;
    private AbstractTensor wte;

    public Gemma2Model(Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        this(AbstractModel.InferenceType.FULL_GENERATION, config, weights, tokenizer, workingDType, workingQType, modelQType);
    }

    public Gemma2Model(AbstractModel.InferenceType inferenceType, Config config, WeightLoader weights, Tokenizer tokenizer, DType workingDType, DType workingQType, Optional<DType> modelQType) {
        super(inferenceType, config, weights, tokenizer, workingDType, workingQType, modelQType);
        this.embeddingScalingFactor = FloatConversions.bFloat16ToFloat32(FloatConversions.float32ToBFloat16((float)Math.pow(this.c.embeddingLength, 0.5)));
    }

    @Override
    public ModelSupport.ModelType getModelType() {
        return ModelSupport.ModelType.GEMMA2;
    }

    @Override
    protected TransformerBlock[] loadTransformerBlockWeights() {
        DType qType = this.modelQType.orElse(this.modelDType);
        if (qType != this.modelDType) {
            logger.info("Quantizing model with {} - Please hold...", (Object)qType);
        }
        TransformerBlock[] transformerBlocks = new TransformerBlock[this.c.dctx().numberOfLayers];
        IntStream.range(this.c.dctx().layerStart, this.c.dctx().layerEnd).parallel().forEach(i -> {
            String base = "model.layers." + i + ".";
            String prefix = base + "self_attn.";
            CausalSelfAttention attention = new CausalSelfAttention(this, i, this.weights.load(prefix + "q_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "k_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "v_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "o_proj.weight", this.c.dctx(), false, true).quantize(qType));
            prefix = base + "mlp.";
            MLPBlock mlp = new MLPBlock(this, this.c.activationFunction, this.weights.load(prefix + "gate_proj.weight", this.c.dctx(), true, false).quantize(qType), this.weights.load(prefix + "down_proj.weight", this.c.dctx(), false, true).quantize(qType), this.weights.load(prefix + "up_proj.weight", this.c.dctx(), true, false).quantize(qType));
            transformerBlocks[i] = new TransformerBlock(this, i, new RMSNorm((AbstractModel)this, this.weights.load(base + "input_layernorm.weight").quantize(qType), 1.0f), attention, new RMSNorm((AbstractModel)this, this.weights.load(base + "post_attention_layernorm.weight").quantize(qType), 1.0f), new RMSNorm((AbstractModel)this, this.weights.load(base + "pre_feedforward_layernorm.weight").quantize(qType), 1.0f), mlp, new RMSNorm((AbstractModel)this, this.weights.load(base + "post_feedforward_layernorm.weight").quantize(qType), 1.0f));
        });
        return transformerBlocks;
    }

    @Override
    protected EmbedInput loadInputWeights() {
        if (this.wte == null) {
            this.wte = this.weights.load("model.embed_tokens.weight").quantize(this.workingDType);
        }
        return (inputToken, position) -> {
            AbstractTensor embedding = this.makeDenseTensor(this.c.embeddingLength);
            AbstractTensor at = this.wte.slice(true, inputToken);
            if (this.wte.dType() != embedding.dType()) {
                at = TensorOperationsProvider.get().quantize(at, embedding.dType(), 0, this.c.embeddingLength);
            }
            embedding.copyFrom(at, 0, 0, this.c.embeddingLength);
            TensorOperationsProvider.get().scale(this.embeddingScalingFactor, embedding, 0, this.c.embeddingLength);
            return embedding;
        };
    }

    @Override
    protected SampleOutput loadOutputWeights() {
        DType qType = this.modelQType.orElse(this.modelDType);
        if (this.wte == null) {
            this.wte = this.weights.load("model.embed_tokens.weight").quantize(this.workingDType);
        }
        final RMSNorm layerNorm = new RMSNorm((AbstractModel)this, this.weights.load("model.norm.weight").quantize(qType), 1.0f);
        return new SampleOutput(){
            final /* synthetic */ Gemma2Model this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public LayerNorm getOutputLayerNorm() {
                return layerNorm;
            }

            @Override
            public AbstractTensor getOutputLogitsWeights() {
                return this.this$0.wte;
            }
        };
    }
}

