/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class ValueResolver {
    private static String[] wrapInStringArray(Object valueToWrap) {
        return new String[]{valueToWrap.toString()};
    }

    public static String[] resolveValueToArrayOfStrings(ApplicationContext applicationContext, String name) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory configurableBeanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
            String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(name);
            BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return ValueResolver.wrapInStringArray(name);
            }
            Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext((ConfigurableBeanFactory)configurableBeanFactory, null));
            if (result instanceof String[]) {
                return (String[])result;
            }
            if (result != null) {
                return ValueResolver.wrapInStringArray(result);
            }
            return ValueResolver.wrapInStringArray(name);
        }
        return ValueResolver.wrapInStringArray(name);
    }

    public static Integer resolveValueToInteger(ApplicationContext applicationContext, String name) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory configurableBeanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
            String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(name);
            BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return Integer.parseInt(name);
            }
            Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext((ConfigurableBeanFactory)configurableBeanFactory, null));
            if (result instanceof Integer) {
                return (Integer)result;
            }
            if (result instanceof String) {
                return Integer.parseInt((String)result);
            }
        }
        return Integer.parseInt(name);
    }

    public static boolean convertToBoolean(String s) {
        String tmpString = s.trim();
        if (tmpString.equalsIgnoreCase("true")) {
            return true;
        }
        if (tmpString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException(s + " can not be converted to boolean");
    }

    public static boolean resolveToBoolean(ApplicationContext applicationContext, String name) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableListableBeanFactory configurableBeanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
            String placeholdersResolved = configurableBeanFactory.resolveEmbeddedValue(name);
            BeanExpressionResolver exprResolver = configurableBeanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return ValueResolver.convertToBoolean(name);
            }
            Object result = exprResolver.evaluate(placeholdersResolved, new BeanExpressionContext((ConfigurableBeanFactory)configurableBeanFactory, null));
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            if (result instanceof String) {
                return ValueResolver.convertToBoolean((String)result);
            }
        }
        return ValueResolver.convertToBoolean(name);
    }
}

