/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.producer;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.producer.RqueueMessageSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;

class MessageWriter {
    private RqueueMessageTemplate rqueueMessageTemplate;
    private CompositeMessageConverter messageConverter;
    private static final long MIN_DELAY_TIME = 100L;
    private static Logger logger = LoggerFactory.getLogger(RqueueMessageSender.class);

    MessageWriter(RqueueMessageTemplate rqueueMessageTemplate, List<MessageConverter> messageConverters) {
        this(rqueueMessageTemplate, new CompositeMessageConverter(messageConverters));
    }

    MessageWriter(RqueueMessageTemplate rqueueMessageTemplate, CompositeMessageConverter compositeMessageConverter) {
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.messageConverter = compositeMessageConverter;
    }

    boolean pushMessage(String queueName, Object message, Integer retryCount, Long delayInMilliSecs) {
        RqueueMessage rqueueMessage = this.buildMessage(queueName, message, retryCount, delayInMilliSecs);
        try {
            if (delayInMilliSecs == null || delayInMilliSecs <= 100L) {
                this.rqueueMessageTemplate.add(queueName, rqueueMessage);
            } else {
                this.rqueueMessageTemplate.addWithDelay(queueName, rqueueMessage);
            }
        }
        catch (Exception e) {
            logger.error("Message could not be pushed ", (Throwable)e);
            return false;
        }
        return true;
    }

    private RqueueMessage buildMessage(String queueName, Object message, Integer retryCount, Long delayInMilliSecs) {
        Message msg = this.messageConverter.toMessage(message, null);
        if (msg == null) {
            throw new MessageConversionException("Message could not be build (null)");
        }
        return new RqueueMessage(queueName, (String)msg.getPayload(), retryCount, delayInMilliSecs);
    }

    Object convertMessageToObject(RqueueMessage message) {
        return this.messageConverter.fromMessage((Message)new GenericMessage((Object)message.getMessage()), null);
    }

    List<MessageConverter> getMessageConverters() {
        return this.messageConverter.getConverters();
    }
}

