/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.ScheduledTaskDetail;
import com.github.sonus21.rqueue.listener.ConsumerQueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.utils.QueueInfo;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class MessageScheduler
implements InitializingBean,
DisposableBean,
SmartLifecycle {
    private final Logger logger = LoggerFactory.getLogger(MessageScheduler.class);
    private static final long DEFAULT_SCRIPT_EXECUTION_TIME = 5000L;
    private static final long DEFAULT_DELAY = 5000L;
    private static final long MIN_DELAY = 10L;
    private static final int MAX_MESSAGE = 100;
    private final Object monitor = new Object();
    private final int poolSize;
    private volatile boolean running = false;
    private boolean scheduleTaskAtStartup;
    private Resource resource = new ClassPathResource("scripts/push-message.lua");
    private RedisScript<Long> redisScript;
    private MessageSchedulerListener messageSchedulerListener;
    private RedisTemplate<String, Long> redisTemplate;
    private DefaultScriptExecutor<String> defaultScriptExecutor;
    private Map<String, Boolean> queueRunningState;
    private Map<String, ScheduledTaskDetail> queueNameToScheduledTask;
    private Map<String, String> channelNameToQueueName;
    private Map<String, String> queueNameToZsetName;
    private ThreadPoolTaskScheduler scheduler;
    @Autowired
    private RqueueMessageListenerContainer rqueueMessageListenerContainer;
    @Autowired
    private RedisMessageListenerContainer redisMessageListenerContainer;

    protected Logger getLogger() {
        return this.logger;
    }

    public MessageScheduler(RedisTemplate<String, Long> redisTemplate, int poolSize, boolean scheduleTaskAtStartup) {
        this.poolSize = poolSize;
        this.scheduleTaskAtStartup = scheduleTaskAtStartup;
        this.redisTemplate = redisTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.monitor;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.monitor;
        synchronized (object) {
            this.running = true;
            this.monitor.notifyAll();
        }
        this.doStart();
    }

    protected void doStart() {
        for (String queueName : this.queueRunningState.keySet()) {
            this.startQueue(queueName);
        }
    }

    private void startQueue(String queueName) {
        if (this.queueRunningState.containsKey(queueName) && this.queueRunningState.get(queueName).booleanValue()) {
            return;
        }
        this.queueRunningState.put(queueName, true);
        if (this.isScheduleTaskAtStartup()) {
            long scheduleAt = System.currentTimeMillis() + 10L;
            this.schedule(queueName, this.getZsetName(queueName), scheduleAt, false);
        }
        this.redisMessageListenerContainer.addMessageListener((MessageListener)this.messageSchedulerListener, (Topic)new ChannelTopic(this.getChannelName(queueName)));
        this.channelNameToQueueName.put(this.getChannelName(queueName), queueName);
        this.queueNameToZsetName.put(queueName, this.getZsetName(queueName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            this.running = false;
            this.monitor.notifyAll();
        }
        this.doStop();
    }

    private void doStop() {
        for (Map.Entry<String, Boolean> runningStateByQueue : this.queueRunningState.entrySet()) {
            if (!runningStateByQueue.getValue().booleanValue()) continue;
            this.stopQueue(runningStateByQueue.getKey());
        }
        this.waitForRunningQueuesToStop();
        this.queueNameToScheduledTask.clear();
    }

    private void waitForRunningQueuesToStop() {
        for (Map.Entry<String, Boolean> queueRunningState : this.queueRunningState.entrySet()) {
            Future<?> future;
            boolean completedOrCancelled;
            String queueName = queueRunningState.getKey();
            ScheduledTaskDetail scheduledTaskDetail = this.queueNameToScheduledTask.get(queueName);
            if (scheduledTaskDetail == null || (completedOrCancelled = (future = scheduledTaskDetail.getFuture()).isCancelled() || future.isDone())) continue;
            scheduledTaskDetail.getFuture().cancel(true);
        }
    }

    private void stopQueue(String queueName) {
        Assert.isTrue((boolean)this.queueRunningState.containsKey(queueName), (String)("Queue with name '" + queueName + "' does not exist"));
        this.queueRunningState.put(queueName, false);
    }

    protected long getNextScheduleTime(long currentTime, Long value) {
        return currentTime + 5000L;
    }

    private boolean isScheduleTaskAtStartup() {
        return this.scheduleTaskAtStartup;
    }

    public void destroy() throws Exception {
        this.stop();
        if (this.scheduler != null) {
            this.scheduler.destroy();
        }
    }

    protected String getChannelName(String queueName) {
        return QueueInfo.getChannelName(queueName);
    }

    protected String getZsetName(String queueName) {
        return QueueInfo.getTimeQueueName(queueName);
    }

    protected String getThreadNamePrefix() {
        return "RQDelayed-";
    }

    protected boolean isQueueValid(ConsumerQueueDetail queueDetail) {
        return queueDetail.isDelayedQueue();
    }

    private void createScheduler(int queueCount) {
        if (queueCount == 0) {
            return;
        }
        this.scheduler = new ThreadPoolTaskScheduler();
        this.scheduler.setPoolSize(Math.min(this.poolSize, queueCount));
        this.scheduler.setThreadNamePrefix(this.getThreadNamePrefix());
        this.scheduler.setAwaitTerminationSeconds(60);
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduler.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws Exception {
        HashSet<String> queueNames = new HashSet<String>();
        for (Map.Entry<String, ConsumerQueueDetail> entry : this.rqueueMessageListenerContainer.getRegisteredQueues().entrySet()) {
            String queueName = entry.getKey();
            ConsumerQueueDetail queueDetail = entry.getValue();
            if (!this.isQueueValid(queueDetail)) continue;
            queueNames.add(queueName);
        }
        this.defaultScriptExecutor = new DefaultScriptExecutor(this.redisTemplate);
        this.messageSchedulerListener = new MessageSchedulerListener();
        this.redisScript = RedisScript.of((Resource)this.resource, Long.class);
        this.queueRunningState = new ConcurrentHashMap<String, Boolean>(queueNames.size());
        this.queueNameToScheduledTask = new ConcurrentHashMap<String, ScheduledTaskDetail>(queueNames.size());
        this.channelNameToQueueName = new ConcurrentHashMap<String, String>(queueNames.size());
        this.queueNameToZsetName = new ConcurrentHashMap<String, String>(queueNames.size());
        this.createScheduler(queueNames.size());
        for (String queueName : queueNames) {
            this.queueRunningState.put(queueName, false);
        }
    }

    private boolean isQueueActive(String queueName) {
        Boolean val = this.queueRunningState.get(queueName);
        if (val == null) {
            return false;
        }
        return val;
    }

    protected synchronized void schedule(String queueName, String zsetName, Long startTime, boolean forceSchedule) {
        boolean completedOrCancelled;
        if (!this.isQueueActive(queueName) || this.scheduler == null) {
            return;
        }
        ScheduledTaskDetail scheduledTaskDetail = this.queueNameToScheduledTask.get(queueName);
        long currentTime = System.currentTimeMillis();
        if (scheduledTaskDetail == null || forceSchedule) {
            Future future;
            long requiredDelay = Math.max(1L, startTime - currentTime);
            long taskStartTime = startTime;
            MessageMoverTask timerTask = new MessageMoverTask(queueName, zsetName);
            if (requiredDelay < 10L) {
                future = this.scheduler.submit((Runnable)timerTask);
                taskStartTime = currentTime;
            } else {
                future = this.scheduler.schedule((Runnable)timerTask, Instant.ofEpochMilli(currentTime + requiredDelay));
            }
            scheduledTaskDetail = new ScheduledTaskDetail(taskStartTime, future);
            this.queueNameToScheduledTask.put(timerTask.getQueueName(), scheduledTaskDetail);
            return;
        }
        long existingDelay = scheduledTaskDetail.getStartTime() - currentTime;
        Future<?> submittedTask = scheduledTaskDetail.getFuture();
        boolean bl = completedOrCancelled = submittedTask.isDone() || submittedTask.isCancelled();
        if (!completedOrCancelled && existingDelay < 10L) {
            try {
                submittedTask.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                // empty catch block
            }
        }
        boolean bl2 = completedOrCancelled = submittedTask.isDone() || submittedTask.isCancelled();
        if (!completedOrCancelled) {
            submittedTask.cancel(true);
        }
        MessageMoverTask timerTask = new MessageMoverTask(queueName, zsetName);
        ScheduledFuture future = this.scheduler.schedule((Runnable)timerTask, Instant.ofEpochMilli(this.getNextScheduleTime(System.currentTimeMillis(), startTime)));
        scheduledTaskDetail.setFuture(future);
        scheduledTaskDetail.setStartTime(startTime);
    }

    private class MessageSchedulerListener
    implements MessageListener {
        private MessageSchedulerListener() {
        }

        public void onMessage(Message message, byte[] pattern) {
            if (message.getBody().length == 0 || message.getChannel().length == 0) {
                return;
            }
            String body = new String(message.getBody());
            String channel = new String(message.getChannel());
            try {
                Long startTime = Long.parseLong(body);
                String queueName = (String)MessageScheduler.this.channelNameToQueueName.get(channel);
                if (queueName == null) {
                    MessageScheduler.this.getLogger().warn("Unknown channel name {}", (Object)channel);
                    return;
                }
                String zsetName = (String)MessageScheduler.this.queueNameToZsetName.get(queueName);
                if (zsetName == null) {
                    MessageScheduler.this.getLogger().warn("Unknown zset name {}", (Object)queueName);
                    return;
                }
                MessageScheduler.this.schedule(queueName, zsetName, startTime, false);
            }
            catch (NumberFormatException e) {
                MessageScheduler.this.getLogger().error("Invalid data {} on channel {}", (Object)body, (Object)channel);
            }
        }
    }

    private class MessageMoverTask
    implements Runnable {
        private final String queueName;
        private final String zsetName;

        String getQueueName() {
            return this.queueName;
        }

        MessageMoverTask(String queueName, String zsetName) {
            this.queueName = queueName;
            this.zsetName = zsetName;
        }

        @Override
        public void run() {
            try {
                if (MessageScheduler.this.isQueueActive(this.queueName)) {
                    long currentTime = System.currentTimeMillis();
                    Long value = (Long)MessageScheduler.this.defaultScriptExecutor.execute(MessageScheduler.this.redisScript, Arrays.asList(this.queueName, this.zsetName), new Object[]{currentTime, 100});
                    MessageScheduler.this.schedule(this.queueName, this.zsetName, MessageScheduler.this.getNextScheduleTime(System.currentTimeMillis(), value), true);
                }
            }
            catch (RedisSystemException currentTime) {
            }
            catch (Exception e) {
                MessageScheduler.this.getLogger().warn("Task execution failed for queue: {}", (Object)this.queueName, (Object)e);
            }
        }
    }
}

