/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;

public class GenericMessageConverter
implements MessageConverter {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(GenericMessageConverter.class);

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        try {
            Msg msg = (Msg)objectMapper.readValue((String)message.getPayload(), Msg.class);
            Class<?> c = Class.forName(msg.getName());
            return objectMapper.readValue(msg.msg, c);
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            logger.warn("Exception", (Throwable)e);
            return null;
        }
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        String name = payload.getClass().getName();
        try {
            String msg = objectMapper.writeValueAsString(payload);
            Msg message = new Msg(msg, name);
            return new GenericMessage((Object)objectMapper.writeValueAsString((Object)message));
        }
        catch (JsonProcessingException e) {
            logger.error("Serialisation failed", (Throwable)e);
            return null;
        }
    }

    private static class Msg {
        private String msg;
        private String name;

        public Msg() {
        }

        public Msg(String msg, String name) {
            this.msg = msg;
            this.name = name;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

