/*
 * Decompiled with CFR 0.152.
 */
package com.github.skjolber.mockito.rest.spring;

import com.github.skjolber.mockito.rest.spring.MockitoSpringContainerStarter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class MockitoSpringConfiguration
extends AbstractConfiguration
implements ApplicationListener<ApplicationContextEvent> {
    private List<Class<?>> contextBeans;
    private List<Class<?>> mockTargetBeans;
    private Map<Class<?>, Object> map = new HashMap();

    public MockitoSpringConfiguration(List<Class<?>> mockTargetBeans, List<Class<?>> contextBeans) {
        this.mockTargetBeans = mockTargetBeans;
        this.contextBeans = contextBeans;
    }

    public void configure(WebAppContext context) throws Exception {
        MockitoSpringContainerStarter starter = new MockitoSpringContainerStarter(context, this.mockTargetBeans, this.contextBeans, this);
        context.addBean((Object)starter, true);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext applicationContext = event.getApplicationContext();
            for (Class<?> bean : this.mockTargetBeans) {
                Object value = applicationContext.getBean(bean);
                this.map.put(bean, value);
            }
        }
    }

    public Object get(Class<?> cls) {
        return this.map.get(cls);
    }

    public Map<Class<?>, Object> getAll() {
        return this.map;
    }
}

