/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.packager.rpm;

import com.typesafe.sbt.packager.linux.LinuxPackageMapping;
import com.typesafe.sbt.packager.linux.LinuxSymlink$;
import com.typesafe.sbt.packager.rpm.RpmMetadata;
import com.typesafe.sbt.packager.rpm.RpmSpec;
import java.io.File;
import java.io.Serializable;
import sbt.io.RichFile$;
import sbt.package$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger$;

public final class RpmHelper$ {
    public static RpmHelper$ MODULE$;
    private final Seq<String> topleveldirs;

    static {
        new RpmHelper$();
    }

    public String hostVendor() {
        return Process$.MODULE$.apply((Seq)new .colon.colon((Object)"rpm", (List)new .colon.colon((Object)"-E", (List)new .colon.colon((Object)"%{_host_vendor}", (List)Nil$.MODULE$)))).$bang$bang();
    }

    public File stage(RpmSpec spec, File workArea, Logger log) {
        this.buildWorkArea(workArea);
        this.copyFiles(spec, workArea, log);
        this.writeSpecFile(spec, workArea, log);
        spec.validate(log);
        return workArea;
    }

    public File defaultRpmArtifactPath(File stagingArea, RpmMetadata meta) {
        return RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(stagingArea), "RPMS")), meta.arch())), new StringBuilder(7).append(meta.name()).append("-").append(meta.version()).append("-").append(meta.release()).append(".").append(meta.arch()).append(".rpm").toString());
    }

    public File buildRpm(RpmSpec spec, File stagingArea, Logger log) {
        this.buildPackage(stagingArea, spec, log);
        return this.defaultRpmArtifactPath(stagingArea, spec.meta());
    }

    private void copyFiles(RpmSpec spec, File workArea, Logger log) {
        File buildroot = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), "tmp-buildroot");
        package$.MODULE$.IO().createDirectories((Traversable)spec.mappings().flatMap((Function1 & Serializable & scala.Serializable)mapping -> (Traversable)((TraversableLike)mapping.mappings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RpmHelper$.$anonfun$copyFiles$3(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RpmHelper$.$anonfun$copyFiles$4(x$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String dest = (String)tuple2._2();
            File target = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(buildroot), dest);
            Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)target);
            return tuple22;
        }, Traversable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            File target;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$4;
                    if (tuple2 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    target = (File)tuple2._2();
                    if (tuple22 != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            File file = target;
            return file;
        }, Traversable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()));
        spec.mappings().foreach((Function1 & Serializable & scala.Serializable)mapping -> {
            RpmHelper$.$anonfun$copyFiles$7(buildroot, log, mapping);
            return BoxedUnit.UNIT;
        });
        LinuxSymlink$.MODULE$.makeSymLinks(spec.symlinks(), buildroot, false);
    }

    private File writeSpecFile(RpmSpec spec, File workArea, Logger log) {
        File specdir = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), "SPECS");
        File rpmBuildroot = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), "buildroot");
        File tmpBuildRoot = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), "tmp-buildroot");
        File specfile = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(specdir), new StringBuilder(5).append(spec.meta().name()).append(".spec").toString());
        log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Creating SPEC file: ").append(specfile.getAbsolutePath()).toString());
        package$.MODULE$.IO().write(specfile, spec.writeSpec(rpmBuildroot, tmpBuildRoot), package$.MODULE$.IO().write$default$3(), package$.MODULE$.IO().write$default$4());
        return specfile;
    }

    private void buildPackage(File workArea, RpmSpec spec, Logger log) {
        File buildRoot = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), "buildroot");
        File specsDir = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), "SPECS");
        boolean gpg = false;
        package$.MODULE$.IO().withTemporaryDirectory((Function1 & Serializable & scala.Serializable)tmpRpmBuildDir -> {
            RpmHelper$.$anonfun$buildPackage$1(spec, buildRoot, workArea, gpg, log, specsDir, tmpRpmBuildDir);
            return BoxedUnit.UNIT;
        });
    }

    private void buildWorkArea(File workArea) {
        Object object = !workArea.exists() ? BoxesRunTime.boxToBoolean((boolean)workArea.mkdirs()) : BoxedUnit.UNIT;
        ((IterableLike)this.topleveldirs.map((Function1 & Serializable & scala.Serializable)x$12 -> RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(workArea), x$12), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)RpmHelper$.$anonfun$buildWorkArea$2(d)));
    }

    public String evalMacro(String mcro) {
        return Process$.MODULE$.apply((Seq)new .colon.colon((Object)"rpm", (List)new .colon.colon((Object)"--eval", (List)new .colon.colon((Object)new StringBuilder(11).append('%').append(mcro).toString(), (List)Nil$.MODULE$)))).$bang$bang();
    }

    private static final void copyWithZip$1(File from, File to, boolean zipped, Logger log$1) {
        log$1.debug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Copying %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from, to})));
        if (zipped) {
            package$.MODULE$.IO().gzip(from, to);
        } else {
            package$.MODULE$.IO().copyFile(from, to, true, package$.MODULE$.IO().copyFile$default$4());
        }
    }

    public static final /* synthetic */ boolean $anonfun$copyFiles$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$copyFiles$4(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        boolean bl = file.isDirectory();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$copyFiles$8(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$copyFiles$9(Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        boolean bl = file.exists() && !file.isDirectory();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$copyFiles$11(LinuxPackageMapping mapping$1, Logger log$1, Tuple2 x$8) {
        File target;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$8;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                target = (File)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        File file = (File)tuple2._1();
        RpmHelper$.copyWithZip$1(file, target, mapping$1.zipped(), log$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$copyFiles$7(File buildroot$1, Logger log$1, LinuxPackageMapping mapping) {
        ((GenericTraversableTemplate)mapping.mappings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)RpmHelper$.$anonfun$copyFiles$8(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RpmHelper$.$anonfun$copyFiles$9(x$5))).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String dest = (String)tuple2._2();
            File target = RichFile$.MODULE$.$div$extension(package$.MODULE$.fileToRichFile(buildroot$1), dest);
            Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)target);
            return tuple22;
        }, Traversable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            RpmHelper$.$anonfun$copyFiles$11(mapping, log$1, x$8);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$buildPackage$1(RpmSpec spec$1, File buildRoot$1, File workArea$1, boolean gpg$1, Logger log$2, File specsDir$1, File tmpRpmBuildDir) {
        Seq seq;
        Option<String> option = spec$1.setarch();
        if (option instanceof Some) {
            Some some = (Some)option;
            String arch = (String)some.value();
            seq = (Seq)new .colon.colon((Object)"setarch", (List)new .colon.colon((Object)arch, (List)Nil$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Seq args = (Seq)((TraversableLike)((TraversableLike)seq.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rpmbuild", "-bb", "--target", new StringBuilder(0).append(spec$1.meta().arch()).append('-').append(spec$1.meta().vendor()).append('-').append(spec$1.meta().os()).toString(), "--buildroot", buildRoot$1.getAbsolutePath(), "--define", new StringBuilder(8).append("_topdir ").append(workArea$1.getAbsolutePath()).toString(), "--define", new StringBuilder(9).append("_tmppath ").append(tmpRpmBuildDir.getAbsolutePath()).toString()})), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(gpg$1 ? new .colon.colon((Object)"--define", (List)new .colon.colon((Object)"_gpg_name <insert keyname>", (List)new .colon.colon((Object)"--sign", (List)Nil$.MODULE$))) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new StringBuilder(5).append(spec$1.meta().name()).append(".spec").toString(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        log$2.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Executing rpmbuild with: ").append(args.mkString(" ")).toString());
        ArrayBuffer outputBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int n = Process$.MODULE$.apply(args, (Option)new Some((Object)specsDir$1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(ProcessLogger$.MODULE$.apply((Function1 & Serializable & scala.Serializable)o -> {
            outputBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{o}));
            return BoxedUnit.UNIT;
        }));
        switch (n) {
            case 0: {
                try {
                    outputBuffer.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                        log$2.info((Function0 & Serializable & scala.Serializable)() -> x$9);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (NullPointerException e) {
                    outputBuffer.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                        Predef$.MODULE$.println((Object)x$10);
                        return BoxedUnit.UNIT;
                    });
                }
                break;
            }
            default: {
                outputBuffer.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    log$2.error((Function0 & Serializable & scala.Serializable)() -> x$11);
                    return BoxedUnit.UNIT;
                });
                throw scala.sys.package$.MODULE$.error(new StringBuilder(60).append("Unable to run rpmbuild, check output for details. Errorcode ").append(n).toString());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildWorkArea$2(File d) {
        block0: {
            if (!d.exists()) break block0;
            package$.MODULE$.IO().delete(d);
        }
        return d.mkdir();
    }

    private RpmHelper$() {
        MODULE$ = this;
        this.topleveldirs = (Seq)new .colon.colon((Object)"BUILD", (List)new .colon.colon((Object)"RPMS", (List)new .colon.colon((Object)"SOURCES", (List)new .colon.colon((Object)"SPECS", (List)new .colon.colon((Object)"SRPMS", (List)new .colon.colon((Object)"tmp-buildroot", (List)new .colon.colon((Object)"buildroot", (List)Nil$.MODULE$)))))));
    }
}

