/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.LintProblem;
import com.github.sbaudoin.yamllint.rules.TokenRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;

public class OctalValues
extends TokenRule {
    public static final String OPTION_FORBID_IMPLICIT_OCTAL = "forbid-implicit-octal";
    public static final String OPTION_FORBID_EXPLICIT_OCTAL = "forbid-explicit-octal";

    public OctalValues() {
        this.registerOption(OPTION_FORBID_IMPLICIT_OCTAL, false);
        this.registerOption(OPTION_FORBID_EXPLICIT_OCTAL, false);
    }

    @Override
    public List<LintProblem> check(Map<Object, Object> conf, Token token, Token prev, Token next, Token nextnext, Map<String, Object> context) {
        String val;
        ArrayList<LintProblem> problems = new ArrayList<LintProblem>();
        if (prev instanceof TagToken) {
            return problems;
        }
        if (((Boolean)conf.get(OPTION_FORBID_IMPLICIT_OCTAL)).booleanValue() && token instanceof ScalarToken && ((ScalarToken)token).getStyle().getChar() == null && this.isDigit(val = ((ScalarToken)token).getValue()) && val.length() > 1 && val.charAt(0) == '0') {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getEndMark().getColumn() + 1, "forbidden implicit octal value \"" + ((ScalarToken)token).getValue() + "\""));
        }
        if (((Boolean)conf.get(OPTION_FORBID_EXPLICIT_OCTAL)).booleanValue() && token instanceof ScalarToken && ((ScalarToken)token).getStyle().getChar() == null && (val = ((ScalarToken)token).getValue()).length() > 2 && "0o".equals(val.substring(0, 2)) && this.isDigit(val.substring(2))) {
            problems.add(new LintProblem(token.getStartMark().getLine() + 1, token.getEndMark().getColumn() + 1, "forbidden explicit octal value \"" + ((ScalarToken)token).getValue() + "\""));
        }
        return problems;
    }
}

