/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.BCF2Encoder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BCF2FieldEncoder {
    final VCFCompoundHeaderLine headerLine;
    final BCF2Type staticType;
    final int dictionaryOffset;
    final BCF2Type dictionaryOffsetType;

    private BCF2FieldEncoder(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map, BCF2Type bCF2Type) {
        this.headerLine = vCFCompoundHeaderLine;
        this.staticType = bCF2Type;
        Integer n = map.get(this.getField());
        if (n == null) {
            throw new IllegalStateException("Format error: could not find string " + this.getField() + " in header as required by BCF");
        }
        this.dictionaryOffset = n;
        this.dictionaryOffsetType = BCF2Utils.determineIntegerType(n);
    }

    public final String getField() {
        return this.headerLine.getID();
    }

    public final void writeFieldKey(BCF2Encoder bCF2Encoder) throws IOException {
        bCF2Encoder.encodeTypedInt(this.dictionaryOffset, this.dictionaryOffsetType);
    }

    public String toString() {
        return "BCF2FieldEncoder for " + this.getField() + " with count " + (Object)((Object)this.getCountType()) + " encoded with " + this.getClass().getSimpleName();
    }

    protected final VCFHeaderLineCount getCountType() {
        return this.headerLine.getCountType();
    }

    public boolean hasConstantNumElements() {
        return this.getCountType() == VCFHeaderLineCount.INTEGER;
    }

    public boolean hasValueDeterminedNumElements() {
        return this.getCountType() == VCFHeaderLineCount.UNBOUNDED;
    }

    public boolean hasContextDeterminedNumElements() {
        return !this.hasConstantNumElements() && !this.hasValueDeterminedNumElements();
    }

    public int numElements() {
        return this.headerLine.getCount();
    }

    public int numElements(Object object) {
        return this.numElementsFromValue(object);
    }

    public int numElements(VariantContext variantContext) {
        return this.headerLine.getCount(variantContext);
    }

    public final int numElements(VariantContext variantContext, Object object) {
        if (this.hasConstantNumElements()) {
            return this.numElements();
        }
        if (this.hasContextDeterminedNumElements()) {
            return this.numElements(variantContext);
        }
        return this.numElements(object);
    }

    protected int numElementsFromValue(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof List) {
            return ((List)object).size();
        }
        return 1;
    }

    public final boolean isStaticallyTyped() {
        return !this.isDynamicallyTyped();
    }

    public final boolean isDynamicallyTyped() {
        return this.staticType == null;
    }

    public final BCF2Type getType(Object object) {
        return this.isDynamicallyTyped() ? this.getDynamicType(object) : this.getStaticType();
    }

    public final BCF2Type getStaticType() {
        return this.staticType;
    }

    public BCF2Type getDynamicType(Object object) {
        throw new IllegalStateException("BUG: cannot get dynamic type for statically typed BCF2 field " + this.getField());
    }

    public abstract void encodeValue(BCF2Encoder var1, Object var2, BCF2Type var3, int var4) throws IOException;

    public static class GenericInts
    extends BCF2FieldEncoder {
        public GenericInts(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map) {
            super(vCFCompoundHeaderLine, map, null);
        }

        @Override
        public BCF2Type getDynamicType(Object object) {
            return object == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType(BCF2Utils.toList(Integer.class, object));
        }

        @Override
        public void encodeValue(BCF2Encoder bCF2Encoder, Object object, BCF2Type bCF2Type, int n) throws IOException {
            int n2 = 0;
            for (Integer n3 : BCF2Utils.toList(Integer.class, object)) {
                if (n3 == null) continue;
                bCF2Encoder.encodeRawInt(n3, bCF2Type);
                ++n2;
            }
            while (n2 < n) {
                bCF2Encoder.encodeRawMissingValue(bCF2Type);
                ++n2;
            }
        }
    }

    public static class AtomicInt
    extends BCF2FieldEncoder {
        public AtomicInt(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map) {
            super(vCFCompoundHeaderLine, map, null);
        }

        @Override
        public BCF2Type getDynamicType(Object object) {
            return object == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((Integer)object);
        }

        @Override
        public void encodeValue(BCF2Encoder bCF2Encoder, Object object, BCF2Type bCF2Type, int n) throws IOException {
            int n2 = 0;
            if (object != null) {
                bCF2Encoder.encodeRawInt((Integer)object, bCF2Type);
                ++n2;
            }
            while (n2 < n) {
                bCF2Encoder.encodeRawMissingValue(bCF2Type);
                ++n2;
            }
        }
    }

    public static class IntArray
    extends BCF2FieldEncoder {
        public IntArray(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map) {
            super(vCFCompoundHeaderLine, map, null);
        }

        @Override
        protected int numElementsFromValue(Object object) {
            return object == null ? 0 : ((int[])object).length;
        }

        @Override
        public BCF2Type getDynamicType(Object object) {
            return object == null ? BCF2Type.INT8 : BCF2Utils.determineIntegerType((int[])object);
        }

        @Override
        public void encodeValue(BCF2Encoder bCF2Encoder, Object object, BCF2Type bCF2Type, int n) throws IOException {
            int n2 = 0;
            if (object != null) {
                for (int n3 : (int[])object) {
                    bCF2Encoder.encodeRawInt(n3, bCF2Type);
                    ++n2;
                }
            }
            while (n2 < n) {
                bCF2Encoder.encodeRawMissingValue(bCF2Type);
                ++n2;
            }
        }
    }

    public static class Float
    extends BCF2FieldEncoder {
        final boolean isAtomic = this.hasConstantNumElements() && this.numElements() == 1;

        public Float(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map) {
            super(vCFCompoundHeaderLine, map, BCF2Type.FLOAT);
        }

        @Override
        public void encodeValue(BCF2Encoder bCF2Encoder, Object object, BCF2Type bCF2Type, int n) throws IOException {
            int n2 = 0;
            if (this.isAtomic) {
                if (object != null) {
                    bCF2Encoder.encodeRawFloat((Double)object);
                    ++n2;
                }
            } else {
                List<Double> list = BCF2Utils.toList(Double.class, object);
                for (Double d : list) {
                    if (d == null) continue;
                    bCF2Encoder.encodeRawFloat(d);
                    ++n2;
                }
            }
            while (n2 < n) {
                bCF2Encoder.encodeRawMissingValue(bCF2Type);
                ++n2;
            }
        }
    }

    public static class Flag
    extends BCF2FieldEncoder {
        public Flag(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map) {
            super(vCFCompoundHeaderLine, map, BCF2Type.INT8);
            if (!vCFCompoundHeaderLine.isFixedCount() || vCFCompoundHeaderLine.getCount() != 0) {
                throw new IllegalStateException("Flag encoder only supports atomic flags for field " + this.getField());
            }
        }

        @Override
        public int numElements() {
            return 1;
        }

        @Override
        public void encodeValue(BCF2Encoder bCF2Encoder, Object object, BCF2Type bCF2Type, int n) throws IOException {
            bCF2Encoder.encodeRawBytes(1, this.getStaticType());
        }
    }

    public static class StringOrCharacter
    extends BCF2FieldEncoder {
        public StringOrCharacter(VCFCompoundHeaderLine vCFCompoundHeaderLine, Map<String, Integer> map) {
            super(vCFCompoundHeaderLine, map, BCF2Type.CHAR);
        }

        @Override
        public void encodeValue(BCF2Encoder bCF2Encoder, Object object, BCF2Type bCF2Type, int n) throws IOException {
            String string = this.javaStringToBCF2String(object);
            bCF2Encoder.encodeRawString(string, Math.max(string.length(), n));
        }

        @Override
        public boolean hasConstantNumElements() {
            return false;
        }

        @Override
        public boolean hasContextDeterminedNumElements() {
            return false;
        }

        @Override
        public boolean hasValueDeterminedNumElements() {
            return true;
        }

        @Override
        protected int numElementsFromValue(Object object) {
            return object == null ? 0 : this.javaStringToBCF2String(object).length();
        }

        private String javaStringToBCF2String(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof List) {
                List list = (List)object;
                return BCF2Utils.collapseStringList(list);
            }
            if (object.getClass().isArray()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, (String[])object);
                return BCF2Utils.collapseStringList(arrayList);
            }
            return (String)object;
        }
    }
}

