/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceUtil {
    public static final byte a = 97;
    public static final byte c = 99;
    public static final byte g = 103;
    public static final byte t = 116;
    public static final byte n = 110;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    public static final byte N = 78;
    public static final byte[] VALID_BASES_UPPER = new byte[]{65, 67, 71, 84};
    public static final byte[] VALID_BASES_LOWER = new byte[]{97, 99, 103, 116};
    static final Pattern mdPat = Pattern.compile("\\G(?:([0-9]+)|([ACTGNactgn])|(\\^[ACTGNactgn]+))");

    public static String reverseComplement(String string) {
        byte[] byArray = StringUtil.stringToBytes(string);
        SequenceUtil.reverseComplement(byArray);
        return StringUtil.bytesToString(byArray);
    }

    public static boolean basesEqual(byte by, byte by2) {
        if (by == by2) {
            return true;
        }
        if (by > 90) {
            by = (byte)(by - 32);
        }
        if (by2 > 90) {
            by2 = (byte)(by2 - 32);
        }
        return by == by2;
    }

    public static boolean isNoCall(byte by) {
        return by == 78 || by == 110 || by == 46;
    }

    public static boolean isValidBase(byte by) {
        for (byte by2 : VALID_BASES_UPPER) {
            if (by != by2) continue;
            return true;
        }
        for (byte by2 : VALID_BASES_LOWER) {
            if (by != by2) continue;
            return true;
        }
        return false;
    }

    public static double calculateGc(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by != 67 && by != 71 && by != 99 && by != 103) continue;
            ++n;
        }
        return (double)n / (double)byArray.length;
    }

    public static void assertSequenceListsEqual(List<SAMSequenceRecord> list, List<SAMSequenceRecord> list2) {
        if (list != null && list2 != null) {
            if (list.size() != list2.size()) {
                throw new SequenceListsDifferException("Sequence dictionaries are not the same size (" + list.size() + ", " + list2.size() + ")");
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).isSameSequence(list2.get(i))) continue;
                String string = "";
                for (Map.Entry<String, String> object : list.get(i).getAttributes()) {
                    string = string + "/" + object.getKey() + "=" + object.getValue();
                }
                Object object = "";
                for (Map.Entry<String, String> entry : list2.get(i).getAttributes()) {
                    object = (String)object + "/" + entry.getKey() + "=" + entry.getValue();
                }
                throw new SequenceListsDifferException("Sequences at index " + i + " don't match: " + list.get(i).getSequenceIndex() + "/" + list.get(i).getSequenceLength() + "/" + list.get(i).getSequenceName() + string + " " + list2.get(i).getSequenceIndex() + "/" + list2.get(i).getSequenceLength() + "/" + list2.get(i).getSequenceName() + (String)object);
            }
        }
    }

    public static boolean areSequenceDictionariesEqual(SAMSequenceDictionary sAMSequenceDictionary, SAMSequenceDictionary sAMSequenceDictionary2) {
        if (sAMSequenceDictionary == null && sAMSequenceDictionary2 == null) {
            return true;
        }
        if (sAMSequenceDictionary == null || sAMSequenceDictionary2 == null) {
            return false;
        }
        try {
            SequenceUtil.assertSequenceListsEqual(sAMSequenceDictionary.getSequences(), sAMSequenceDictionary2.getSequences());
            return true;
        }
        catch (SequenceListsDifferException sequenceListsDifferException) {
            return false;
        }
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary sAMSequenceDictionary, SAMSequenceDictionary sAMSequenceDictionary2) {
        if (sAMSequenceDictionary == null || sAMSequenceDictionary2 == null) {
            return;
        }
        SequenceUtil.assertSequenceListsEqual(sAMSequenceDictionary.getSequences(), sAMSequenceDictionary2.getSequences());
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary sAMSequenceDictionary, SAMSequenceDictionary sAMSequenceDictionary2, File file, File file2) {
        try {
            SequenceUtil.assertSequenceDictionariesEqual(sAMSequenceDictionary, sAMSequenceDictionary2);
        }
        catch (SequenceListsDifferException sequenceListsDifferException) {
            throw new SequenceListsDifferException("In files " + file.getAbsolutePath() + " and " + file2.getAbsolutePath(), sequenceListsDifferException);
        }
    }

    public static String makeCigarStringWithPossibleClipping(int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = 0;
        if (n5 < 1) {
            n6 = 1 - n5;
            n5 = 1;
        }
        int n7 = 0;
        if (n + n2 > n3 + 1) {
            n7 = n + n2 - n3 - 1;
        }
        if ((n4 = n2 - n6 - n7) < 1) {
            throw new SAMException("Unexpected cigar string with no M op for read.");
        }
        return SequenceUtil.makeSoftClipCigar(n6) + Integer.toString(n4) + "M" + SequenceUtil.makeSoftClipCigar(n7);
    }

    public static String makeCigarStringWithIndelPossibleClipping(int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = 0;
        if (n6 < 1) {
            n7 = 1 - n6;
            n6 = 1;
        }
        int n8 = 0;
        int n9 = n + n2 - n5;
        if (n9 > n3 + 1) {
            n8 = n9 - n3 - 1;
        }
        if (n7 >= n4) {
            throw new IllegalStateException("Soft clipping entire pre-indel match. leftSoftClip: " + n7 + "; indelPosition: " + n4);
        }
        int n10 = n4 - n7;
        int n11 = n2 - n4 - (n5 > 0 ? n5 : 0) - n8;
        if (n11 < 1) {
            throw new SAMException("Unexpected cigar string with no M op for read.");
        }
        return SequenceUtil.makeSoftClipCigar(n7) + Integer.toString(n10) + "M" + Math.abs(n5) + (n5 > 0 ? "I" : "D") + Integer.toString(n11) + "M" + SequenceUtil.makeSoftClipCigar(n8);
    }

    public static String makeSoftClipCigar(int n) {
        if (n == 0) {
            return "";
        }
        return Integer.toString(n) + "S";
    }

    public static int countMismatches(SAMRecord sAMRecord, byte[] byArray) {
        return SequenceUtil.countMismatches(sAMRecord, byArray, 0, false);
    }

    public static int countMismatches(SAMRecord sAMRecord, byte[] byArray, int n) {
        return SequenceUtil.countMismatches(sAMRecord, byArray, n, false);
    }

    public static int countMismatches(SAMRecord sAMRecord, byte[] byArray, int n, boolean bl) {
        try {
            int n2 = 0;
            byte[] byArray2 = sAMRecord.getReadBases();
            for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
                int n3 = alignmentBlock.getReadStart() - 1;
                int n4 = alignmentBlock.getReferenceStart() - 1 - n;
                int n5 = alignmentBlock.getLength();
                for (int i = 0; i < n5; ++i) {
                    if (!bl) {
                        if (SequenceUtil.basesEqual(byArray2[n3 + i], byArray[n4 + i])) continue;
                        ++n2;
                        continue;
                    }
                    if (SequenceUtil.bisulfiteBasesEqual(sAMRecord.getReadNegativeStrandFlag(), byArray2[n3 + i], byArray[n4 + i])) continue;
                    ++n2;
                }
            }
            return n2;
        }
        catch (Exception exception) {
            throw new SAMException("Exception counting mismatches for read " + sAMRecord, exception);
        }
    }

    public static int countMismatches(SAMRecord sAMRecord, byte[] byArray, boolean bl) {
        return SequenceUtil.countMismatches(sAMRecord, byArray, 0, bl);
    }

    @Deprecated
    private static int countMismatches(SAMRecord sAMRecord, char[] cArray, int n) {
        int n2 = 0;
        byte[] byArray = sAMRecord.getReadBases();
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            int n3 = alignmentBlock.getReadStart() - 1;
            int n4 = alignmentBlock.getReferenceStart() - 1 - n;
            int n5 = alignmentBlock.getLength();
            for (int i = 0; i < n5; ++i) {
                if (SequenceUtil.basesEqual(byArray[n3 + i], StringUtil.charToByte(cArray[n4 + i]))) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static int sumQualitiesOfMismatches(SAMRecord sAMRecord, byte[] byArray) {
        return SequenceUtil.sumQualitiesOfMismatches(sAMRecord, byArray, 0, false);
    }

    public static int sumQualitiesOfMismatches(SAMRecord sAMRecord, byte[] byArray, int n) {
        return SequenceUtil.sumQualitiesOfMismatches(sAMRecord, byArray, n, false);
    }

    public static int sumQualitiesOfMismatches(SAMRecord sAMRecord, byte[] byArray, int n, boolean bl) {
        int n2 = 0;
        byte[] byArray2 = sAMRecord.getReadBases();
        byte[] byArray3 = sAMRecord.getBaseQualities();
        if (sAMRecord.getAlignmentStart() <= n) {
            throw new IllegalArgumentException("read.getAlignmentStart(" + sAMRecord.getAlignmentStart() + ") <= referenceOffset(" + n + ")");
        }
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            int n3 = alignmentBlock.getReadStart() - 1;
            int n4 = alignmentBlock.getReferenceStart() - 1 - n;
            int n5 = alignmentBlock.getLength();
            for (int i = 0; i < n5; ++i) {
                if (!bl) {
                    if (SequenceUtil.basesEqual(byArray2[n3 + i], byArray[n4 + i])) continue;
                    n2 += byArray3[n3 + i];
                    continue;
                }
                if (SequenceUtil.bisulfiteBasesEqual(sAMRecord.getReadNegativeStrandFlag(), byArray2[n3 + i], byArray[n4 + i])) continue;
                n2 += byArray3[n3 + i];
            }
        }
        return n2;
    }

    @Deprecated
    public static int sumQualitiesOfMismatches(SAMRecord sAMRecord, char[] cArray, int n) {
        int n2 = 0;
        byte[] byArray = sAMRecord.getReadBases();
        byte[] byArray2 = sAMRecord.getBaseQualities();
        if (sAMRecord.getAlignmentStart() <= n) {
            throw new IllegalArgumentException("read.getAlignmentStart(" + sAMRecord.getAlignmentStart() + ") <= referenceOffset(" + n + ")");
        }
        for (AlignmentBlock alignmentBlock : sAMRecord.getAlignmentBlocks()) {
            int n3 = alignmentBlock.getReadStart() - 1;
            int n4 = alignmentBlock.getReferenceStart() - 1 - n;
            int n5 = alignmentBlock.getLength();
            for (int i = 0; i < n5; ++i) {
                if (SequenceUtil.basesEqual(byArray[n3 + i], StringUtil.charToByte(cArray[n4 + i]))) continue;
                n2 += byArray2[n3 + i];
            }
        }
        return n2;
    }

    public static int countInsertedBases(Cigar cigar) {
        int n = 0;
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.INSERTION) continue;
            n += cigarElement.getLength();
        }
        return n;
    }

    public static int countDeletedBases(Cigar cigar) {
        int n = 0;
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.DELETION) continue;
            n += cigarElement.getLength();
        }
        return n;
    }

    public static int countInsertedBases(SAMRecord sAMRecord) {
        return SequenceUtil.countInsertedBases(sAMRecord.getCigar());
    }

    public static int countDeletedBases(SAMRecord sAMRecord) {
        return SequenceUtil.countDeletedBases(sAMRecord.getCigar());
    }

    public static int calculateSamNmTag(SAMRecord sAMRecord, byte[] byArray) {
        return SequenceUtil.calculateSamNmTag(sAMRecord, byArray, 0, false);
    }

    public static int calculateSamNmTag(SAMRecord sAMRecord, byte[] byArray, int n) {
        return SequenceUtil.calculateSamNmTag(sAMRecord, byArray, n, false);
    }

    public static int calculateSamNmTag(SAMRecord sAMRecord, byte[] byArray, int n, boolean bl) {
        int n2 = SequenceUtil.countMismatches(sAMRecord, byArray, n, bl);
        for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.INSERTION && cigarElement.getOperator() != CigarOperator.DELETION) continue;
            n2 += cigarElement.getLength();
        }
        return n2;
    }

    public static int calculateSamNmTagFromCigar(SAMRecord sAMRecord) {
        int n = 0;
        for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.X && cigarElement.getOperator() != CigarOperator.INSERTION && cigarElement.getOperator() != CigarOperator.DELETION) continue;
            n += cigarElement.getLength();
        }
        return n;
    }

    @Deprecated
    public static int calculateSamNmTag(SAMRecord sAMRecord, char[] cArray, int n) {
        int n2 = SequenceUtil.countMismatches(sAMRecord, cArray, n);
        for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.INSERTION && cigarElement.getOperator() != CigarOperator.DELETION) continue;
            n2 += cigarElement.getLength();
        }
        return n2;
    }

    public static byte complement(byte by) {
        switch (by) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return by;
    }

    public static void reverseComplement(byte[] byArray) {
        int n = byArray.length - 1;
        int n2 = 0;
        for (int i = n; n2 < i; ++n2, --i) {
            byte by = SequenceUtil.complement(byArray[n2]);
            byArray[n2] = SequenceUtil.complement(byArray[i]);
            byArray[i] = by;
        }
        if (byArray.length % 2 == 1) {
            byArray[n2] = SequenceUtil.complement(byArray[n2]);
        }
    }

    public static void reverseQualities(byte[] byArray) {
        int n = byArray.length - 1;
        int n2 = 0;
        for (int i = n; n2 < i; ++n2, --i) {
            byte by = byArray[n2];
            byArray[n2] = byArray[i];
            byArray[i] = by;
        }
    }

    public static boolean bisulfiteBasesEqual(boolean bl, byte by, byte by2) {
        return SequenceUtil.basesEqual(by, by2) || SequenceUtil.isBisulfiteConverted(by, by2, bl);
    }

    public static boolean bisulfiteBasesEqual(byte by, byte by2) {
        return SequenceUtil.bisulfiteBasesEqual(false, by, by2);
    }

    public static boolean isBisulfiteConverted(byte by, byte by2, boolean bl) {
        return bl ? SequenceUtil.basesEqual(by2, (byte)71) && SequenceUtil.basesEqual(by, (byte)65) : SequenceUtil.basesEqual(by2, (byte)67) && SequenceUtil.basesEqual(by, (byte)84);
    }

    public static boolean isBisulfiteConverted(byte by, byte by2) {
        return SequenceUtil.isBisulfiteConverted(by, by2, false);
    }

    public static byte[] makeReferenceFromAlignment(SAMRecord sAMRecord, boolean bl) {
        String string = sAMRecord.getStringAttribute(SAMTag.MD.name());
        if (string == null) {
            throw new SAMException("Cannot create reference from SAMRecord with no MD tag, read: " + sAMRecord.getReadName());
        }
        int n = 0;
        Cigar cigar = sAMRecord.getCigar();
        if (cigar == null) {
            throw new SAMException("Cannot create reference from SAMRecord with no CIGAR, read: " + sAMRecord.getReadName());
        }
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            n += cigarElement.getLength();
        }
        Object object = new byte[n];
        int n2 = 0;
        Matcher matcher = mdPat.matcher(string);
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = sAMRecord.getReadBases();
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            char c;
            int n5;
            int n6 = cigarElement.getLength();
            CigarOperator cigarOperator = cigarElement.getOperator();
            if (cigarOperator == CigarOperator.SKIPPED_REGION) {
                if (!bl) continue;
                for (n5 = 0; n5 < n6; ++n5) {
                    object[n2++] = 78;
                }
                continue;
            }
            if (cigarOperator.consumesReferenceBases()) {
                for (n5 = 0; n4 > 0 && n5 < n6; --n4, ++n5) {
                    object[n2++] = byArray[n3++];
                }
                while (n5 < n6) {
                    c = matcher.find();
                    if (c != '\u0000') {
                        String string2 = matcher.group(1);
                        if (string2 != null && string2.length() > 0) {
                            int n7 = Integer.parseInt(string2);
                            for (int i = 0; i < n7; ++i) {
                                if (n5 < n6) {
                                    object[n2++] = byArray[n3++];
                                } else {
                                    ++n4;
                                }
                                ++n5;
                            }
                        } else {
                            string2 = matcher.group(2);
                            if (string2 != null && string2.length() > 0) {
                                if (n5 < n6) {
                                    object[n2++] = StringUtil.charToByte(string2.charAt(0));
                                    ++n3;
                                } else {
                                    throw new IllegalStateException("Should never happen.");
                                }
                                ++n5;
                            } else {
                                string2 = matcher.group(3);
                                if (string2 != null && string2.length() > 0) {
                                    if (bl) {
                                        byte[] byArray2 = StringUtil.stringToBytes(string2);
                                        System.arraycopy(byArray2, 1, object, n2, byArray2.length - 1);
                                        n2 += byArray2.length - 1;
                                    }
                                    if ((n5 += string2.length() - 1) != n6) {
                                        throw new SAMException("Got a deletion in CIGAR (" + cigar + ", deletion " + n6 + " length) with an unequal ref insertion in MD (" + string + ", md " + n5 + " length");
                                    }
                                    if (cigarOperator != CigarOperator.DELETION) {
                                        throw new SAMException("Got an insertion in MD (" + string + ") without a corresponding deletion in cigar (" + cigar + ")");
                                    }
                                } else {
                                    c = '\u0000';
                                }
                            }
                        }
                    }
                    if (c != '\u0000') continue;
                    throw new SAMException("Illegal MD pattern: " + string + " for read " + sAMRecord.getReadName() + " with CIGAR " + sAMRecord.getCigarString());
                }
                continue;
            }
            if (!cigarOperator.consumesReadBases()) continue;
            for (n5 = 0; n5 < n6; ++n5) {
                c = cigarOperator == CigarOperator.SOFT_CLIP ? (char)'0' : '-';
                object[n2++] = StringUtil.charToByte(c);
                ++n3;
            }
        }
        if (n2 < ((Object)object).length) {
            Object object2 = new byte[n2];
            System.arraycopy(object, 0, object2, 0, n2);
            return object2;
        }
        return object;
    }

    public static void reverse(byte[] byArray, int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n;
        for (int i = n + n3; n4 < i; ++n4, --i) {
            byte by = byArray[n4];
            byArray[n4] = byArray[i];
            byArray[i] = by;
        }
        if (n2 % 2 == 1) {
            byArray[n4] = byArray[n4];
        }
    }

    public static void reverseComplement(byte[] byArray, int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n;
        for (int i = n + n3; n4 < i; ++n4, --i) {
            byte by = SequenceUtil.complement(byArray[n4]);
            byArray[n4] = SequenceUtil.complement(byArray[i]);
            byArray[i] = by;
        }
        if (n2 % 2 == 1) {
            byArray[n4] = SequenceUtil.complement(byArray[n4]);
        }
    }

    public static String calculateMD5String(byte[] byArray) throws NoSuchAlgorithmException {
        return SequenceUtil.calculateMD5String(byArray, 0, byArray.length);
    }

    public static String calculateMD5String(byte[] byArray, int n, int n2) {
        byte[] byArray2 = SequenceUtil.calculateMD5(byArray, n, n2);
        return String.format("%032x", new BigInteger(1, byArray2));
    }

    public static byte[] calculateMD5(byte[] byArray, int n, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(byArray, n, n2);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static void calculateMdAndNmTags(SAMRecord sAMRecord, byte[] byArray, boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return;
        }
        Cigar cigar = sAMRecord.getCigar();
        List<CigarElement> list = cigar.getCigarElements();
        byte[] byArray2 = sAMRecord.getReadBases();
        int n = sAMRecord.getAlignmentStart() - 1;
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = list.size();
        int n5 = 0;
        int n6 = n;
        for (int i = 0; i < n4; ++i) {
            int n7;
            CigarElement cigarElement = list.get(i);
            int n8 = cigarElement.getLength();
            CigarOperator cigarOperator = cigarElement.getOperator();
            if (cigarOperator == CigarOperator.MATCH_OR_MISMATCH || cigarOperator == CigarOperator.EQ || cigarOperator == CigarOperator.X) {
                for (n7 = 0; n7 < n8; ++n7) {
                    int n9 = n5 + n7;
                    if (byArray.length <= n6 + n7) break;
                    byte by = 0;
                    byte by2 = 0;
                    by = byArray2[n9];
                    by2 = byArray[n6 + n7];
                    if (by == by2 || by == 0) {
                        ++n2;
                        continue;
                    }
                    stringBuilder.append(n2);
                    stringBuilder.appendCodePoint(byArray[n6 + n7]);
                    n2 = 0;
                    ++n3;
                }
                if (n7 < n8) break;
                n6 += n8;
                n5 += n8;
                continue;
            }
            if (cigarOperator == CigarOperator.DELETION) {
                stringBuilder.append(n2);
                stringBuilder.append('^');
                for (n7 = 0; n7 < n8 && byArray[n6 + n7] != 0; ++n7) {
                    stringBuilder.appendCodePoint(byArray[n6 + n7]);
                }
                n2 = 0;
                if (n7 < n8) break;
                n6 += n8;
                n3 += n8;
                continue;
            }
            if (cigarOperator == CigarOperator.INSERTION || cigarOperator == CigarOperator.SOFT_CLIP) {
                n5 += n8;
                if (cigarOperator != CigarOperator.INSERTION) continue;
                n3 += n8;
                continue;
            }
            if (cigarOperator != CigarOperator.SKIPPED_REGION) continue;
            n6 += n8;
        }
        stringBuilder.append(n2);
        if (bl) {
            sAMRecord.setAttribute(SAMTag.MD.name(), (Object)stringBuilder.toString());
        }
        if (bl2) {
            sAMRecord.setAttribute(SAMTag.NM.name(), (Object)n3);
        }
    }

    public static byte upperCase(byte by) {
        return by >= 97 ? (byte)(by - 32) : by;
    }

    public static byte[] upperCase(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = SequenceUtil.upperCase(byArray[i]);
        }
        return byArray;
    }

    public static List<byte[]> generateAllKmers(int n) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        if (linkedList.size() == 0) {
            linkedList.add(new byte[n]);
        }
        block0: while (true) {
            byte[] byArray = (byte[])linkedList.remove(0);
            int n2 = -1;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                linkedList.add(byArray);
                break;
            }
            byte[] byArray2 = VALID_BASES_UPPER;
            int n3 = byArray2.length;
            int n4 = 0;
            while (true) {
                if (n4 >= n3) continue block0;
                byte by = byArray2[n4];
                byte[] byArray3 = Arrays.copyOf(byArray, byArray.length);
                byArray3[n2] = by;
                linkedList.add(byArray3);
                ++n4;
            }
            break;
        }
        return linkedList;
    }

    public static class SequenceListsDifferException
    extends SAMException {
        public SequenceListsDifferException() {
        }

        public SequenceListsDifferException(String string) {
            super(string);
        }

        public SequenceListsDifferException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public SequenceListsDifferException(Throwable throwable) {
            super(throwable);
        }
    }
}

