/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.ResourceLimitedMapFunctor;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceLimitedMap<Key, Value> {
    private static final float hashTableLoadFactor = 0.75f;
    private final LinkedHashMap<Key, Value> map;
    private final int cacheSize;
    private final ResourceLimitedMapFunctor<Key, Value> functor;

    public ResourceLimitedMap(int n, ResourceLimitedMapFunctor<Key, Value> resourceLimitedMapFunctor) {
        this.cacheSize = n;
        this.functor = resourceLimitedMapFunctor;
        int n2 = (int)Math.ceil((float)n / 0.75f) + 1;
        this.map = new LinkedHashMap<Key, Value>(n2, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key, Value> entry) {
                if (this.size() > ResourceLimitedMap.this.cacheSize) {
                    ResourceLimitedMap.this.functor.finalizeValue(entry.getKey(), entry.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    public Value get(Key Key2) {
        if (!this.map.containsKey(Key2)) {
            this.map.put(Key2, this.functor.makeValue(Key2));
        }
        return this.map.get(Key2);
    }

    public Value remove(Key Key2) {
        return (Value)this.map.remove(Key2);
    }

    public boolean containsKey(Key Key2) {
        return this.map.containsKey(Key2);
    }

    public void finalizeAll() {
        for (Map.Entry<Key, Value> entry : this.map.entrySet()) {
            this.functor.finalizeValue(entry.getKey(), entry.getValue());
        }
        this.map.clear();
    }
}

