/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5CalculatingOutputStream
extends OutputStream {
    private final OutputStream os;
    private final MessageDigest md5;
    private final File digestFile;
    private String hash = null;

    public Md5CalculatingOutputStream(OutputStream outputStream, File file) {
        this.os = outputStream;
        this.digestFile = file;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.md5.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("MD5 algorithm not found", noSuchAlgorithmException);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.md5.update((byte)n);
        this.os.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.md5.update(byArray);
        this.os.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.md5.update(byArray, n, n2);
        this.os.write(byArray, n, n2);
    }

    public String md5() {
        if (this.hash == null) {
            throw new SAMException("Attempting to access md5 digest before the entire file is written!  Call close first.");
        }
        return this.hash;
    }

    private String makeHash() {
        if (this.hash == null) {
            this.hash = new BigInteger(1, this.md5.digest()).toString(16);
            if (this.hash.length() != 32) {
                this.hash = "00000000000000000000000000000000".substring(0, 32 - this.hash.length()) + this.hash;
            }
            return this.hash;
        }
        throw new SAMException("Calling close on Md5CalculatingOutputStream twice!");
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.makeHash();
        if (this.digestFile != null) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.digestFile));
            bufferedWriter.write(this.hash);
            bufferedWriter.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }
}

