/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.metrics;

import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.util.StringUtil;

public class VersionHeader
implements Header {
    private String versionedItem;
    private String versionString;

    @Override
    public void parse(String string) {
        String[] stringArray = string.split("\t");
        this.versionedItem = stringArray[0];
        this.versionString = stringArray[1];
    }

    @Override
    public String toString() {
        return this.versionedItem + "\t" + this.versionString;
    }

    public String getVersionedItem() {
        return this.versionedItem;
    }

    public void setVersionedItem(String string) {
        this.versionedItem = StringUtil.assertCharactersNotInString(string, '\t', '\n');
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String string) {
        this.versionString = StringUtil.assertCharactersNotInString(string, '\t', '\n');
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VersionHeader versionHeader = (VersionHeader)object;
        if (this.versionString != null ? !this.versionString.equals(versionHeader.versionString) : versionHeader.versionString != null) {
            return false;
        }
        return !(this.versionedItem != null ? !this.versionedItem.equals(versionHeader.versionedItem) : versionHeader.versionedItem != null);
    }

    public int hashCode() {
        int n = this.versionedItem != null ? this.versionedItem.hashCode() : 0;
        n = 31 * n + (this.versionString != null ? this.versionString.hashCode() : 0);
        return n;
    }
}

