/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.liftover;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.liftover.Chain;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LiftOver {
    private static final Log LOG = Log.getInstance(LiftOver.class);
    public static final double DEFAULT_LIFTOVER_MINMATCH = 0.95;
    private double liftOverMinMatch = 0.95;
    private final OverlapDetector<Chain> chains;

    public LiftOver(File file) {
        IOUtil.assertFileIsReadable(file);
        this.chains = Chain.loadChains(file);
    }

    public void validateToSequences(SAMSequenceDictionary sAMSequenceDictionary) {
        for (Chain chain : this.chains.getAll()) {
            if (sAMSequenceDictionary.getSequence(chain.toSequenceName) != null) continue;
            throw new SAMException("Sequence " + chain.toSequenceName + " from chain file is not found in sequence dictionary.");
        }
    }

    public Interval liftOver(Interval interval) {
        return this.liftOver(interval, this.liftOverMinMatch);
    }

    public Interval liftOver(Interval interval, double d) {
        if (interval.length() == 0) {
            throw new IllegalArgumentException("Zero-length interval cannot be lifted over.  Interval: " + interval.getName());
        }
        Chain chain = null;
        TargetIntersection targetIntersection = null;
        double d2 = d * (double)interval.length();
        for (Chain chain2 : this.chains.getOverlaps(interval)) {
            TargetIntersection targetIntersection2 = LiftOver.targetIntersection(chain2, interval);
            if (targetIntersection2 != null && (double)targetIntersection2.intersectionLength >= d2) {
                if (chain != null) {
                    return null;
                }
                chain = chain2;
                targetIntersection = targetIntersection2;
                continue;
            }
            if (targetIntersection2 == null) continue;
            LOG.info("Interval " + interval.getName() + " failed to match chain " + chain2.id + " because intersection length " + targetIntersection2.intersectionLength + " < minMatchSize " + d2 + " (" + (float)targetIntersection2.intersectionLength / (float)interval.length() + " < " + d + ")");
        }
        if (chain == null) {
            return null;
        }
        return LiftOver.createToInterval(interval.getName(), targetIntersection);
    }

    public List<PartialLiftover> diagnosticLiftover(Interval interval) {
        ArrayList<PartialLiftover> arrayList = new ArrayList<PartialLiftover>();
        if (interval.length() == 0) {
            throw new IllegalArgumentException("Zero-length interval cannot be lifted over.  Interval: " + interval.getName());
        }
        for (Chain chain : this.chains.getOverlaps(interval)) {
            Interval interval2;
            TargetIntersection targetIntersection = LiftOver.targetIntersection(chain, interval2 = interval.intersect(chain.interval));
            if (targetIntersection == null) {
                arrayList.add(new PartialLiftover(interval2, chain.id));
                continue;
            }
            Interval interval3 = LiftOver.createToInterval(interval.getName(), targetIntersection);
            float f = (float)targetIntersection.intersectionLength / (float)interval.length();
            arrayList.add(new PartialLiftover(interval2, interval3, targetIntersection.chain.id, f));
        }
        return arrayList;
    }

    private static Interval createToInterval(String string, TargetIntersection targetIntersection) {
        int n = targetIntersection.chain.getBlock((int)targetIntersection.firstBlockIndex).toStart + targetIntersection.startOffset;
        int n2 = targetIntersection.chain.getBlock(targetIntersection.lastBlockIndex).getToEnd() - targetIntersection.offsetFromEnd;
        if (n2 <= n || n < 0) {
            throw new SAMException("Something strange lifting over interval " + string);
        }
        if (targetIntersection.chain.toNegativeStrand) {
            int n3 = targetIntersection.chain.toSequenceSize - n2;
            int n4 = targetIntersection.chain.toSequenceSize - n;
            n = n3;
            n2 = n4;
        }
        return new Interval(targetIntersection.chain.toSequenceName, n + 1, n2, targetIntersection.chain.toNegativeStrand, string);
    }

    private static TargetIntersection targetIntersection(Chain chain, Interval interval) {
        int n = 0;
        int n2 = interval.getStart() - 1;
        int n3 = interval.getEnd();
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        List<Chain.ContinuousBlock> list = chain.getBlocks();
        for (int i = 0; i < list.size(); ++i) {
            Chain.ContinuousBlock continuousBlock = list.get(i);
            if (continuousBlock.fromStart >= n3) break;
            if (continuousBlock.getFromEnd() <= n2) continue;
            if (n4 == -1) {
                n4 = i;
                n6 = n2 > continuousBlock.fromStart ? n2 - continuousBlock.fromStart : 0;
            }
            n5 = i;
            n7 = continuousBlock.getFromEnd() > n3 ? continuousBlock.getFromEnd() - n3 : 0;
            int n8 = Math.min(n3, continuousBlock.getFromEnd()) - Math.max(n2, continuousBlock.fromStart);
            if (n8 <= 0) {
                throw new SAMException("Should have been some intersection.");
            }
            n += n8;
        }
        if (n == 0) {
            return null;
        }
        return new TargetIntersection(chain, n, n6, n7, n4, n5);
    }

    public double getLiftOverMinMatch() {
        return this.liftOverMinMatch;
    }

    public void setLiftOverMinMatch(double d) {
        this.liftOverMinMatch = d;
    }

    public static class PartialLiftover {
        final Interval fromInterval;
        final Interval toInterval;
        final int chainId;
        final float percentLiftedOver;

        PartialLiftover(Interval interval, Interval interval2, int n, float f) {
            this.fromInterval = interval;
            this.toInterval = interval2;
            this.chainId = n;
            this.percentLiftedOver = f;
        }

        PartialLiftover(Interval interval, int n) {
            this.fromInterval = interval;
            this.toInterval = null;
            this.chainId = n;
            this.percentLiftedOver = 0.0f;
        }

        public String toString() {
            if (this.toInterval == null) {
                return this.fromInterval.toString() + " (len " + this.fromInterval.length() + ")=>null using chain " + this.chainId;
            }
            String string = this.toInterval.isNegativeStrand() ? "-" : "+";
            return this.fromInterval.toString() + " (len " + this.fromInterval.length() + ")=>" + this.toInterval + "(" + string + ") using chain " + this.chainId + " ; pct matched " + this.percentLiftedOver;
        }
    }

    private static class TargetIntersection {
        final Chain chain;
        final int intersectionLength;
        final int startOffset;
        final int offsetFromEnd;
        final int firstBlockIndex;
        final int lastBlockIndex;

        TargetIntersection(Chain chain, int n, int n2, int n3, int n4, int n5) {
            this.chain = chain;
            this.intersectionLength = n;
            this.startOffset = n2;
            this.offsetFromEnd = n3;
            this.firstBlockIndex = n4;
            this.lastBlockIndex = n5;
        }
    }
}

