/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.liftover;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.OverlapDetector;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

class Chain {
    private static final Pattern SPLITTER = Pattern.compile("\\s");
    final double score;
    final Interval interval;
    final String fromSequenceName;
    final int fromSequenceSize;
    final int fromChainStart;
    final int fromChainEnd;
    final String toSequenceName;
    final int toSequenceSize;
    final boolean toNegativeStrand;
    final int toChainStart;
    final int toChainEnd;
    final int id;
    private final List<ContinuousBlock> blockList = new ArrayList<ContinuousBlock>();

    private Chain(double d, String string, int n, int n2, int n3, String string2, int n4, boolean bl, int n5, int n6, int n7) {
        this.interval = new Interval(string, n2 + 1, n3);
        this.score = d;
        this.toChainEnd = n6;
        this.toSequenceName = string2;
        this.toNegativeStrand = bl;
        this.toSequenceSize = n4;
        this.toChainStart = n5;
        this.fromChainEnd = n3;
        this.fromSequenceName = string;
        this.fromSequenceSize = n;
        this.fromChainStart = n2;
        this.id = n7;
    }

    private void addBlock(int n, int n2, int n3) {
        this.blockList.add(new ContinuousBlock(n, n2, n3));
    }

    ContinuousBlock getBlock(int n) {
        return this.blockList.get(n);
    }

    List<ContinuousBlock> getBlocks() {
        return Collections.unmodifiableList(this.blockList);
    }

    void write(PrintWriter printWriter) {
        printWriter.printf("chain\t%f\t%s\t%d\t+\t%d\t%d\t%s\t%d\t%s\t%d\t%d\t%d\n", this.score, this.fromSequenceName, this.fromSequenceSize, this.fromChainStart, this.fromChainEnd, this.toSequenceName, this.toSequenceSize, this.toNegativeStrand ? "-" : "+", this.toChainStart, this.toChainEnd, this.id);
        for (int i = 0; i < this.blockList.size() - 1; ++i) {
            ContinuousBlock continuousBlock = this.blockList.get(i);
            ContinuousBlock continuousBlock2 = this.blockList.get(i + 1);
            int n = continuousBlock2.fromStart - continuousBlock.getFromEnd();
            int n2 = continuousBlock2.toStart - continuousBlock.getToEnd();
            printWriter.printf("%d\t%d\t%d\n", continuousBlock.blockLength, n, n2);
        }
        printWriter.printf("%d\n", this.blockList.get((int)(this.blockList.size() - 1)).blockLength);
        printWriter.println();
    }

    void validate() {
        this.validatePositive("fromSequenceSize", this.fromSequenceSize);
        this.validateNonNegative("fromChainStart", this.fromChainStart);
        this.validateNonNegative("fromChainEnd", this.fromChainEnd);
        this.validatePositive("toSequenceSize", this.toSequenceSize);
        this.validateNonNegative("toChainStart", this.toChainStart);
        this.validateNonNegative("toChainEnd", this.toChainEnd);
        int n = this.fromChainEnd - this.fromChainStart;
        this.validatePositive("from length", n);
        int n2 = this.toChainEnd - this.toChainStart;
        this.validatePositive("to length", n2);
        if (n > this.fromSequenceSize) {
            throw new SAMException("From chain length (" + n + ") < from sequence length (" + this.fromSequenceSize + ") for chain " + this.id);
        }
        if (n2 > this.toSequenceSize) {
            throw new SAMException("To chain length (" + n2 + ") < to sequence length (" + this.toSequenceSize + ") for chain " + this.id);
        }
        if (this.fromSequenceName.isEmpty()) {
            throw new SAMException("Chain " + this.id + "has empty from sequence name.");
        }
        if (this.toSequenceName.isEmpty()) {
            throw new SAMException("Chain " + this.id + "has empty to sequence name.");
        }
        if (this.blockList.isEmpty()) {
            throw new SAMException("Chain " + this.id + " has empty block list.");
        }
        ContinuousBlock continuousBlock = this.blockList.get(0);
        if (continuousBlock.fromStart != this.fromChainStart) {
            throw new SAMException("First block from start != chain from start for chain " + this.id);
        }
        if (continuousBlock.toStart != this.toChainStart) {
            throw new SAMException("First block to start != chain to start for chain " + this.id);
        }
        ContinuousBlock continuousBlock2 = this.blockList.get(this.blockList.size() - 1);
        if (continuousBlock2.getFromEnd() != this.fromChainEnd) {
            throw new SAMException("Last block from end != chain from end for chain " + this.id);
        }
        if (continuousBlock2.getToEnd() != this.toChainEnd) {
            throw new SAMException("Last block to end < chain to end for chain " + this.id);
        }
        for (int i = 1; i < this.blockList.size(); ++i) {
            ContinuousBlock continuousBlock3 = this.blockList.get(i);
            ContinuousBlock continuousBlock4 = this.blockList.get(i - 1);
            if (continuousBlock3.fromStart < continuousBlock4.getFromEnd()) {
                throw new SAMException("Continuous block " + i + " from starts before previous block ends for chain " + this.id);
            }
            if (continuousBlock3.toStart >= continuousBlock4.getToEnd()) continue;
            throw new SAMException("Continuous block " + i + " to starts before previous block ends for chain " + this.id);
        }
    }

    private void validatePositive(String string, int n) {
        if (n <= 0) {
            throw new SAMException(string + " is not positive: " + n + " for chain " + this.id);
        }
    }

    private void validateNonNegative(String string, int n) {
        if (n < 0) {
            throw new SAMException(string + " is negative: " + n + " for chain " + this.id);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Chain chain = (Chain)object;
        if (this.fromChainEnd != chain.fromChainEnd) {
            return false;
        }
        if (this.fromChainStart != chain.fromChainStart) {
            return false;
        }
        if (this.fromSequenceSize != chain.fromSequenceSize) {
            return false;
        }
        if (this.id != chain.id) {
            return false;
        }
        if (Double.compare(chain.score, this.score) != 0) {
            return false;
        }
        if (this.toChainEnd != chain.toChainEnd) {
            return false;
        }
        if (this.toChainStart != chain.toChainStart) {
            return false;
        }
        if (this.toNegativeStrand != chain.toNegativeStrand) {
            return false;
        }
        if (this.toSequenceSize != chain.toSequenceSize) {
            return false;
        }
        if (this.blockList != null ? !this.blockList.equals(chain.blockList) : chain.blockList != null) {
            return false;
        }
        if (this.fromSequenceName != null ? !this.fromSequenceName.equals(chain.fromSequenceName) : chain.fromSequenceName != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(chain.interval) : chain.interval != null) {
            return false;
        }
        return !(this.toSequenceName != null ? !this.toSequenceName.equals(chain.toSequenceName) : chain.toSequenceName != null);
    }

    public int hashCode() {
        long l = this.score != 0.0 ? Double.doubleToLongBits(this.score) : 0L;
        int n = (int)(l ^ l >>> 32);
        n = 31 * n + (this.interval != null ? this.interval.hashCode() : 0);
        n = 31 * n + (this.fromSequenceName != null ? this.fromSequenceName.hashCode() : 0);
        n = 31 * n + this.fromSequenceSize;
        n = 31 * n + this.fromChainStart;
        n = 31 * n + this.fromChainEnd;
        n = 31 * n + (this.toSequenceName != null ? this.toSequenceName.hashCode() : 0);
        n = 31 * n + this.toSequenceSize;
        n = 31 * n + (this.toNegativeStrand ? 1 : 0);
        n = 31 * n + this.toChainStart;
        n = 31 * n + this.toChainEnd;
        n = 31 * n + this.id;
        n = 31 * n + (this.blockList != null ? this.blockList.hashCode() : 0);
        return n;
    }

    static OverlapDetector<Chain> loadChains(File file) {
        Chain chain;
        BufferedLineReader bufferedLineReader = new BufferedLineReader(IOUtil.openFileForReading(file));
        OverlapDetector<Chain> overlapDetector = new OverlapDetector<Chain>(0, 0);
        while ((chain = Chain.loadChain(bufferedLineReader, file.toString())) != null) {
            overlapDetector.addLhs(chain, chain.interval);
        }
        bufferedLineReader.close();
        return overlapDetector;
    }

    private static Chain loadChain(BufferedLineReader bufferedLineReader, String string) {
        String string2;
        do {
            if ((string2 = bufferedLineReader.readLine()) != null) continue;
            return null;
        } while (string2.startsWith("#"));
        String[] stringArray = SPLITTER.split(string2);
        if (stringArray.length != 13) {
            Chain.throwChainFileParseException("chain line has wrong number of fields", string, bufferedLineReader.getLineNumber());
        }
        if (!"chain".equals(stringArray[0])) {
            Chain.throwChainFileParseException("chain line does not start with 'chain'", string, bufferedLineReader.getLineNumber());
        }
        double d = 0.0;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string4 = null;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            d = Double.parseDouble(stringArray[1]);
            string3 = stringArray[2];
            n = Integer.parseInt(stringArray[3]);
            n2 = Integer.parseInt(stringArray[5]);
            n3 = Integer.parseInt(stringArray[6]);
            string4 = stringArray[7];
            n4 = Integer.parseInt(stringArray[8]);
            bl = stringArray[9].equals("-");
            n5 = Integer.parseInt(stringArray[10]);
            n6 = Integer.parseInt(stringArray[11]);
            n7 = Integer.parseInt(stringArray[12]);
        }
        catch (NumberFormatException numberFormatException) {
            Chain.throwChainFileParseException("Invalid field", string, bufferedLineReader.getLineNumber());
        }
        Chain chain = new Chain(d, string3, n, n2, n3, string4, n4, bl, n5, n6, n7);
        int n8 = chain.toChainStart;
        int n9 = chain.fromChainStart;
        boolean bl2 = false;
        while (true) {
            String[] stringArray2;
            if ((string2 = bufferedLineReader.readLine()) == null || string2.equals("")) {
                if (bl2) break;
                Chain.throwChainFileParseException("Reached end of chain without seeing terminal block", string, bufferedLineReader.getLineNumber());
                break;
            }
            if (bl2) {
                Chain.throwChainFileParseException("Terminal block seen before end of chain", string, bufferedLineReader.getLineNumber());
            }
            if ((stringArray2 = SPLITTER.split(string2)).length == 1) {
                bl2 = true;
            } else if (stringArray2.length != 3) {
                Chain.throwChainFileParseException("Block line has unexpected number of fields", string, bufferedLineReader.getLineNumber());
            }
            int n10 = Integer.parseInt(stringArray2[0]);
            chain.addBlock(n9, n8, n10);
            if (bl2) continue;
            n9 += Integer.parseInt(stringArray2[1]) + n10;
            n8 += Integer.parseInt(stringArray2[2]) + n10;
        }
        chain.validate();
        return chain;
    }

    private static void throwChainFileParseException(String string, String string2, int n) {
        throw new SAMException(string + " in chain file " + string2 + " at line " + n);
    }

    static class ContinuousBlock {
        final int fromStart;
        final int toStart;
        final int blockLength;

        private ContinuousBlock(int n, int n2, int n3) {
            this.fromStart = n;
            this.toStart = n2;
            this.blockLength = n3;
        }

        int getFromEnd() {
            return this.fromStart + this.blockLength;
        }

        int getToEnd() {
            return this.toStart + this.blockLength;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ContinuousBlock continuousBlock = (ContinuousBlock)object;
            if (this.blockLength != continuousBlock.blockLength) {
                return false;
            }
            if (this.fromStart != continuousBlock.fromStart) {
                return false;
            }
            return this.toStart == continuousBlock.toStart;
        }

        public int hashCode() {
            int n = this.fromStart;
            n = 31 * n + this.toStart;
            n = 31 * n + this.blockLength;
            return n;
        }
    }
}

