/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.BinaryTagCodec;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMTagUtil;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.io.CramArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.structure.Block;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

class SliceIO {
    private static final Log log = Log.getInstance(SliceIO.class);

    SliceIO() {
    }

    private static void readSliceHeadBlock(int n, Slice slice, InputStream inputStream) throws IOException {
        slice.headerBlock = Block.readFromInputStream(n, inputStream);
        SliceIO.parseSliceHeaderBlock(n, slice);
    }

    private static void parseSliceHeaderBlock(int n, Slice slice) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(slice.headerBlock.getRawContent());
        slice.sequenceId = ITF8.readUnsignedITF8(byteArrayInputStream);
        slice.alignmentStart = ITF8.readUnsignedITF8(byteArrayInputStream);
        slice.alignmentSpan = ITF8.readUnsignedITF8(byteArrayInputStream);
        slice.nofRecords = ITF8.readUnsignedITF8(byteArrayInputStream);
        slice.globalRecordCounter = LTF8.readUnsignedLTF8(byteArrayInputStream);
        slice.nofBlocks = ITF8.readUnsignedITF8(byteArrayInputStream);
        slice.contentIDs = CramArray.array(byteArrayInputStream);
        slice.embeddedRefBlockContentID = ITF8.readUnsignedITF8(byteArrayInputStream);
        slice.refMD5 = new byte[16];
        InputStreamUtils.readFully(byteArrayInputStream, slice.refMD5, 0, slice.refMD5.length);
        byte[] byArray = InputStreamUtils.readFully(byteArrayInputStream);
        if (n >= CramVersions.CRAM_v3.major) {
            for (SAMBinaryTagAndValue sAMBinaryTagAndValue = slice.sliceTags = BinaryTagCodec.readTags(byArray, 0, byArray.length, ValidationStringency.DEFAULT_STRINGENCY); sAMBinaryTagAndValue != null; sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) {
                log.debug(String.format("Found slice tag: %s", SAMTagUtil.getSingleton().makeStringTag(sAMBinaryTagAndValue.tag)));
            }
        }
    }

    private static byte[] createSliceHeaderBlockContent(int n, Slice slice) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ITF8.writeUnsignedITF8(slice.sequenceId, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.alignmentStart, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.alignmentSpan, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.nofRecords, byteArrayOutputStream);
        LTF8.writeUnsignedLTF8(slice.globalRecordCounter, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.nofBlocks, byteArrayOutputStream);
        slice.contentIDs = new int[slice.external.size()];
        int n2 = 0;
        Object object = slice.external.keySet().iterator();
        while (object.hasNext()) {
            int n3 = object.next();
            slice.contentIDs[n2++] = n3;
        }
        CramArray.write(slice.contentIDs, byteArrayOutputStream);
        ITF8.writeUnsignedITF8(slice.embeddedRefBlockContentID, byteArrayOutputStream);
        byteArrayOutputStream.write(slice.refMD5 == null ? new byte[16] : slice.refMD5);
        if (n >= CramVersions.CRAM_v3.major && slice.sliceTags != null) {
            object = new BinaryCodec(byteArrayOutputStream);
            BinaryTagCodec binaryTagCodec = new BinaryTagCodec((BinaryCodec)object);
            SAMBinaryTagAndValue sAMBinaryTagAndValue = slice.sliceTags;
            do {
                log.debug("Writing slice tag: " + SAMTagUtil.getSingleton().makeStringTag(sAMBinaryTagAndValue.tag));
                binaryTagCodec.writeTag(sAMBinaryTagAndValue.tag, sAMBinaryTagAndValue.value, sAMBinaryTagAndValue.isUnsignedArray());
            } while ((sAMBinaryTagAndValue = sAMBinaryTagAndValue.getNext()) != null);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void readSliceBlocks(int n, Slice slice, InputStream inputStream) throws IOException {
        slice.external = new HashMap<Integer, Block>();
        block4: for (int i = 0; i < slice.nofBlocks; ++i) {
            Block block = Block.readFromInputStream(n, inputStream);
            switch (block.getContentType()) {
                case CORE: {
                    slice.coreBlock = block;
                    continue block4;
                }
                case EXTERNAL: {
                    if (slice.embeddedRefBlockContentID == block.getContentId()) {
                        slice.embeddedRefBlock = block;
                    }
                    slice.external.put(block.getContentId(), block);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Not a slice block, content type id " + block.getContentType().name());
                }
            }
        }
    }

    public static void write(int n, Slice slice, OutputStream outputStream) throws IOException {
        slice.nofBlocks = 1 + slice.external.size() + (slice.embeddedRefBlock == null ? 0 : 1);
        slice.contentIDs = new int[slice.external.size()];
        Iterator<Integer> object2 = slice.external.keySet().iterator();
        while (object2.hasNext()) {
            int n2;
            slice.contentIDs[0] = n2 = object2.next().intValue();
        }
        slice.headerBlock = Block.buildNewSliceHeaderBlock(SliceIO.createSliceHeaderBlockContent(n, slice));
        slice.headerBlock.write(n, outputStream);
        slice.coreBlock.write(n, outputStream);
        for (Block block : slice.external.values()) {
            block.write(n, outputStream);
        }
    }

    public static void read(int n, Slice slice, InputStream inputStream) throws IOException {
        SliceIO.readSliceHeadBlock(n, slice, inputStream);
        SliceIO.readSliceBlocks(n, slice, inputStream);
    }
}

