/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.ReferenceRegion;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class InMemoryReferenceSequenceFile
implements ReferenceSequenceFile {
    private Map<Integer, byte[]> sequences = new HashMap<Integer, byte[]>();
    private SAMSequenceDictionary dictionary = new SAMSequenceDictionary();
    private int currentIndex = 0;

    InMemoryReferenceSequenceFile() {
    }

    public void addSequence(String string, byte[] byArray) {
        SAMSequenceRecord sAMSequenceRecord = new SAMSequenceRecord(string, byArray.length);
        this.dictionary.addSequence(sAMSequenceRecord);
        int n = this.getSequenceDictionary().getSequenceIndex(string);
        this.sequences.put(n, byArray);
    }

    @Override
    public ReferenceSequence getSequence(String string) {
        int n = this.getSequenceDictionary().getSequenceIndex(string);
        return new ReferenceSequence(string, n, this.sequences.get(n));
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.dictionary;
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String string, long l, long l2) {
        int n = this.getSequenceDictionary().getSequenceIndex(string);
        byte[] byArray = Arrays.copyOfRange(this.sequences.get(n), (int)l, (int)l2 + 1);
        return new ReferenceSequence(string, n, byArray);
    }

    @Override
    public void close() throws IOException {
        this.sequences = null;
        this.dictionary = null;
    }

    public ReferenceRegion getRegion(String string, long l, long l2) {
        int n = this.getSequenceDictionary().getSequenceIndex(string);
        if (!this.sequences.containsKey(n)) {
            throw new RuntimeException("Sequence not found: " + string);
        }
        return new ReferenceRegion(this.sequences.get(n), n, string, l, l2);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public ReferenceSequence nextSequence() {
        if (this.currentIndex >= this.dictionary.size()) {
            return null;
        }
        SAMSequenceRecord sAMSequenceRecord = this.dictionary.getSequence(this.currentIndex++);
        return this.getSequence(sAMSequenceRecord.getSequenceName());
    }

    @Override
    public void reset() {
        this.currentIndex = 0;
    }
}

