/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class CRC32OutputStream
extends FilterOutputStream {
    private final CRC32 crc32 = new CRC32();

    public CRC32OutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.crc32.update(byArray, n, n2);
        this.out.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.crc32.update(n);
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.crc32.update(byArray);
        this.out.write(byArray);
    }

    public long getLongCrc32() {
        return this.crc32.getValue();
    }

    public byte[] getCrc32_BigEndian() {
        long l = this.crc32.getValue();
        return new byte[]{(byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l)};
    }

    public byte[] getCrc32_LittleEndian() {
        long l = this.crc32.getValue();
        return new byte[]{(byte)(0xFFL & l), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 24)};
    }
}

