/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.rans;

import java.nio.ByteBuffer;

class Decoding {
    Decoding() {
    }

    static void RansDecSymbolInit(RansDecSymbol ransDecSymbol, int n, int n2) {
        assert (n <= 65536);
        assert (n2 <= 65536 - n);
        ransDecSymbol.start = n;
        ransDecSymbol.freq = n2;
    }

    private static int RansDecAdvanceStep(int n, int n2, int n3, int n4) {
        int n5 = (1 << n4) - 1;
        return n3 * (n >> n4) + (n & n5) - n2;
    }

    static int RansDecAdvanceSymbolStep(int n, RansDecSymbol ransDecSymbol, int n2) {
        return Decoding.RansDecAdvanceStep(n, ransDecSymbol.start, ransDecSymbol.freq, n2);
    }

    static int RansDecGet(int n, int n2) {
        return n & (1 << n2) - 1;
    }

    static int RansDecAdvanceSymbol(int n, ByteBuffer byteBuffer, RansDecSymbol ransDecSymbol, int n2) {
        return Decoding.RansDecAdvance(n, byteBuffer, ransDecSymbol.start, ransDecSymbol.freq, n2);
    }

    private static int RansDecAdvance(int n, ByteBuffer byteBuffer, int n2, int n3, int n4) {
        int n5 = (1 << n4) - 1;
        if ((n = n3 * (n >> n4) + (n & n5) - n2) < 0x800000) {
            int n6;
            while ((n = n << 8 | (n6 = 0xFF & byteBuffer.get())) < 0x800000) {
            }
        }
        return n;
    }

    static int RansDecRenormalize(int n, ByteBuffer byteBuffer) {
        if (n < 0x800000) {
            while ((n = n << 8 | 0xFF & byteBuffer.get()) < 0x800000) {
            }
        }
        return n;
    }

    static class RansDecSymbol {
        int start;
        int freq;

        RansDecSymbol() {
        }
    }

    static class AriDecoder {
        final FC[] fc = new FC[256];
        byte[] R;

        AriDecoder() {
        }
    }

    static class FC {
        int F;
        int C;

        FC() {
        }
    }
}

