/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExternalIntegerCodec
extends AbstractBitCodec<Integer> {
    private final OutputStream outputStream;
    private final InputStream inputStream;
    private final OutputStream nullOutputStream = new OutputStream(){

        @Override
        public void write(byte[] byArray) throws IOException {
        }

        @Override
        public void write(int n) throws IOException {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
        }
    };

    public ExternalIntegerCodec(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    @Override
    public Integer read(BitInputStream bitInputStream) throws IOException {
        return ITF8.readUnsignedITF8(this.inputStream);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, Integer n) throws IOException {
        return ITF8.writeUnsignedITF8((int)n, this.outputStream);
    }

    @Override
    public long numberOfBits(Integer n) {
        try {
            return ITF8.writeUnsignedITF8((int)n, this.nullOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int n) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

