/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.io.Serializable;

public class SAMBinaryTagAndValue
implements Serializable {
    public static final long serialVersionUID = 1L;
    public final short tag;
    public final Object value;
    protected SAMBinaryTagAndValue next = null;

    public SAMBinaryTagAndValue(short s, Object object) {
        this.tag = s;
        this.value = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeSafeEquals((SAMBinaryTagAndValue)object);
    }

    private boolean typeSafeEquals(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        if (this.tag != sAMBinaryTagAndValue.tag) {
            return false;
        }
        if (this.value == null ? sAMBinaryTagAndValue.value == null : this.value.equals(sAMBinaryTagAndValue.value)) {
            if (this.next == null) {
                return sAMBinaryTagAndValue.next == null;
            }
            return this.next.equals(sAMBinaryTagAndValue.next);
        }
        return false;
    }

    public int hashCode() {
        int n = this.tag;
        n = 31 * n + this.value.hashCode();
        return n;
    }

    public SAMBinaryTagAndValue copy() {
        SAMBinaryTagAndValue sAMBinaryTagAndValue = new SAMBinaryTagAndValue(this.tag, this.value);
        if (this.next != null) {
            sAMBinaryTagAndValue.next = this.next.copy();
        }
        return sAMBinaryTagAndValue;
    }

    public SAMBinaryTagAndValue getNext() {
        return this.next;
    }

    public SAMBinaryTagAndValue insert(SAMBinaryTagAndValue sAMBinaryTagAndValue) {
        if (sAMBinaryTagAndValue == null) {
            return this;
        }
        if (sAMBinaryTagAndValue.next != null) {
            throw new IllegalStateException("Can only insert single tag/value combinations.");
        }
        if (sAMBinaryTagAndValue.tag < this.tag) {
            sAMBinaryTagAndValue.next = this;
            return sAMBinaryTagAndValue;
        }
        if (this.tag == sAMBinaryTagAndValue.tag) {
            sAMBinaryTagAndValue.next = this.next;
            return sAMBinaryTagAndValue;
        }
        if (this.next == null) {
            this.next = sAMBinaryTagAndValue;
            return this;
        }
        this.next = this.next.insert(sAMBinaryTagAndValue);
        return this;
    }

    public SAMBinaryTagAndValue remove(short s) {
        if (this.tag == s) {
            return this.next;
        }
        if (this.next != null) {
            this.next = this.next.remove(s);
        }
        return this;
    }

    public SAMBinaryTagAndValue find(short s) {
        if (this.tag == s) {
            return this;
        }
        if (this.tag > s || this.next == null) {
            return null;
        }
        return this.next.find(s);
    }

    public boolean isUnsignedArray() {
        return false;
    }
}

