/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DuplicateSet {
    private final List<SAMRecord> records = new ArrayList<SAMRecord>(10);
    private static final SAMRecordDuplicateComparator defaultComparator = new SAMRecordDuplicateComparator();
    private final SAMRecordDuplicateComparator comparator;
    private boolean needsSorting = false;
    private boolean setDuplicateFlag = false;

    public DuplicateSet() {
        this(true);
    }

    public DuplicateSet(boolean bl) {
        this(bl, defaultComparator);
    }

    public DuplicateSet(SAMRecordDuplicateComparator sAMRecordDuplicateComparator) {
        this(true, sAMRecordDuplicateComparator);
    }

    public DuplicateSet(boolean bl, SAMRecordDuplicateComparator sAMRecordDuplicateComparator) {
        this.setDuplicateFlag = bl;
        this.comparator = sAMRecordDuplicateComparator;
    }

    public int add(SAMRecord sAMRecord) {
        int n;
        if (!this.records.isEmpty() && 0 != (n = this.comparator.duplicateSetCompare(this.getRepresentative(), sAMRecord))) {
            return n;
        }
        this.records.add(sAMRecord);
        this.needsSorting = true;
        return 0;
    }

    private void sort() {
        if (!this.records.isEmpty()) {
            Collections.sort(this.records, this.comparator);
            SAMRecord sAMRecord = this.records.get(0);
            if (this.setDuplicateFlag) {
                for (SAMRecord sAMRecord2 : this.records) {
                    if (sAMRecord2.getReadUnmappedFlag() || sAMRecord2.isSecondaryOrSupplementary() || sAMRecord2.getReadName().equals(sAMRecord.getReadName())) continue;
                    sAMRecord2.setDuplicateReadFlag(true);
                }
                this.records.get(0).setDuplicateReadFlag(false);
            }
        }
        this.needsSorting = false;
    }

    public List<SAMRecord> getRecords() {
        if (this.needsSorting) {
            this.sort();
        }
        return this.records;
    }

    public SAMRecord getRepresentative() {
        if (this.needsSorting) {
            this.sort();
        }
        return this.records.get(0);
    }

    public int size() {
        return this.records.size();
    }

    public int numDuplicates() {
        int n = 0;
        for (SAMRecord sAMRecord : this.records) {
            if (sAMRecord.getReadUnmappedFlag() || sAMRecord.isSecondaryOrSupplementary()) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public void setDuplicateFlag(boolean bl) {
        this.setDuplicateFlag = bl;
    }
}

