/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;

public class DuplicateScoringStrategy {
    private static short getSumOfBaseQualities(SAMRecord sAMRecord) {
        short s = 0;
        for (byte by : sAMRecord.getBaseQualities()) {
            if (by < 15) continue;
            s = (short)(s + by);
        }
        return s;
    }

    public static short computeDuplicateScore(SAMRecord sAMRecord, ScoringStrategy scoringStrategy) {
        return DuplicateScoringStrategy.computeDuplicateScore(sAMRecord, scoringStrategy, false);
    }

    public static short computeDuplicateScore(SAMRecord sAMRecord, ScoringStrategy scoringStrategy, boolean bl) {
        short s = 0;
        switch (scoringStrategy) {
            case SUM_OF_BASE_QUALITIES: {
                s = (short)(s + DuplicateScoringStrategy.getSumOfBaseQualities(sAMRecord));
                break;
            }
            case TOTAL_MAPPED_REFERENCE_LENGTH: {
                if (!sAMRecord.getReadUnmappedFlag()) {
                    s = (short)(s + sAMRecord.getCigar().getReferenceLength());
                }
                if (!bl || !sAMRecord.getReadPairedFlag() || sAMRecord.getMateUnmappedFlag()) break;
                s = (short)(s + SAMUtils.getMateCigar(sAMRecord).getReferenceLength());
            }
        }
        return s;
    }

    public static int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2, ScoringStrategy scoringStrategy, boolean bl) {
        if (sAMRecord.getReadPairedFlag() != sAMRecord2.getReadPairedFlag()) {
            return sAMRecord.getReadPairedFlag() ? 1 : -1;
        }
        int n = DuplicateScoringStrategy.computeDuplicateScore(sAMRecord2, scoringStrategy, bl) - DuplicateScoringStrategy.computeDuplicateScore(sAMRecord, scoringStrategy, bl);
        if (0 == n) {
            n = SAMUtils.getCanonicalRecordName(sAMRecord).compareTo(SAMUtils.getCanonicalRecordName(sAMRecord2));
        }
        return n;
    }

    public static int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2, ScoringStrategy scoringStrategy) {
        return DuplicateScoringStrategy.compare(sAMRecord, sAMRecord2, scoringStrategy, false);
    }

    public static enum ScoringStrategy {
        SUM_OF_BASE_QUALITIES,
        TOTAL_MAPPED_REFERENCE_LENGTH;

    }
}

