/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;

public class DownsamplingIterator
implements CloseableIterator<SAMRecord>,
Iterable<SAMRecord> {
    private final Iterator<SAMRecord> underlyingIterator;
    private final Random random;
    private final double probabilityOfKeeping;
    private SAMRecord nextRecord;
    private long totalReads;
    private long keptReads;
    private final Map<String, Boolean> decisions = new HashMap<String, Boolean>();
    private boolean allowSecondaryAlignments = false;
    private boolean allowSupplementalAlignments = false;
    private boolean includeNoRefReads = true;

    public DownsamplingIterator(Iterator<SAMRecord> iterator, Random random, double d) {
        this.underlyingIterator = iterator;
        this.random = random;
        this.probabilityOfKeeping = d;
    }

    public DownsamplingIterator setAllowSecondaryAlignments(boolean bl) {
        this.allowSecondaryAlignments = bl;
        return this;
    }

    public DownsamplingIterator setAllowSupplementalAlignments(boolean bl) {
        this.allowSupplementalAlignments = bl;
        return this;
    }

    public DownsamplingIterator setIncludeNoRefReads(boolean bl) {
        this.includeNoRefReads = bl;
        return this;
    }

    public long getTotalReads() {
        return this.totalReads;
    }

    public long getKeptReads() {
        return this.keptReads;
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }

    private boolean advance() {
        boolean bl;
        this.nextRecord = null;
        boolean bl2 = bl = !this.allowSecondaryAlignments && !this.allowSupplementalAlignments;
        while (this.nextRecord == null && this.underlyingIterator.hasNext()) {
            boolean bl3;
            Boolean bl4;
            SAMRecord sAMRecord = this.underlyingIterator.next();
            if (!this.allowSecondaryAlignments && sAMRecord.getNotPrimaryAlignmentFlag() || !this.allowSupplementalAlignments && sAMRecord.getSupplementaryAlignmentFlag()) continue;
            if (!this.includeNoRefReads && sAMRecord.getReferenceIndex() == -1) break;
            ++this.totalReads;
            String string = sAMRecord.getReadName();
            Boolean bl5 = bl4 = bl ? this.decisions.remove(string) : this.decisions.get(string);
            if (bl4 == null) {
                boolean bl6 = bl3 = this.random.nextDouble() <= this.probabilityOfKeeping;
                if (sAMRecord.getReadPairedFlag() || this.allowSecondaryAlignments || this.allowSupplementalAlignments) {
                    this.decisions.put(string, bl3);
                }
            } else {
                bl3 = bl4;
            }
            if (!bl3) continue;
            this.nextRecord = sAMRecord;
            ++this.keptReads;
        }
        return this.nextRecord != null;
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null || this.advance();
    }

    @Override
    public SAMRecord next() {
        if (this.nextRecord == null) {
            throw new NoSuchElementException("Call to next() when hasNext() == false");
        }
        SAMRecord sAMRecord = this.nextRecord;
        this.advance();
        return sAMRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported.");
    }

    @Override
    public void close() {
    }
}

