/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SAMValidationError;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.ContainerParser;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramContainerIterator;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.build.CramSpanContainerIterator;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CRAMIterator
implements SAMRecordIterator {
    private static final Log log = Log.getInstance(CRAMIterator.class);
    private final CountingInputStream countingInputStream;
    private CramHeader cramHeader;
    private ArrayList<SAMRecord> records;
    private SAMRecord nextRecord = null;
    private boolean restoreNMTag = true;
    private boolean restoreMDTag = false;
    private CramNormalizer normalizer;
    private byte[] refs;
    private int prevSeqId = -1;
    public Container container;
    private SamReader mReader;
    long firstContainerOffset = 0L;
    private Iterator<Container> containerIterator;
    private ContainerParser parser;
    private final ReferenceSource referenceSource;
    private Iterator<SAMRecord> iterator = Collections.emptyList().iterator();
    private ValidationStringency validationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private long samRecordIndex;
    private ArrayList<CramCompressionRecord> cramRecords;

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public CRAMIterator(InputStream inputStream, ReferenceSource referenceSource) throws IOException {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.referenceSource = referenceSource;
        CramContainerIterator cramContainerIterator = new CramContainerIterator(this.countingInputStream);
        this.cramHeader = cramContainerIterator.getCramHeader();
        this.containerIterator = cramContainerIterator;
        this.firstContainerOffset = this.countingInputStream.getCount();
        this.records = new ArrayList(10000);
        this.normalizer = new CramNormalizer(this.cramHeader.getSamFileHeader(), referenceSource);
        this.parser = new ContainerParser(this.cramHeader.getSamFileHeader());
    }

    public CRAMIterator(SeekableStream seekableStream, ReferenceSource referenceSource, long[] lArray) throws IOException {
        this.countingInputStream = new CountingInputStream(seekableStream);
        this.referenceSource = referenceSource;
        CramSpanContainerIterator cramSpanContainerIterator = CramSpanContainerIterator.fromFileSpan(seekableStream, lArray);
        this.cramHeader = cramSpanContainerIterator.getCramHeader();
        this.containerIterator = cramSpanContainerIterator;
        this.firstContainerOffset = cramSpanContainerIterator.getFirstContainerOffset();
        this.records = new ArrayList(10000);
        this.normalizer = new CramNormalizer(this.cramHeader.getSamFileHeader(), referenceSource);
        this.parser = new ContainerParser(this.cramHeader.getSamFileHeader());
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    private void nextContainer() throws IOException, IllegalArgumentException, IllegalAccessException {
        if (this.containerIterator != null) {
            if (!this.containerIterator.hasNext()) {
                this.records.clear();
                this.nextRecord = null;
                return;
            }
            this.container = this.containerIterator.next();
            if (this.container.isEOF()) {
                this.records.clear();
                this.nextRecord = null;
                return;
            }
        } else {
            this.container = ContainerIO.readContainer(this.cramHeader.getVersion(), (InputStream)this.countingInputStream);
            if (this.container.isEOF()) {
                this.records.clear();
                this.nextRecord = null;
                return;
            }
        }
        if (this.records == null) {
            this.records = new ArrayList(this.container.nofRecords);
        } else {
            this.records.clear();
        }
        if (this.cramRecords == null) {
            this.cramRecords = new ArrayList(this.container.nofRecords);
        } else {
            this.cramRecords.clear();
        }
        this.parser.getRecords(this.container, this.cramRecords);
        if (this.container.sequenceId == -1) {
            this.refs = new byte[0];
        } else if (this.container.sequenceId == -2) {
            this.refs = null;
            this.prevSeqId = -2;
        } else if (this.prevSeqId < 0 || this.prevSeqId != this.container.sequenceId) {
            SAMSequenceRecord sAMSequenceRecord = this.cramHeader.getSamFileHeader().getSequence(this.container.sequenceId);
            this.refs = this.referenceSource.getReferenceBases(sAMSequenceRecord, true);
            this.prevSeqId = this.container.sequenceId;
        }
        for (int i = 0; i < this.container.slices.length; ++i) {
            Slice slice = this.container.slices[i];
            if (slice.sequenceId < 0 || this.validationStringency == ValidationStringency.SILENT || slice.validateRefMD5(this.refs)) continue;
            log.error(String.format("Reference sequence MD5 mismatch for slice: seq id %d, start %d, span %d, expected MD5 %s", slice.sequenceId, slice.alignmentStart, slice.alignmentSpan, String.format("%032x", new BigInteger(1, slice.refMD5))));
        }
        this.normalizer.normalize(this.cramRecords, this.refs, 0, this.container.header.substitutionMatrix);
        Cram2SamRecordFactory cram2SamRecordFactory = new Cram2SamRecordFactory(this.cramHeader.getSamFileHeader());
        for (CramCompressionRecord cramCompressionRecord : this.cramRecords) {
            Object object;
            SAMRecord sAMRecord = cram2SamRecordFactory.create(cramCompressionRecord);
            if (!cramCompressionRecord.isSegmentUnmapped()) {
                object = this.cramHeader.getSamFileHeader().getSequence(cramCompressionRecord.sequenceId);
                this.refs = this.referenceSource.getReferenceBases((SAMSequenceRecord)object, true);
                if (sAMRecord.getReadBases() != SAMRecord.NULL_SEQUENCE) {
                    SequenceUtil.calculateMdAndNmTags(sAMRecord, this.refs, this.restoreMDTag, this.restoreNMTag);
                }
            }
            sAMRecord.setValidationStringency(this.validationStringency);
            if (this.validationStringency != ValidationStringency.SILENT) {
                object = sAMRecord.isValid();
                SAMUtils.processValidationErrors((List<SAMValidationError>)object, this.samRecordIndex, this.validationStringency);
            }
            if (this.mReader != null) {
                long l = this.container.offset << 16 | (long)cramCompressionRecord.sliceIndex;
                long l2 = (this.container.offset << 16 | (long)cramCompressionRecord.sliceIndex) + 1L;
                this.nextRecord.setFileSource(new SAMFileSource(this.mReader, new BAMFileSpan(new Chunk(l, l2))));
            }
            this.records.add(sAMRecord);
            ++this.samRecordIndex;
        }
        this.cramRecords.clear();
        this.iterator = this.records.iterator();
    }

    public void jumpWithinContainerToPos(int n, int n2) {
        if (!this.hasNext()) {
            return;
        }
        int n3 = 0;
        for (SAMRecord sAMRecord : this.records) {
            if (n != -1 && sAMRecord.getReferenceIndex() != n) continue;
            if (n2 <= 0) {
                if (sAMRecord.getAlignmentStart() == 0) {
                    this.iterator = this.records.listIterator(n3);
                    return;
                }
            } else if (sAMRecord.getAlignmentStart() >= n2) {
                this.iterator = this.records.listIterator(n3);
                return;
            }
            ++n3;
        }
        this.iterator = Collections.emptyList().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.container != null && this.container.isEOF()) {
            return false;
        }
        if (!this.iterator.hasNext()) {
            try {
                this.nextContainer();
            }
            catch (Exception exception) {
                throw new RuntimeEOFException(exception);
            }
        }
        return !this.records.isEmpty();
    }

    @Override
    public SAMRecord next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Removal of records not implemented.");
    }

    @Override
    public void close() {
        this.records.clear();
        try {
            if (this.countingInputStream != null) {
                this.countingInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        throw new RuntimeException("Not implemented.");
    }

    public SamReader getFileSource() {
        return this.mReader;
    }

    public void setFileSource(SamReader samReader) {
        this.mReader = samReader;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.cramHeader.getSamFileHeader();
    }
}

