/*
 * Decompiled with CFR 0.152.
 */
package com.github.rawls238.scientist4j;

import com.github.rawls238.scientist4j.IncompatibleTypesExperiment;
import com.github.rawls238.scientist4j.Observation;
import com.github.rawls238.scientist4j.exceptions.MismatchException;
import java.util.Map;
import java.util.Optional;

public class IncompatibleTypesExperimentResult<T, U> {
    private final Observation<T> control;
    private final Optional<Observation<U>> candidate;
    private Optional<Boolean> match;
    private final Map<String, Object> context;

    public IncompatibleTypesExperimentResult(IncompatibleTypesExperiment<T, U> experiment, Observation<T> control, Optional<Observation<U>> candidate, Map<String, Object> context) throws MismatchException {
        this.control = control;
        this.candidate = candidate;
        this.context = context;
        this.match = Optional.empty();
        if (candidate.isPresent()) {
            try {
                this.match = Optional.of(experiment.compare(control, candidate.get()));
            }
            catch (MismatchException e) {
                this.match = Optional.of(false);
                throw e;
            }
        }
    }

    public Optional<Boolean> getMatch() {
        return this.match;
    }

    public Observation<T> getControl() {
        return this.control;
    }

    public Optional<Observation<U>> getCandidate() {
        return this.candidate;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

