/*
 * Decompiled with CFR 0.152.
 */
package com.github.rawls238.scientist4j;

import com.github.rawls238.scientist4j.Experiment;
import com.github.rawls238.scientist4j.metrics.MetricsProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;

public class ExperimentBuilder<T> {
    private String name;
    private MetricsProvider<?> metricsProvider;
    private BiFunction<T, T, Boolean> comparator;
    private Map<String, Object> context = new HashMap<String, Object>();
    private ExecutorService executorService;

    public ExperimentBuilder() {
        this.comparator = Object::equals;
    }

    public ExperimentBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public ExperimentBuilder<T> withMetricsProvider(MetricsProvider<?> metricsProvider) {
        this.metricsProvider = metricsProvider;
        return this;
    }

    public ExperimentBuilder<T> withComparator(BiFunction<T, T, Boolean> comparator) {
        this.comparator = comparator;
        return this;
    }

    public ExperimentBuilder<T> withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Experiment<T> build() {
        assert (this.name != null);
        assert (this.metricsProvider != null);
        return new Experiment<T>(this.name, this.context, false, this.metricsProvider, this.comparator, this.executorService);
    }
}

