/*
 * Decompiled with CFR 0.152.
 */
package com.github.rawls238.scientist4j;

import com.github.rawls238.scientist4j.Observation;
import com.github.rawls238.scientist4j.Result;
import com.github.rawls238.scientist4j.exceptions.MismatchException;
import com.github.rawls238.scientist4j.metrics.MetricsProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;

public class Experiment<T> {
    private final ExecutorService executor;
    private static final String NAMESPACE_PREFIX = "scientist";
    private final MetricsProvider<?> metricsProvider;
    private final String name;
    private final boolean raiseOnMismatch;
    private Map<String, Object> context;
    private final MetricsProvider.Timer controlTimer;
    private final MetricsProvider.Timer candidateTimer;
    private final MetricsProvider.Counter mismatchCount;
    private final MetricsProvider.Counter candidateExceptionCount;
    private final MetricsProvider.Counter totalCount;
    private final BiFunction<T, T, Boolean> comparator;

    public Experiment(MetricsProvider<?> metricsProvider) {
        this("Experiment", metricsProvider);
    }

    public Experiment(String name, MetricsProvider<?> metricsProvider) {
        this(name, false, metricsProvider);
    }

    public Experiment(String name, Map<String, Object> context, MetricsProvider<?> metricsProvider) {
        this(name, context, false, metricsProvider);
    }

    public Experiment(String name, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider) {
        this(name, new HashMap<String, Object>(), raiseOnMismatch, metricsProvider);
    }

    public Experiment(String name, Map<String, Object> context, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider) {
        this(name, context, raiseOnMismatch, metricsProvider, Objects::equals);
    }

    public Experiment(String name, Map<String, Object> context, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider, BiFunction<T, T, Boolean> comparator) {
        this(name, context, raiseOnMismatch, metricsProvider, comparator, Executors.newFixedThreadPool(2));
    }

    public Experiment(String name, Map<String, Object> context, boolean raiseOnMismatch, MetricsProvider<?> metricsProvider, BiFunction<T, T, Boolean> comparator, ExecutorService executorService) {
        this.name = name;
        this.context = context;
        this.raiseOnMismatch = raiseOnMismatch;
        this.comparator = comparator;
        this.metricsProvider = metricsProvider;
        this.controlTimer = this.getMetricsProvider().timer(NAMESPACE_PREFIX, this.name, "control");
        this.candidateTimer = this.getMetricsProvider().timer(NAMESPACE_PREFIX, this.name, "candidate");
        this.mismatchCount = this.getMetricsProvider().counter(NAMESPACE_PREFIX, this.name, "mismatch");
        this.candidateExceptionCount = this.getMetricsProvider().counter(NAMESPACE_PREFIX, this.name, "candidate.exception");
        this.totalCount = this.getMetricsProvider().counter(NAMESPACE_PREFIX, this.name, "total");
        this.executor = executorService;
    }

    public MetricsProvider<?> getMetricsProvider() {
        return this.metricsProvider;
    }

    public boolean getRaiseOnMismatch() {
        return this.raiseOnMismatch;
    }

    public String getName() {
        return this.name;
    }

    public T run(Callable<T> control, Callable<T> candidate) throws Exception {
        if (this.isAsyncCandidateOnly()) {
            return this.runAsyncCandidateOnly(control, candidate);
        }
        if (this.isAsync()) {
            return this.runAsync(control, candidate);
        }
        return this.runSync(control, candidate);
    }

    private T runSync(Callable<T> control, Callable<T> candidate) throws Exception {
        Observation<T> controlObservation;
        Optional<Observation<T>> candidateObservation = Optional.empty();
        if (Math.random() < 0.5) {
            controlObservation = this.executeResult("control", this.controlTimer, control, true);
            if (this.runIf() && this.enabled()) {
                candidateObservation = Optional.of(this.executeResult("candidate", this.candidateTimer, candidate, false));
            }
        } else {
            if (this.runIf() && this.enabled()) {
                candidateObservation = Optional.of(this.executeResult("candidate", this.candidateTimer, candidate, false));
            }
            controlObservation = this.executeResult("control", this.controlTimer, control, true);
        }
        this.countExceptions(candidateObservation, this.candidateExceptionCount);
        Result<T> result = new Result<T>(this, controlObservation, candidateObservation, this.context);
        this.publish(result);
        return controlObservation.getValue();
    }

    public T runAsync(Callable<T> control, Callable<T> candidate) throws Exception {
        Observation controlObservation;
        Future<Optional> observationFutureCandidate;
        Future<Observation> observationFutureControl;
        if (this.runIf() && this.enabled()) {
            if (Math.random() < 0.5) {
                observationFutureControl = this.executor.submit(() -> this.executeResult("control", this.controlTimer, control, true));
                observationFutureCandidate = this.executor.submit(() -> Optional.of(this.executeResult("candidate", this.candidateTimer, candidate, false)));
            } else {
                observationFutureCandidate = this.executor.submit(() -> Optional.of(this.executeResult("candidate", this.candidateTimer, candidate, false)));
                observationFutureControl = this.executor.submit(() -> this.executeResult("control", this.controlTimer, control, true));
            }
        } else {
            observationFutureControl = this.executor.submit(() -> this.executeResult("control", this.controlTimer, control, true));
            observationFutureCandidate = null;
        }
        try {
            controlObservation = observationFutureControl.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        Future<Void> publishedResult = this.executor.submit(() -> this.publishAsync(controlObservation, observationFutureCandidate));
        if (this.raiseOnMismatch) {
            try {
                publishedResult.get();
            }
            catch (ExecutionException e) {
                throw (Exception)e.getCause();
            }
        }
        return controlObservation.getValue();
    }

    public T runAsyncCandidateOnly(Callable<T> control, Callable<T> candidate) throws Exception {
        Observation<T> controlObservation;
        Future<Optional> observationFutureCandidate;
        if (this.runIf() && this.enabled()) {
            if (Math.random() < 0.5) {
                observationFutureCandidate = this.executor.submit(() -> Optional.of(this.executeResult("candidate", this.candidateTimer, candidate, false)));
                controlObservation = this.executeResult("control", this.controlTimer, control, true);
            } else {
                controlObservation = this.executeResult("control", this.controlTimer, control, true);
                observationFutureCandidate = this.executor.submit(() -> Optional.of(this.executeResult("candidate", this.candidateTimer, candidate, false)));
            }
        } else {
            controlObservation = this.executeResult("control", this.controlTimer, control, true);
            observationFutureCandidate = null;
        }
        Future<Void> publishedResult = this.executor.submit(() -> this.publishAsync(controlObservation, observationFutureCandidate));
        if (this.raiseOnMismatch) {
            try {
                publishedResult.get();
            }
            catch (ExecutionException e) {
                throw (Exception)e.getCause();
            }
        }
        return controlObservation.getValue();
    }

    private Void publishAsync(Observation<T> controlObservation, Future<Optional<Observation<T>>> observationFutureCandidate) throws Exception {
        Optional<Observation<T>> candidateObservation = Optional.empty();
        if (observationFutureCandidate != null) {
            candidateObservation = observationFutureCandidate.get();
        }
        this.countExceptions(candidateObservation, this.candidateExceptionCount);
        Result<T> result = new Result<T>(this, controlObservation, candidateObservation, this.context);
        this.publish(result);
        return null;
    }

    private void countExceptions(Optional<Observation<T>> observation, MetricsProvider.Counter exceptions) {
        if (observation.isPresent() && observation.get().getException().isPresent()) {
            exceptions.increment();
        }
    }

    public Observation<T> executeResult(String name, MetricsProvider.Timer timer, Callable<T> control, boolean shouldThrow) throws Exception {
        Observation observation = new Observation(name, timer);
        observation.time(() -> {
            try {
                observation.setValue(control.call());
            }
            catch (Exception e) {
                observation.setException(e);
            }
        });
        if (shouldThrow && observation.getException().isPresent()) {
            throw observation.getException().get();
        }
        return observation;
    }

    protected boolean compareResults(T controlVal, T candidateVal) {
        return this.comparator.apply(controlVal, candidateVal);
    }

    public boolean compare(Observation<T> controlVal, Observation<T> candidateVal) throws MismatchException {
        boolean resultsMatch = !candidateVal.getException().isPresent() && this.compareResults(controlVal.getValue(), candidateVal.getValue());
        this.totalCount.increment();
        if (!resultsMatch) {
            this.mismatchCount.increment();
            this.handleComparisonMismatch(controlVal, candidateVal);
        }
        return true;
    }

    protected void publish(Result<T> r) {
    }

    protected boolean runIf() {
        return true;
    }

    protected boolean enabled() {
        return true;
    }

    protected boolean isAsync() {
        return false;
    }

    protected boolean isAsyncCandidateOnly() {
        return false;
    }

    private void handleComparisonMismatch(Observation<T> controlVal, Observation<T> candidateVal) throws MismatchException {
        String msg;
        if (candidateVal.getException().isPresent()) {
            String stackTrace = candidateVal.getException().get().getStackTrace().toString();
            String exceptionName = candidateVal.getException().get().getClass().getName();
            msg = candidateVal.getName() + " raised an exception: " + exceptionName + " " + stackTrace;
        } else {
            msg = candidateVal.getName() + " does not match control value (" + controlVal.getValue().toString() + " != " + candidateVal.getValue().toString() + ")";
        }
        throw new MismatchException(msg);
    }
}

