/*
 * Decompiled with CFR 0.152.
 */
package org.jsdoc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.json.JsonParser;
import org.mozilla.javascript.tools.SourceReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleProvider
extends UrlModuleSourceProvider {
    private static final String DIRECTORY_CONTENT_TYPE = "text/html";

    public ModuleProvider(Iterable<URI> privilegedUris, Iterable<URI> fallbackUris) {
        super(privilegedUris, fallbackUris);
        System.out.println("WHOOPEE!!!");
    }

    @Override
    protected URLConnection openUrlConnection(URL url) throws IOException {
        System.out.println("WHEEEE!!!");
        URLConnection connection = url.openConnection();
        if (connection.getContentType() == DIRECTORY_CONTENT_TYPE) {
            URL mainJsFileUrl = this.getMainJsFile(url);
            return mainJsFileUrl.openConnection();
        }
        return connection;
    }

    private URL getMainJsFile(URL url) throws IOException {
        NativeObject packageFile;
        URI packageFilePath;
        try {
            packageFilePath = this.getPackageFilePath(url.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
        try {
            packageFile = this.parsePackageFile(packageFilePath);
        }
        catch (JsonParser.ParseException e) {
            return null;
        }
        String mainProperty = (String)packageFile.get("main", (Scriptable)packageFile);
        if (mainProperty != null) {
            return new File(url.toString() + mainProperty).toURI().toURL();
        }
        File index = new File(url.toString() + "/index.js");
        if (index.exists() && index.isFile()) {
            return index.toURI().toURL();
        }
        return null;
    }

    private NativeObject parsePackageFile(URI uri) throws IOException, JsonParser.ParseException {
        Object packageJson = SourceReader.readFileOrUrl(uri.toURL().toString(), true, "UTF-8");
        JsonParser parser = new JsonParser(null, null);
        return (NativeObject)parser.parseValue(packageJson.toString());
    }

    private URI getPackageFilePath(URI uri) {
        URI packageFilePath;
        try {
            packageFilePath = new URI(uri.toString() + "/package.json");
        }
        catch (URISyntaxException e) {
            packageFilePath = null;
        }
        return packageFilePath;
    }
}

