/*
 * Decompiled with CFR 0.152.
 */
package org.jsdoc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.json.JsonParser;
import org.mozilla.javascript.tools.SourceReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDocModuleProvider
extends UrlModuleSourceProvider {
    private static final String JS_EXTENSION = ".js";
    private static final String PATH_SEPARATOR = "/";
    private static final String PACKAGE_FILE = "package.json";
    private static final String MODULE_INDEX = "index.js";

    public JsDocModuleProvider(Iterable<URI> privilegedUris, Iterable<URI> fallbackUris) {
        super(privilegedUris, fallbackUris);
    }

    @Override
    protected ModuleSource loadFromUri(URI uri, URI base, Object validator) throws IOException, URISyntaxException {
        URI uriWithExtension = this.addJsExtension(uri);
        File jsFile = new File(uriWithExtension);
        File packageFile = new File(new URI(uri.toString() + PATH_SEPARATOR + PACKAGE_FILE));
        File indexFile = new File(new URI(uri.toString() + PATH_SEPARATOR + MODULE_INDEX));
        try {
            URI moduleUri = this.getModuleUri(jsFile, packageFile, indexFile);
            return this.loadFromActualUri(moduleUri, base, validator);
        }
        catch (Exception e) {
            return null;
        }
    }

    private URI getModuleUri(File jsFile, File packageFile, File indexFile) throws SecurityException, IOException, JsonParser.ParseException {
        URI packageMain;
        if (jsFile.isFile()) {
            return jsFile.toURI();
        }
        if (packageFile.isFile() && (packageMain = this.getPackageMain(packageFile)) != null) {
            return packageMain;
        }
        if (indexFile.isFile()) {
            return indexFile.toURI();
        }
        return null;
    }

    private URI getPackageMain(File packageFile) throws IOException, JsonParser.ParseException {
        NativeObject packageJson = this.parsePackageFile(packageFile);
        String mainFile = (String)packageJson.get("main");
        if (mainFile != null) {
            mainFile = this.addJsExtension(mainFile);
            return packageFile.toURI().resolve(mainFile);
        }
        return null;
    }

    private URI addJsExtension(URI uri) throws URISyntaxException {
        String str = uri.toString();
        return new URI(this.addJsExtension(str));
    }

    private String addJsExtension(String str) {
        if (!str.endsWith(JS_EXTENSION)) {
            str = str + JS_EXTENSION;
        }
        return str;
    }

    private NativeObject parsePackageFile(File packageFile) throws IOException, JsonParser.ParseException {
        String packageJson = SourceReader.readFileOrUrl(packageFile.toString(), true, "UTF-8").toString();
        Context cx = Context.enter();
        JsonParser parser = new JsonParser(cx, cx.initStandardObjects());
        NativeObject json = (NativeObject)parser.parseValue(packageJson);
        return json;
    }
}

