/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.annotation.DisableCellFormatXLS;
import com.poiji.annotation.ExcelCell;
import com.poiji.annotation.ExcelCellName;
import com.poiji.annotation.ExcelCellRange;
import com.poiji.annotation.ExcelCellsJoinedByName;
import com.poiji.annotation.ExcelRow;
import com.poiji.annotation.ExcelUnknownCells;
import com.poiji.bind.Unmarshaller;
import com.poiji.bind.mapping.PoijiWorkBook;
import com.poiji.config.Casting;
import com.poiji.config.Formatting;
import com.poiji.exception.IllegalCastException;
import com.poiji.exception.PoijiMultiRowException;
import com.poiji.option.PoijiOptions;
import com.poiji.util.AnnotationUtil;
import com.poiji.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.formula.BaseFormulaEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.util.StringUtil;

abstract class HSSFUnmarshaller
extends PoijiWorkBook
implements Unmarshaller {
    private final DataFormatter dataFormatter;
    protected final PoijiOptions options;
    private final Casting casting;
    private final Formatting formatting;
    private final Map<String, Integer> titleToIndex;
    private final Map<Integer, String> indexToTitle;
    private final int limit;
    private int internalCount;
    BaseFormulaEvaluator baseFormulaEvaluator;

    HSSFUnmarshaller(PoijiOptions options) {
        this.options = options;
        this.limit = options.getLimit();
        this.dataFormatter = new DataFormatter();
        this.titleToIndex = new HashMap<String, Integer>();
        this.indexToTitle = new HashMap<Integer, String>();
        this.casting = options.getCasting();
        this.formatting = options.getFormatting();
    }

    @Override
    public <T> void unmarshal(Class<T> type, Consumer<? super T> consumer) {
        HSSFWorkbook workbook = (HSSFWorkbook)this.workbook();
        Optional<String> maybeSheetName = this.getSheetName(type, this.options);
        this.baseFormulaEvaluator = HSSFFormulaEvaluator.create((HSSFWorkbook)workbook, null, null);
        Sheet sheet = this.getSheetToProcess((Workbook)workbook, this.options, maybeSheetName.orElse(null));
        this.processRowsToObjects(sheet, type, consumer);
    }

    <T> void processRowsToObjects(Sheet sheet, Class<T> type, Consumer<? super T> consumer) {
        int skip = this.options.skip();
        int maxPhysicalNumberOfRows = sheet.getPhysicalNumberOfRows() + 1 - skip;
        ArrayList<PoijiMultiRowException> errors = new ArrayList<PoijiMultiRowException>();
        this.loadColumnTitles(sheet, maxPhysicalNumberOfRows);
        AnnotationUtil.validateMandatoryNameColumns(this.options, this.formatting, type, this.titleToIndex, this.indexToTitle);
        for (Row currentRow : sheet) {
            if (this.skip(currentRow, skip) || this.isRowEmpty(currentRow)) continue;
            ++this.internalCount;
            if (this.limit != 0 && this.internalCount > this.limit) {
                return;
            }
            try {
                T instance = this.deserializeRowToInstance(currentRow, type);
                consumer.accept(instance);
            }
            catch (PoijiMultiRowException poijiRowException) {
                errors.add(poijiRowException);
            }
        }
        if (!errors.isEmpty()) {
            List<PoijiMultiRowException.PoijiRowSpecificException> allErrors = errors.stream().flatMap(e -> e.getErrors().stream()).collect(Collectors.toList());
            throw new PoijiMultiRowException("Problem(s) occurred while reading data", allErrors);
        }
    }

    private Sheet getSheetToProcess(Workbook workbook, PoijiOptions options, String sheetName) {
        int nonHiddenSheetIndex = 0;
        int requestedIndex = options.sheetIndex();
        Sheet sheet = null;
        if (options.ignoreHiddenSheets()) {
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                if (workbook.isSheetHidden(i) || workbook.isSheetVeryHidden(i)) continue;
                if (sheetName == null ? nonHiddenSheetIndex == requestedIndex : workbook.getSheetName(i).equalsIgnoreCase(sheetName)) {
                    return workbook.getSheetAt(i);
                }
                ++nonHiddenSheetIndex;
            }
        } else {
            sheet = sheetName == null ? workbook.getSheetAt(requestedIndex) : workbook.getSheet(sheetName);
        }
        return sheet;
    }

    private void loadColumnTitles(Sheet sheet, int maxPhysicalNumberOfRows) {
        if (maxPhysicalNumberOfRows > 0) {
            int row = this.options.getHeaderStart();
            int headerCount = this.options.getHeaderCount();
            if (headerCount == 0) {
                return;
            }
            for (int i = 0; i < headerCount; i = (int)((short)(i + 1))) {
                Row firstRow = sheet.getRow(row + i);
                for (Cell cell : firstRow) {
                    int columnIndex = cell.getColumnIndex();
                    String titleName = this.formatting.transform(this.options, cell.getStringCellValue());
                    this.indexToTitle.put(columnIndex, this.getTitleNameForMap(titleName, columnIndex));
                    this.titleToIndex.put(titleName, columnIndex);
                }
            }
        }
    }

    private String getTitleNameForMap(String cellContent, int columnIndex) {
        if (this.indexToTitle.containsValue(cellContent) || cellContent.isEmpty()) {
            return cellContent + "@" + columnIndex;
        }
        return cellContent;
    }

    <T> T deserializeRowToInstance(Row currentRow, Class<T> type) {
        T instance = ReflectUtil.newInstanceOf(type);
        return this.setFieldValuesFromRowIntoInstance(currentRow, type, instance);
    }

    private <T> T tailSetFieldValue(Row currentRow, Class<? super T> type, T instance) {
        Map<String, String> excelUnknownCellsMap;
        ArrayList<Integer> mappedColumnIndices = new ArrayList<Integer>();
        ArrayList<Field> unknownCells = new ArrayList<Field>();
        ArrayList<PoijiMultiRowException.PoijiRowSpecificException> errors = new ArrayList<PoijiMultiRowException.PoijiRowSpecificException>();
        for (Field field2 : type.getDeclaredFields()) {
            if (field2.getModifiers() == 25) continue;
            if (field2.getAnnotation(ExcelRow.class) != null) {
                int rowNum = currentRow.getRowNum();
                Object data = this.casting.castValue(field2, String.valueOf(rowNum), rowNum, -1, this.options);
                this.setFieldData(instance, field2, data);
                continue;
            }
            if (field2.getAnnotation(ExcelCellRange.class) != null) {
                Class<?> fieldType = field2.getType();
                Object fieldInstance = ReflectUtil.newInstanceOf(fieldType);
                for (Field fieldField : fieldType.getDeclaredFields()) {
                    this.mapColumns(currentRow, fieldInstance, mappedColumnIndices, errors, fieldField);
                }
                this.setFieldData(instance, field2, fieldInstance);
                continue;
            }
            if (field2.getAnnotation(ExcelUnknownCells.class) != null) {
                unknownCells.add(field2);
                continue;
            }
            this.mapColumns(currentRow, instance, mappedColumnIndices, errors, field2);
        }
        if (!errors.isEmpty()) {
            throw new PoijiMultiRowException("Problem(s) occurred while reading data", errors);
        }
        if (unknownCells.isEmpty()) {
            return instance;
        }
        if (!this.indexToTitle.isEmpty()) {
            excelUnknownCellsMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(currentRow.cellIterator(), 16), false).filter(cell -> !mappedColumnIndices.contains(cell.getColumnIndex())).collect(Collectors.toMap(cell -> this.indexToTitle.get(cell.getColumnIndex()), Object::toString));
            unknownCells.forEach(field -> this.setFieldData(instance, (Field)field, excelUnknownCellsMap));
        } else {
            excelUnknownCellsMap = StreamSupport.stream(Spliterators.spliteratorUnknownSize(currentRow.cellIterator(), 16), false).filter(cell -> !mappedColumnIndices.contains(cell.getColumnIndex())).collect(Collectors.toMap(cell -> String.valueOf(cell.getColumnIndex()), Object::toString));
            unknownCells.forEach(field -> this.setFieldData(instance, (Field)field, excelUnknownCellsMap));
        }
        return instance;
    }

    private <T> void mapColumns(Row currentRow, T instance, List<Integer> mappedColumnIndices, List<PoijiMultiRowException.PoijiRowSpecificException> errors, Field field) {
        try {
            mappedColumnIndices.add(this.tailSetFieldValue(currentRow, instance, field));
        }
        catch (PoijiMultiRowException.PoijiRowSpecificException poijiRowException) {
            errors.add(poijiRowException);
        }
    }

    private <T> Integer tailSetFieldValue(Row currentRow, T instance, Field field) {
        FieldAnnotationDetail annotationDetail = this.getFieldColumn(field);
        if (annotationDetail.getColumn() != null) {
            this.constructTypeValue(currentRow, instance, field, annotationDetail);
        }
        if (CollectionUtils.isNotEmpty(annotationDetail.getColumns())) {
            for (Integer column : annotationDetail.getColumns()) {
                annotationDetail.setColumn(column);
                this.constructTypeValue(currentRow, instance, field, annotationDetail);
            }
        }
        return annotationDetail.getColumn();
    }

    private FieldAnnotationDetail getFieldColumn(Field field) {
        ExcelCellsJoinedByName excelCellsJoinedByName;
        ExcelCellName excelCellName;
        ExcelCell index;
        DisableCellFormatXLS disableCellFormat = field.getAnnotation(DisableCellFormatXLS.class);
        FieldAnnotationDetail annotationDetail = new FieldAnnotationDetail();
        if (disableCellFormat != null) {
            annotationDetail.setDisabledCellFormat(disableCellFormat.value());
        }
        if ((index = field.getAnnotation(ExcelCell.class)) != null) {
            annotationDetail.setColumn(index.value());
            annotationDetail.setMandatoryCell(index.mandatoryCell());
        }
        if ((excelCellName = field.getAnnotation(ExcelCellName.class)) != null) {
            annotationDetail.setMandatoryCell(excelCellName.mandatoryCell());
            annotationDetail.setColumnName(excelCellName.value());
            Integer column = this.findTitleColumn(excelCellName);
            annotationDetail.setColumn(column);
        }
        if ((excelCellsJoinedByName = field.getAnnotation(ExcelCellsJoinedByName.class)) != null) {
            String expression = excelCellsJoinedByName.expression();
            Pattern pattern = Pattern.compile(expression);
            List<Integer> columns = this.indexToTitle.entrySet().stream().filter(entry -> pattern.matcher(((String)entry.getValue()).replaceAll("@[0-9]+", "")).matches()).map(Map.Entry::getKey).collect(Collectors.toList());
            annotationDetail.setColumns(columns);
            annotationDetail.setMultiValueMap(CollectionUtils.isNotEmpty(columns));
        }
        return annotationDetail;
    }

    public Integer findTitleColumn(ExcelCellName excelCellName) {
        if (!StringUtil.isBlank((CharSequence)excelCellName.value())) {
            String titleName = this.formatting.transform(this.options, excelCellName.value());
            return this.titleToIndex.get(titleName);
        }
        if (!StringUtil.isBlank((CharSequence)excelCellName.expression())) {
            String titleName = this.formatting.transform(this.options, excelCellName.expression());
            Pattern pattern = Pattern.compile(titleName);
            return this.titleToIndex.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).matches()).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return null;
    }

    private <T> void constructTypeValue(Row currentRow, T instance, Field field, FieldAnnotationDetail annotationDetail) {
        Cell cell = currentRow.getCell(annotationDetail.getColumn().intValue());
        if (cell != null) {
            if (annotationDetail.isDisabledCellFormat()) {
                cell.setCellStyle(null);
            }
            String value = this.options.isRawData() && this.isCellNumeric(cell) ? NumberToTextConverter.toText((double)cell.getNumericCellValue()) : this.dataFormatter.formatCellValue(cell, (FormulaEvaluator)this.baseFormulaEvaluator);
            Object data = this.casting.castValue(field, value, currentRow.getRowNum(), annotationDetail.getColumn(), this.options);
            if (!annotationDetail.isMultiValueMap()) {
                this.setFieldData(instance, field, data);
            } else {
                String titleColumn = this.indexToTitle.get(annotationDetail.getColumn());
                titleColumn = titleColumn.replaceAll("@[0-9]+", "");
                this.putFieldMultiValueMapData(instance, field, titleColumn, data);
            }
        } else if (annotationDetail.isMandatoryCell()) {
            throw new PoijiMultiRowException.PoijiRowSpecificException(annotationDetail.getColumnName(), field.getName(), currentRow.getRowNum());
        }
    }

    private boolean isCellNumeric(Cell cell) {
        return cell.getCellType() == CellType.NUMERIC || cell.getCellType() == CellType.FORMULA && cell.getCachedFormulaResultType() == CellType.NUMERIC;
    }

    private <T> void setFieldData(T instance, Field field, Object data) {
        try {
            field.setAccessible(true);
            field.set(instance, data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + String.valueOf(data) + "} of field" + field.getName());
        }
    }

    public void putFieldMultiValueMapData(Object instance, Field field, String columnName, Object o) {
        try {
            field.setAccessible(true);
            MultiValuedMap multiValuedMap = (MultiValuedMap)field.get(instance);
            multiValuedMap.put((Object)columnName, o);
        }
        catch (ClassCastException | IllegalAccessException e) {
            throw new IllegalCastException("Unexpected cast type {" + String.valueOf(o) + "} of field" + field.getName());
        }
    }

    private <T> T setFieldValuesFromRowIntoInstance(Row currentRow, Class<? super T> subclass, T instance) {
        return subclass == null ? instance : this.tailSetFieldValue(currentRow, subclass, this.setFieldValuesFromRowIntoInstance(currentRow, subclass.getSuperclass(), instance));
    }

    boolean skip(Row currentRow, int skip) {
        return currentRow.getRowNum() + 1 <= skip;
    }

    boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            if (cell == null || cell.getCellType() == CellType.BLANK) continue;
            return false;
        }
        return true;
    }

    private static class FieldAnnotationDetail {
        private Integer column;
        private String columnName;
        private boolean disabledCellFormat;
        private boolean mandatoryCell;
        private List<Integer> columns;
        private boolean multiValueMap;

        private FieldAnnotationDetail() {
        }

        Integer getColumn() {
            return this.column;
        }

        void setColumn(Integer column) {
            this.column = column;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        boolean isDisabledCellFormat() {
            return this.disabledCellFormat;
        }

        void setDisabledCellFormat(boolean disabledCellFormat) {
            this.disabledCellFormat = disabledCellFormat;
        }

        public boolean isMandatoryCell() {
            return this.mandatoryCell;
        }

        public void setMandatoryCell(boolean mandatoryCell) {
            this.mandatoryCell = mandatoryCell;
        }

        public List<Integer> getColumns() {
            return this.columns;
        }

        public void setColumns(List<Integer> columns) {
            this.columns = columns;
        }

        public boolean isMultiValueMap() {
            return this.multiValueMap;
        }

        public void setMultiValueMap(boolean multiValueMap) {
            this.multiValueMap = multiValueMap;
        }
    }
}

