/*
 * Decompiled with CFR 0.152.
 */
package com.poiji.bind.mapping;

import com.poiji.bind.PropertyUnmarshaller;
import com.poiji.bind.mapping.PropertyHandler;
import com.poiji.exception.PoijiException;
import com.poiji.option.PoijiOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class HSSFPropertyStream
implements PropertyUnmarshaller {
    private final PoijiOptions options;
    private InputStream inputStream;

    HSSFPropertyStream(InputStream inputStream, PoijiOptions options) {
        this.inputStream = inputStream;
        this.options = options;
    }

    @Override
    public <T> T unmarshal(Class<T> type) {
        if (this.options.getPassword() != null) {
            return this.returnFromEncryptedFile(type);
        }
        return this.returnFromExcelFile(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T returnFromExcelFile(Class<T> type) {
        try (OPCPackage open = OPCPackage.open((InputStream)this.inputStream);){
            PropertyHandler propertyHandler = new PropertyHandler();
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(open);
            T ret = propertyHandler.unmarshal(type, xssfWorkbook.getProperties());
            xssfWorkbook.close();
            T t = ret;
            return t;
        }
        catch (IOException | OpenXML4JException e) {
            throw new PoijiException("Problem occurred while reading data", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T returnFromEncryptedFile(Class<T> type) {
        try (POIFSFileSystem fs = new POIFSFileSystem(this.inputStream);){
            T t;
            OPCPackage open;
            block16: {
                InputStream stream = DocumentFactoryHelper.getDecryptedStream((POIFSFileSystem)fs, (String)this.options.getPassword());
                open = OPCPackage.open((InputStream)stream);
                PropertyHandler propertyHandler = new PropertyHandler();
                XSSFWorkbook xssfWorkbook = new XSSFWorkbook(open);
                T ret = propertyHandler.unmarshal(type, xssfWorkbook.getProperties());
                xssfWorkbook.close();
                t = ret;
                if (open == null) break block16;
                open.close();
            }
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        if (open != null) {
                            try {
                                open.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | OpenXML4JException e) {
                        IOUtils.closeQuietly((Closeable)fs);
                        throw new PoijiException("Problem occurred while reading data", e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PoijiException("Problem occurred while reading data", e);
        }
    }
}

