/*
 * Decompiled with CFR 0.152.
 */
package com.github.mchernyakov.variousttlmap.applied.cleaner;

import com.github.mchernyakov.variousttlmap.VariousTtlMapImpl;
import com.github.mchernyakov.variousttlmap.applied.cleaner.BackgroundMapCleaner;
import com.github.mchernyakov.variousttlmap.util.Preconditions;
import com.github.mchernyakov.variousttlmap.util.ThreadUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBackgroundMapCleaner<K, V>
implements BackgroundMapCleaner<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBackgroundMapCleaner.class);
    private static final int HUNDRED_PERCENT = 100;
    private static final int RED_LINE_PERCENT = 90;
    private final long delayTime;
    private final int numKeyCheck;
    private final int percentWaterMark;
    protected final int poolSize;
    protected final VariousTtlMapImpl<K, V> map;
    protected final ScheduledExecutorService executorService;

    public AbstractBackgroundMapCleaner(VariousTtlMapImpl<K, V> variousTtlMap, BackgroundMapCleaner.Builder<K, V> builder) {
        Preconditions.checkArgument(builder.poolSize > 0);
        Preconditions.checkArgument(builder.numKeyCheck > 0);
        Preconditions.checkArgument(builder.delayTime > 0L);
        Preconditions.checkArgument(builder.percentWaterMark > 0);
        Preconditions.checkArgument(builder.percentWaterMark < 100);
        this.delayTime = builder.delayTime;
        this.numKeyCheck = builder.numKeyCheck;
        this.poolSize = builder.poolSize;
        this.percentWaterMark = builder.percentWaterMark;
        this.map = variousTtlMap;
        ThreadFactory factory = ThreadUtil.threadFactory("map-cleaner");
        this.executorService = Executors.newScheduledThreadPool(this.poolSize, factory);
    }

    @Override
    public void startCleaners() {
        for (int i = 0; i < this.poolSize; ++i) {
            this.executorService.scheduleAtFixedRate(this.task(), 0L, this.delayTime, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable task() {
        return () -> {
            try {
                List<K> keysAsArray;
                this.additionalInit();
                if (logger.isDebugEnabled()) {
                    logger.debug("Start cleaning");
                }
                while ((keysAsArray = this.getKeys()) != null) {
                    int numRemovedKeys;
                    int size = keysAsArray.size();
                    if (size == 0) {
                        return;
                    }
                    while (this.checkExcessWaterMark(size, numRemovedKeys = this.tryRemoveKeys(keysAsArray))) {
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Finish clean. num done {}, start size {}", (Object)numRemovedKeys, (Object)size);
                }
            }
            catch (Exception e) {
                logger.warn("Error while cleaning map", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.additionalFinally();
            }
        };
    }

    abstract void additionalInit();

    abstract void additionalFinally();

    abstract List<K> getKeys();

    @VisibleForTesting
    boolean checkExcessWaterMark(int size, int numDone) {
        float percent = (float)(100 * numDone) / (float)size;
        return percent > (float)this.percentWaterMark && percent < 90.0f;
    }

    private int tryRemoveKeys(List<K> keys) {
        int numAttempt = 0;
        int numRemovedKeys = 0;
        int size = keys.size();
        while (this.processCondition(numAttempt, size)) {
            if (this.checkRandomKey(keys)) {
                ++numRemovedKeys;
            }
            ++numAttempt;
        }
        return numRemovedKeys;
    }

    private boolean processCondition(int numAttempt, int arraySize) {
        return arraySize != 0 && numAttempt < this.numKeyCheck && numAttempt < arraySize;
    }

    private boolean checkRandomKey(List<K> keys) {
        int num = AbstractBackgroundMapCleaner.getRandomIndex(keys.size());
        K key = keys.get(num);
        if (this.map.checkExpired(key)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Remove key: {}", key);
            }
            this.map.remove(key);
            return true;
        }
        return false;
    }

    private static int getRandomIndex(int size) {
        if (size == 1) {
            return 0;
        }
        return ThreadLocalRandom.current().nextInt(size - 1);
    }

    @Override
    public void shutdown() {
        ThreadUtil.shutdownExecutorService(this.executorService);
    }
}

