/*
 * Decompiled with CFR 0.152.
 */
package com.github.mchernyakov.variousttlmap;

import com.github.mchernyakov.variousttlmap.VariousTtlMap;
import com.github.mchernyakov.variousttlmap.applied.PrimitiveMapWrapper;
import com.github.mchernyakov.variousttlmap.applied.cleaner.BackgroundMapCleaner;
import com.github.mchernyakov.variousttlmap.util.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariousTtlMapImpl<K, V>
implements VariousTtlMap<K, V> {
    private final ConcurrentHashMap<K, V> store;
    private final PrimitiveMapWrapper ttlMap;
    private final BackgroundMapCleaner<K, V> mapCleaner;
    private final long defaultTtl;
    private final TimeUnit timeUnit = TimeUnit.SECONDS;

    private VariousTtlMapImpl(Builder<K, V> builder) {
        Preconditions.checkArgument(builder.defaultTtl > 0L);
        this.defaultTtl = this.timeUnit.toNanos(builder.defaultTtl);
        this.store = new ConcurrentHashMap();
        this.ttlMap = new PrimitiveMapWrapper();
        this.mapCleaner = BackgroundMapCleaner.Builder.newBuilder().setPoolSize(builder.cleaningPoolSize).setDelayTime(builder.delayMillis).setNumKeyCheck(builder.numCleaningAttemptsPerSession).setPercentWaterMark(builder.waterMarkPercent).build(this);
        this.mapCleaner.startCleaners();
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        if (this.checkExpired(key)) {
            this.remove(key);
            return null;
        }
        return this.store.get(key);
    }

    @Override
    public V put(@NotNull K key, V value) {
        this.ttlMap.put(key.hashCode(), System.nanoTime() + this.defaultTtl);
        return this.store.put(key, value);
    }

    @Override
    public V put(@NotNull K key, V value, long ttlSeconds) {
        this.ttlMap.put(key.hashCode(), System.nanoTime() + this.timeUnit.toNanos(ttlSeconds));
        return this.store.put(key, value);
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public V remove(@NotNull K key) {
        this.ttlMap.remove(key.hashCode());
        return this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
        this.ttlMap.clear();
    }

    public boolean checkExpired(@NotNull K key) {
        long ttl = this.ttlMap.get(key.hashCode());
        return System.nanoTime() > ttl;
    }

    @Override
    public Map<K, V> getStore() {
        return this.store;
    }

    @Override
    public BackgroundMapCleaner<K, V> getMapCleaner() {
        return this.mapCleaner;
    }

    @Override
    public void shutdown() {
        this.mapCleaner.shutdown();
        this.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public String toString() {
        return "VariousTtlMapImpl{store=" + this.store + ", ttlMap=" + this.ttlMap + ", mapCleaner=" + this.mapCleaner + ", defaultTtl=" + this.defaultTtl + ", timeUnit=" + (Object)((Object)this.timeUnit) + '}';
    }

    public static final class Builder<K, V> {
        long defaultTtl;
        int cleaningPoolSize = 1;
        int numCleaningAttemptsPerSession = 10;
        int waterMarkPercent = 10;
        int delayMillis = 1000;

        private Builder() {
        }

        public static Builder<Object, Object> newBuilder() {
            return new Builder<Object, Object>();
        }

        public Builder<K, V> setDefaultTtl(long defaultTtl) {
            this.defaultTtl = defaultTtl;
            return this;
        }

        public Builder<K, V> setCleaningPoolSize(int cleaningPoolSize) {
            this.cleaningPoolSize = cleaningPoolSize;
            return this;
        }

        public Builder<K, V> setNumCleaningAttemptsPerSession(int numCleaningAttemptsPerSession) {
            this.numCleaningAttemptsPerSession = numCleaningAttemptsPerSession;
            return this;
        }

        public Builder<K, V> setWaterMarkPercent(int waterMarkPercent) {
            this.waterMarkPercent = waterMarkPercent;
            return this;
        }

        public Builder<K, V> setDelayMillis(int delayMillis) {
            this.delayMillis = delayMillis;
            return this;
        }

        public <K1 extends K, V1 extends V> VariousTtlMapImpl<K1, V1> build() {
            Builder self = this;
            return new VariousTtlMapImpl(self);
        }
    }
}

