/*
 * Decompiled with CFR 0.152.
 */
package com.github.kischang.fastdfs;

import com.github.kischang.fastdfs.exception.FastDFSException;
import com.github.kischang.fastdfs.pool.PoolConfig;
import java.net.InetSocketAddress;
import java.util.List;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerGroup;

public class FastDFSTemplateFactory {
    private int g_connect_timeout;
    private int g_network_timeout;
    private String g_charset;
    private int g_tracker_http_port;
    private boolean g_anti_steal_token;
    private String g_secret_key;
    private List<String> tracker_servers;
    private TrackerGroup g_tracker_group;
    private PoolConfig poolConfig = new PoolConfig();

    public void init() throws Exception {
        if (this.g_connect_timeout <= 0) {
            this.g_connect_timeout = 5;
        }
        if (this.g_network_timeout <= 0) {
            this.g_network_timeout = 30;
        }
        this.g_connect_timeout *= 1000;
        this.g_network_timeout *= 1000;
        if (this.g_charset == null || this.g_charset.length() == 0) {
            this.g_charset = "UTF-8";
        }
        if (this.g_tracker_http_port <= 0) {
            this.g_tracker_http_port = 80;
        }
        if (this.tracker_servers == null || this.tracker_servers.isEmpty()) {
            throw new FastDFSException("item \"tracker_server\"  not found", -1);
        }
        InetSocketAddress[] tracker_servers_socket = new InetSocketAddress[this.tracker_servers.size()];
        for (int i = 0; i < this.tracker_servers.size(); ++i) {
            String str = this.tracker_servers.get(i);
            String[] parts = str.split("\\:", 2);
            if (parts.length != 2) {
                throw new FastDFSException("the value of item \"tracker_server\" is invalid, the correct format is host:port", -2);
            }
            tracker_servers_socket[i] = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        this.g_tracker_group = new TrackerGroup(tracker_servers_socket);
        if (this.g_anti_steal_token && (this.g_secret_key == null || "".equals(this.g_secret_key))) {
            throw new FastDFSException("item \"secret_key\"  not found", -2);
        }
        this.setToGlobal();
    }

    private void setToGlobal() {
        ClientGlobal.setG_connect_timeout(this.g_connect_timeout);
        ClientGlobal.setG_network_timeout(this.g_network_timeout);
        ClientGlobal.setG_charset(this.g_charset);
        ClientGlobal.setG_tracker_http_port(this.g_tracker_http_port);
        ClientGlobal.setG_anti_steal_token(this.g_anti_steal_token);
        ClientGlobal.setG_secret_key(this.g_secret_key);
        ClientGlobal.setG_tracker_group(this.g_tracker_group);
    }

    public PoolConfig getPoolConfig() {
        if (this.poolConfig == null) {
            return new PoolConfig();
        }
        return this.poolConfig;
    }

    public void setPoolConfig(PoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public void setG_connect_timeout(int g_connect_timeout) {
        this.g_connect_timeout = g_connect_timeout;
    }

    public void setG_network_timeout(int g_network_timeout) {
        this.g_network_timeout = g_network_timeout;
    }

    public void setG_charset(String g_charset) {
        this.g_charset = g_charset;
    }

    public void setG_tracker_http_port(int g_tracker_http_port) {
        this.g_tracker_http_port = g_tracker_http_port;
    }

    public void setG_anti_steal_token(boolean g_anti_steal_token) {
        this.g_anti_steal_token = g_anti_steal_token;
    }

    public void setG_secret_key(String g_secret_key) {
        this.g_secret_key = g_secret_key;
    }

    public void setTracker_servers(List<String> tracker_servers) {
        this.tracker_servers = tracker_servers;
    }

    public void setG_tracker_group(TrackerGroup g_tracker_group) {
        this.g_tracker_group = g_tracker_group;
    }

    public TrackerGroup getG_tracker_group() {
        return this.g_tracker_group;
    }
}

