/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlgrock.javascriptframework.jsdependency;

import com.github.jlgrock.javascriptframework.mavenutils.io.DirectoryIO;
import com.github.jlgrock.javascriptframework.mavenutils.io.ResourceIO;
import com.github.jlgrock.javascriptframework.mavenutils.io.ZipUtils;
import com.github.jlgrock.javascriptframework.mavenutils.logging.MojoLogAppender;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.ArtifactExtractor;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.JsarRelativeLocations;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.PackagingType;
import com.github.jlgrock.javascriptframework.mavenutils.mavenobjects.ScopeType;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractDependencyMojo
extends AbstractMojo {
    public static final String CLOSURE_LIBRARY_NAME = "closure-library-99cd91";
    private boolean skipGoogleExtraction;
    private static final Logger LOGGER = Logger.getLogger(AbstractDependencyMojo.class);
    private File closureExtractLibDirectory;

    public abstract MavenProject getProject();

    public final boolean isSkipGoogleExtraction() {
        return this.skipGoogleExtraction;
    }

    public final File getClosureExtractLibDirectory() {
        return this.closureExtractLibDirectory;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        MojoLogAppender.beginLogging((AbstractMojo)this);
        try {
            LOGGER.info((Object)("Creating output directory at location \"" + this.getFrameworkTargetDirectory().getAbsolutePath() + "\"."));
            DirectoryIO.createDir((File)this.getFrameworkTargetDirectory().getParentFile());
            this.extractDependencies();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to access artifact dependency object: " + e.getMessage());
        }
        finally {
            MojoLogAppender.endLogging();
        }
    }

    protected abstract void extractDependencies() throws IOException, MojoFailureException, MojoExecutionException;

    protected final void extractAndRenameLibrary() throws IOException {
        String zipName = "closure-library-99cd91.zip";
        File libFile = new File(this.getFrameworkTargetDirectory(), CLOSURE_LIBRARY_NAME);
        File stdFile = new File(this.getFrameworkTargetDirectory(), "closure-library");
        LOGGER.info((Object)("Extracting google closure library to location \"" + this.getFrameworkTargetDirectory().getAbsolutePath() + "\""));
        FileUtils.deleteDirectory((File)libFile);
        FileUtils.deleteDirectory((File)stdFile);
        ZipUtils.unzip((ZipInputStream)ResourceIO.getResourceAsZipStream((String)zipName), (File)this.getFrameworkTargetDirectory());
        FileUtils.rename((File)libFile, (File)stdFile);
    }

    protected final void extractInterns(boolean extractAssert) throws IOException, MojoFailureException, MojoExecutionException {
        Set artifactSet = this.getProject().getArtifacts();
        ArtifactExtractor extractJSArtifacts = new ArtifactExtractor(artifactSet);
        if (extractAssert) {
            File assertLocation = JsarRelativeLocations.getInternsAssertLocation((File)this.getFrameworkTargetDirectory());
            LOGGER.info((Object)("Extracting internal assert dependencies to location \"" + assertLocation.getAbsolutePath() + File.separator + "assertionSource" + "\""));
            extractJSArtifacts.extract("assertionSource/", PackagingType.JSAR, ScopeType.COMPILE, assertLocation);
        }
        File debugLocation = JsarRelativeLocations.getInternsDebugLocation((File)this.getFrameworkTargetDirectory());
        LOGGER.info((Object)("Extracting internal debug dependencies to location \"" + debugLocation.getAbsolutePath() + File.separator + "debugSource" + "\""));
        extractJSArtifacts.extract("debugSource/", PackagingType.JSAR, ScopeType.COMPILE, debugLocation);
    }

    protected final void extractExterns(Set<Artifact> artifactSet) throws IOException, MojoFailureException, MojoExecutionException {
        ArtifactExtractor extractJSArtifacts = new ArtifactExtractor(artifactSet);
        File location = JsarRelativeLocations.getExternsLocation((File)this.getFrameworkTargetDirectory());
        LOGGER.info((Object)("Extracting external dependencies to location \"" + location.getAbsolutePath() + "\""));
        extractJSArtifacts.extract("externDependencies/", PackagingType.JSAR, ScopeType.COMPILE, location);
    }

    public abstract File getFrameworkTargetDirectory();
}

