/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;

public final class DateUtil {
    public static final String PURE_DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_ZH_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PURE_TIME_FORMAT = "HHmmss";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String TIME_ZH_FORMAT = "HH\u65f6mm\u5206ss\u79d2";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TIME_SEC_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_17 = "yyyyMMddHHmmssSSS";
    public static final String TIMESTAMP_FORMAT_14 = "yyyyMMddHHmmss";
    public static final String TIMESTAMP_FORMAT_15 = "yyMMddHHmmssSSS";

    private DateUtil() {
    }

    public static String getDateFormat(Date date, String format) {
        if (ObjectUtil.isNull(date)) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String getDateFormat17(Date date) {
        return DateUtil.getDateFormat(date, TIMESTAMP_FORMAT_17);
    }

    public static String getDateFormat14(Date date) {
        return DateUtil.getDateFormat(date, TIMESTAMP_FORMAT_14);
    }

    public static Date getFormatDate(String dateStr, String format) {
        if (StringUtil.isEmptyTrim(dateStr)) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).parse(dateStr);
        }
        catch (ParseException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Date getFormatDate17(String dateStr) {
        return DateUtil.getFormatDate(dateStr, TIMESTAMP_FORMAT_17);
    }

    public static Date getFormatDate14(String dateStr) {
        return DateUtil.getFormatDate(dateStr, TIMESTAMP_FORMAT_14);
    }

    public static String getCurrentDateStr() {
        Date now = new Date();
        return new SimpleDateFormat(DATE_FORMAT).format(now);
    }

    public static String getCurrentTimeStampStr() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_17).format(now);
    }

    public static String getCurrentTime17() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_17).format(now);
    }

    public static String getCurrentTime14() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_14).format(now);
    }

    public static String getCurrentTimeStampStr15() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_15).format(now);
    }

    public static String getCurrentTimeMills() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String getCurrentDateTimeStr() {
        Date now = new Date();
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(now);
    }

    public static long convertMsToNs(long ms) {
        return TimeUnit.NANOSECONDS.convert(ms > 0L ? ms : 0L, TimeUnit.MILLISECONDS);
    }

    public static Date now() {
        return new Date();
    }

    public static long costTimeInMills(Date start, Date end) {
        return end.getTime() - start.getTime();
    }

    public static void sleep(long pauseMills) {
        DateUtil.sleep(TimeUnit.MILLISECONDS, pauseMills);
    }

    public static void sleep(TimeUnit unit, long timeout) {
        if (timeout <= 0L) {
            return;
        }
        try {
            unit.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommonRuntimeException(e);
        }
    }

    public static Date fromSql(java.sql.Date date) {
        if (null == date) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static java.sql.Date toSqlDate(Date date) {
        if (null == date) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Time toSqlTime(Date date) {
        if (null == date) {
            return null;
        }
        return new Time(date.getTime());
    }

    public static Timestamp toSqlTimestamp(Date date) {
        if (null == date) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Date addYear(Date date, int year) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(1, year);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, month);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        return calendar.getTime();
    }

    public static Date addHour(Date date, int hour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(11, hour);
        return calendar.getTime();
    }

    public static Date addMinute(Date date, int minute) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(12, minute);
        return calendar.getTime();
    }

    public static Date addSecond(Date date, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(13, second);
        return calendar.getTime();
    }
}

