/*
 * Decompiled with CFR 0.152.
 */
package br.com.goncalves.pugnotification.notification;

import android.app.NotificationManager;
import android.content.Context;
import br.com.goncalves.pugnotification.notification.Load;

public class PugNotification {
    private static final String TAG = PugNotification.class.getSimpleName();
    public static PugNotification mSingleton = null;
    public final Context mContext;
    public boolean shutdown;

    public PugNotification(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PugNotification with(Context context) {
        if (mSingleton != null) return mSingleton;
        Class<PugNotification> clazz = PugNotification.class;
        synchronized (PugNotification.class) {
            if (mSingleton != null) return mSingleton;
            mSingleton = new Contractor(context).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mSingleton;
        }
    }

    public Load load() {
        return new Load();
    }

    public void cancel(int identifier) {
        NotificationManager notifyManager = (NotificationManager)this.mContext.getSystemService("notification");
        notifyManager.cancel(identifier);
    }

    public void cancel(String tag, int identifier) {
        NotificationManager notifyManager = (NotificationManager)this.mContext.getSystemService("notification");
        notifyManager.cancel(tag, identifier);
    }

    public void shutdown() {
        if (this == mSingleton) {
            throw new UnsupportedOperationException("Default singleton instance cannot be shutdown.");
        }
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
    }

    private static class Contractor {
        private final Context mContext;

        public Contractor(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.mContext = context.getApplicationContext();
        }

        public PugNotification build() {
            return new PugNotification(this.mContext);
        }
    }
}

