/*
 * Decompiled with CFR 0.152.
 */
package br.com.goncalves.pugnotification.notification;

import android.app.Notification;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.util.Log;
import android.widget.RemoteViews;
import br.com.goncalves.pugnotification.notification.PugNotification;

public abstract class Builder {
    private static final String TAG = Builder.class.getSimpleName();
    protected String tag;
    protected Notification notification;
    protected NotificationCompat.Builder builder;
    protected int notificationId;

    public Builder(NotificationCompat.Builder builder, int identifier, String tag) {
        this.builder = builder;
        this.notificationId = identifier;
        this.tag = tag;
    }

    public void build() {
        this.notification = this.builder.build();
    }

    public void setBigContentView(RemoteViews views) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.notification.bigContentView = views;
            return;
        }
        Log.w((String)TAG, (String)"Version does not support big content view");
    }

    protected Notification notificationNotify() {
        if (this.tag != null) {
            return this.notificationNotify(this.tag, this.notificationId);
        }
        return this.notificationNotify(this.notificationId);
    }

    protected Notification notificationNotify(int identifier) {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)PugNotification.mSingleton.mContext);
        notificationManager.notify(identifier, this.notification);
        return this.notification;
    }

    protected Notification notificationNotify(String tag, int identifier) {
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)PugNotification.mSingleton.mContext);
        notificationManager.notify(tag, identifier, this.notification);
        return this.notification;
    }
}

