/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j;

import com.github.fracpete.rsync4j.core.AbstractBinary;
import com.github.fracpete.rsync4j.core.Binaries;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;

public class SshPass
extends AbstractBinary {
    protected String password;
    protected String filename;
    protected boolean fromEnvVar;
    protected boolean verbose;

    @Override
    public void reset() {
        super.reset();
        this.password = "";
        this.filename = "";
        this.fromEnvVar = false;
        this.verbose = false;
    }

    public SshPass password(String value) {
        this.password = value;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public SshPass filename(String value) {
        this.filename = value;
        return this;
    }

    public String getFilename() {
        return this.filename;
    }

    public SshPass fromEnvVar(boolean value) {
        this.fromEnvVar = value;
        return this;
    }

    public boolean getFromEnvVar() {
        return this.fromEnvVar;
    }

    public SshPass verbose(boolean value) {
        this.verbose = value;
        return this;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    @Override
    public SshPass outputCommandline(boolean value) {
        return (SshPass)super.outputCommandline(value);
    }

    @Override
    public List<String> options() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.getPassword().isEmpty()) {
            result.add("-p");
            result.add(this.getPassword());
        }
        if (!this.getFilename().isEmpty()) {
            result.add("-f");
            result.add(this.getFilename());
        }
        if (this.getFromEnvVar()) {
            result.add("-e");
        }
        if (this.getVerbose()) {
            result.add("-v");
        }
        return result;
    }

    @Override
    public List<String> commandLineArgs() throws Exception {
        String binary = Binaries.sshpassBinary();
        List<String> result = this.options();
        result.add(0, binary);
        return result;
    }

    @Override
    protected String description() {
        return "Non-interactive ssh password provider.\nSee man page:\nhttps://linux.die.net/man/1/sshpass";
    }

    @Override
    protected ArgumentParser getParser() {
        ArgumentParser parser = super.getParser();
        parser.addArgument(new String[]{"-p"}).dest("password").help("The password is given on the command line (least secure option).").setDefault((Object)"");
        parser.addArgument(new String[]{"-f"}).dest("filename").help("The password is the first line of the file filename.").setDefault((Object)"");
        parser.addArgument(new String[]{"-e"}).dest("fromEnvVar").help("The password is taken from the environment variable \"SSHPASS\".").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-v"}).dest("verbose").help("Be verbose. sshpass will output to stderr information that should help debug cases where the connection hangs, seemingly for no good reason.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        return parser;
    }

    @Override
    protected boolean setOptions(Namespace ns) {
        boolean result = super.setOptions(ns);
        if (!result) {
            return false;
        }
        this.password(ns.getString("password"));
        this.filename(ns.getString("filename"));
        this.fromEnvVar(ns.getBoolean("fromEnvVar"));
        this.verbose(ns.getBoolean("verbose"));
        return true;
    }

    public static void main(String[] args) throws Exception {
        SshPass.run(new SshPass(), args);
    }
}

