/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j;

import com.github.fracpete.rsync4j.SshPass;
import com.github.fracpete.rsync4j.core.AbstractBinaryWithTimeout;
import com.github.fracpete.rsync4j.core.Binaries;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.lang3.SystemUtils;

public class RSync
extends AbstractBinaryWithTimeout {
    protected List<String> sources;
    protected String destination;
    protected boolean verbose;
    protected String info;
    protected String debug;
    protected boolean msgs2stderr;
    protected boolean quiet;
    protected boolean no_motd;
    protected boolean checksum;
    protected boolean archive;
    protected boolean recursive;
    protected boolean relative;
    protected boolean no_implied_dirs;
    protected boolean backup;
    protected String backup_dir;
    protected String suffix;
    protected boolean update;
    protected boolean inplace;
    protected boolean append;
    protected boolean append_verify;
    protected boolean dirs;
    protected boolean links;
    protected boolean copy_links;
    protected boolean copy_unsafe_links;
    protected boolean safe_links;
    protected boolean munge_links;
    protected boolean copy_dirlinks;
    protected boolean keep_dirlinks;
    protected boolean hard_links;
    protected boolean perms;
    protected boolean executability;
    protected String chmod;
    protected boolean acls;
    protected boolean xattrs;
    protected boolean owner;
    protected boolean group;
    protected boolean devices;
    protected boolean specials;
    protected boolean times;
    protected boolean omit_dir_times;
    protected boolean omit_link_times;
    protected boolean super_;
    protected boolean fake_super;
    protected boolean sparse;
    protected boolean preallocate;
    protected boolean dry_run;
    protected boolean whole_file;
    protected boolean one_file_system;
    protected String block_size;
    protected String rsh;
    protected String rsync_path;
    protected boolean existing;
    protected boolean ignore_existing;
    protected boolean remove_source_files;
    protected boolean delete;
    protected boolean delete_before;
    protected boolean delete_during;
    protected boolean delete_delay;
    protected boolean delete_after;
    protected boolean delete_excluded;
    protected boolean ignore_missing_args;
    protected boolean delete_missing_args;
    protected boolean ignore_errors;
    protected boolean force;
    protected int max_delete;
    protected String max_size;
    protected String min_size;
    protected boolean partial;
    protected String partial_dir;
    protected boolean delay_updates;
    protected boolean prune_empty_dirs;
    protected boolean numeric_ids;
    protected String usermap;
    protected String groupmap;
    protected String chown;
    protected int timeout;
    protected int contimeout;
    protected boolean ignore_times;
    protected String remote_option;
    protected boolean size_only;
    protected int modify_window;
    protected String temp_dir;
    protected boolean fuzzy;
    protected String[] compare_dest;
    protected String[] copy_dest;
    protected String[] link_dest;
    protected boolean compress;
    protected int compress_level;
    protected String skip_compress;
    protected boolean cvs_exclude;
    protected List<String> include_exclude;
    protected String files_from;
    protected boolean from0;
    protected boolean protect_args;
    protected String address;
    protected int port;
    protected String sockopts;
    protected boolean blocking_io;
    protected boolean stats;
    protected boolean eight_bit_output;
    protected boolean human_readable;
    protected boolean progress;
    protected boolean itemize_changes;
    protected String out_format;
    protected String log_file;
    protected String log_file_format;
    protected String password_file;
    protected boolean list_only;
    protected String bwlimit;
    protected char outbuf;
    protected String write_batch;
    protected String only_write_batch;
    protected String read_batch;
    protected int protocol;
    protected String iconv;
    protected int checksum_seed;
    protected boolean ipv4;
    protected boolean ipv6;
    protected boolean version;
    protected boolean trust_sender;
    protected boolean fsync;
    protected boolean copy_devices;
    protected String stop_after;
    protected String stop_at;
    protected boolean crtimes;
    protected boolean mkpath;
    protected String max_alloc;
    protected String early_input;
    protected boolean atimes;
    protected boolean open_noatime;
    protected boolean write_devices;
    protected String copy_as;
    protected String checksum_choice;
    protected String[] additional;
    protected SshPass sshPass;

    @Override
    public void reset() {
        super.reset();
        this.sources = new ArrayList<String>();
        this.destination = null;
        this.verbose = false;
        this.info = "";
        this.debug = "";
        this.msgs2stderr = false;
        this.quiet = false;
        this.no_motd = false;
        this.checksum = false;
        this.archive = false;
        this.recursive = false;
        this.relative = false;
        this.no_implied_dirs = false;
        this.backup = false;
        this.backup_dir = "";
        this.suffix = "";
        this.update = false;
        this.inplace = false;
        this.append = false;
        this.append_verify = false;
        this.dirs = false;
        this.links = false;
        this.copy_links = false;
        this.copy_unsafe_links = false;
        this.safe_links = false;
        this.munge_links = false;
        this.copy_dirlinks = false;
        this.keep_dirlinks = false;
        this.hard_links = false;
        this.perms = false;
        this.executability = false;
        this.chmod = "";
        this.acls = false;
        this.xattrs = false;
        this.owner = false;
        this.group = false;
        this.devices = false;
        this.specials = false;
        this.times = false;
        this.omit_dir_times = false;
        this.omit_link_times = false;
        this.super_ = false;
        this.fake_super = false;
        this.sparse = false;
        this.preallocate = false;
        this.dry_run = false;
        this.whole_file = false;
        this.one_file_system = false;
        this.block_size = "";
        this.rsh = "";
        this.rsync_path = "";
        this.existing = false;
        this.ignore_existing = false;
        this.remove_source_files = false;
        this.delete = false;
        this.delete_before = false;
        this.delete_during = false;
        this.delete_delay = false;
        this.delete_after = false;
        this.delete_excluded = false;
        this.ignore_missing_args = false;
        this.delete_missing_args = false;
        this.ignore_errors = false;
        this.force = false;
        this.max_delete = -1;
        this.max_size = "";
        this.min_size = "";
        this.partial = false;
        this.partial_dir = "";
        this.delay_updates = false;
        this.prune_empty_dirs = false;
        this.numeric_ids = false;
        this.usermap = "";
        this.groupmap = "";
        this.chown = "";
        this.timeout = -1;
        this.contimeout = -1;
        this.ignore_times = false;
        this.remote_option = "";
        this.size_only = false;
        this.modify_window = -1;
        this.temp_dir = "";
        this.fuzzy = false;
        this.compare_dest = new String[0];
        this.copy_dest = new String[0];
        this.link_dest = new String[0];
        this.compress = false;
        this.compress_level = -1;
        this.skip_compress = "";
        this.cvs_exclude = false;
        this.include_exclude = new ArrayList<String>();
        this.files_from = "";
        this.from0 = false;
        this.protect_args = false;
        this.address = "";
        this.port = -1;
        this.sockopts = "";
        this.blocking_io = false;
        this.stats = false;
        this.eight_bit_output = false;
        this.human_readable = false;
        this.progress = false;
        this.itemize_changes = false;
        this.out_format = "";
        this.log_file = "";
        this.log_file_format = "";
        this.password_file = "";
        this.list_only = false;
        this.bwlimit = "";
        this.outbuf = '\u0000';
        this.write_batch = "";
        this.only_write_batch = "";
        this.read_batch = "";
        this.protocol = -1;
        this.iconv = "";
        this.checksum_seed = -1;
        this.ipv4 = false;
        this.ipv6 = false;
        this.version = false;
        this.trust_sender = false;
        this.fsync = false;
        this.copy_devices = false;
        this.stop_after = "";
        this.stop_at = "";
        this.crtimes = false;
        this.mkpath = false;
        this.max_alloc = "";
        this.early_input = "";
        this.atimes = false;
        this.open_noatime = false;
        this.write_devices = false;
        this.copy_as = "";
        this.checksum_choice = "";
        this.sshPass = null;
    }

    public RSync source(String value) {
        this.sources.clear();
        this.sources.add(Binaries.convertPath(value));
        return this;
    }

    public RSync sources(String[] value) {
        this.sources.clear();
        for (String s : value) {
            this.sources.add(Binaries.convertPath(s));
        }
        return this;
    }

    public RSync sources(List<String> value) {
        this.sources.clear();
        for (String s : value) {
            this.sources.add(Binaries.convertPath(s));
        }
        return this;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public RSync destination(String value) {
        this.destination = Binaries.convertPath(value);
        return this;
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    public RSync outputCommandline(boolean value) {
        return (RSync)super.outputCommandline(value);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public RSync verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public String getInfo() {
        return this.info;
    }

    public RSync info(String info) {
        this.info = info;
        return this;
    }

    public String getDebug() {
        return this.debug;
    }

    public RSync debug(String debug) {
        this.debug = debug;
        return this;
    }

    public boolean isMsgs2stderr() {
        return this.msgs2stderr;
    }

    public RSync msgs2stderr(boolean msgs2stderr) {
        this.msgs2stderr = msgs2stderr;
        return this;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public RSync quiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public boolean isNoMotd() {
        return this.no_motd;
    }

    public RSync noMotd(boolean no_motd) {
        this.no_motd = no_motd;
        return this;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public RSync checksum(boolean checksum) {
        this.checksum = checksum;
        return this;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public RSync archive(boolean archive) {
        this.archive = archive;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public RSync recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public RSync relative(boolean relative) {
        this.relative = relative;
        return this;
    }

    public boolean isNoImpliedDirs() {
        return this.no_implied_dirs;
    }

    public RSync noImpliedDirs(boolean no_implied_dirs) {
        this.no_implied_dirs = no_implied_dirs;
        return this;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public RSync backup(boolean backup) {
        this.backup = backup;
        return this;
    }

    public String getBackupDir() {
        return this.backup_dir;
    }

    public RSync backupDir(String backup_dir) {
        this.backup_dir = backup_dir;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public RSync suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public RSync update(boolean update) {
        this.update = update;
        return this;
    }

    public boolean isInplace() {
        return this.inplace;
    }

    public RSync inplace(boolean inplace) {
        this.inplace = inplace;
        return this;
    }

    public boolean isAppend() {
        return this.append;
    }

    public RSync append(boolean append) {
        this.append = append;
        return this;
    }

    public boolean isAppendVerify() {
        return this.append_verify;
    }

    public RSync appendVerify(boolean append_verify) {
        this.append_verify = append_verify;
        return this;
    }

    public boolean isDirs() {
        return this.dirs;
    }

    public RSync dirs(boolean dirs) {
        this.dirs = dirs;
        return this;
    }

    public boolean isLinks() {
        return this.links;
    }

    public RSync links(boolean links) {
        this.links = links;
        return this;
    }

    public boolean isCopyLinks() {
        return this.copy_links;
    }

    public RSync copyLinks(boolean copy_links) {
        this.copy_links = copy_links;
        return this;
    }

    public boolean isCopyUnsafeLinks() {
        return this.copy_unsafe_links;
    }

    public RSync copyUnsafeLinks(boolean copy_unsafe_links) {
        this.copy_unsafe_links = copy_unsafe_links;
        return this;
    }

    public boolean isSafeLinks() {
        return this.safe_links;
    }

    public RSync safeLinks(boolean safe_links) {
        this.safe_links = safe_links;
        return this;
    }

    public boolean isMungeLinks() {
        return this.munge_links;
    }

    public RSync mungeLinks(boolean munge_links) {
        this.munge_links = munge_links;
        return this;
    }

    public boolean isCopyDirlinks() {
        return this.copy_dirlinks;
    }

    public RSync copyDirlinks(boolean copy_dirlinks) {
        this.copy_dirlinks = copy_dirlinks;
        return this;
    }

    public boolean isKeepDirlinks() {
        return this.keep_dirlinks;
    }

    public RSync keepDirlinks(boolean keep_dirlinks) {
        this.keep_dirlinks = keep_dirlinks;
        return this;
    }

    public boolean isHardLinks() {
        return this.hard_links;
    }

    public RSync hardLinks(boolean hard_links) {
        this.hard_links = hard_links;
        return this;
    }

    public boolean isPerms() {
        return this.perms;
    }

    public RSync perms(boolean perms) {
        this.perms = perms;
        return this;
    }

    public boolean isExecutability() {
        return this.executability;
    }

    public RSync executability(boolean executability) {
        this.executability = executability;
        return this;
    }

    public String getChmod() {
        return this.chmod;
    }

    public RSync chmod(String chmod) {
        this.chmod = chmod;
        return this;
    }

    public boolean isAcls() {
        return this.acls;
    }

    public RSync acls(boolean acls) {
        this.acls = acls;
        return this;
    }

    public boolean isXattrs() {
        return this.xattrs;
    }

    public RSync xattrs(boolean xattrs) {
        this.xattrs = xattrs;
        return this;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public RSync owner(boolean owner) {
        this.owner = owner;
        return this;
    }

    public boolean isGroup() {
        return this.group;
    }

    public RSync group(boolean group) {
        this.group = group;
        return this;
    }

    public boolean isDevices() {
        return this.devices;
    }

    public RSync devices(boolean devices) {
        this.devices = devices;
        return this;
    }

    public boolean isSpecials() {
        return this.specials;
    }

    public RSync specials(boolean specials) {
        this.specials = specials;
        return this;
    }

    public boolean isTimes() {
        return this.times;
    }

    public RSync times(boolean times) {
        this.times = times;
        return this;
    }

    public boolean isOmitDirTimes() {
        return this.omit_dir_times;
    }

    public RSync omitDirTimes(boolean omit_dir_times) {
        this.omit_dir_times = omit_dir_times;
        return this;
    }

    public boolean isOmitLinkTimes() {
        return this.omit_link_times;
    }

    public RSync omitLinkTimes(boolean omit_link_times) {
        this.omit_link_times = omit_link_times;
        return this;
    }

    public boolean isSuper_() {
        return this.super_;
    }

    public RSync super_(boolean super_) {
        this.super_ = super_;
        return this;
    }

    public boolean isFakeSuper() {
        return this.fake_super;
    }

    public RSync fakeSuper(boolean fake_super) {
        this.fake_super = fake_super;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public RSync sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public boolean isPreallocate() {
        return this.preallocate;
    }

    public RSync preallocate(boolean preallocate) {
        this.preallocate = preallocate;
        return this;
    }

    public boolean isDryRun() {
        return this.dry_run;
    }

    public RSync dryRun(boolean dry_run) {
        this.dry_run = dry_run;
        return this;
    }

    public boolean isWholeFile() {
        return this.whole_file;
    }

    public RSync wholeFile(boolean whole_file) {
        this.whole_file = whole_file;
        return this;
    }

    public boolean isOneFileSystem() {
        return this.one_file_system;
    }

    public RSync oneFileSystem(boolean one_file_system) {
        this.one_file_system = one_file_system;
        return this;
    }

    public String getBlockSize() {
        return this.block_size;
    }

    public RSync blockSize(String block_size) {
        this.block_size = block_size;
        return this;
    }

    public String getRsh() {
        return this.rsh;
    }

    public RSync rsh(String rsh) {
        this.rsh = rsh;
        return this;
    }

    public String getRsyncPath() {
        return this.rsync_path;
    }

    public RSync rsyncPath(String rsync_path) {
        this.rsync_path = rsync_path;
        return this;
    }

    public boolean isExisting() {
        return this.existing;
    }

    public RSync existing(boolean existing) {
        this.existing = existing;
        return this;
    }

    public boolean isIgnoreExisting() {
        return this.ignore_existing;
    }

    public RSync ignoreExisting(boolean ignore_existing) {
        this.ignore_existing = ignore_existing;
        return this;
    }

    public boolean isRemoveSourceFiles() {
        return this.remove_source_files;
    }

    public RSync removeSourceFiles(boolean remove_source_files) {
        this.remove_source_files = remove_source_files;
        return this;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public RSync delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public boolean isDeleteBefore() {
        return this.delete_before;
    }

    public RSync deleteBefore(boolean delete_before) {
        this.delete_before = delete_before;
        return this;
    }

    public boolean isDeleteDuring() {
        return this.delete_during;
    }

    public RSync deleteDuring(boolean delete_during) {
        this.delete_during = delete_during;
        return this;
    }

    public boolean isDeleteDelay() {
        return this.delete_delay;
    }

    public RSync deleteDelay(boolean delete_delay) {
        this.delete_delay = delete_delay;
        return this;
    }

    public boolean isDeleteAfter() {
        return this.delete_after;
    }

    public RSync deleteAfter(boolean delete_after) {
        this.delete_after = delete_after;
        return this;
    }

    public boolean isDeleteExcluded() {
        return this.delete_excluded;
    }

    public RSync deleteExcluded(boolean delete_excluded) {
        this.delete_excluded = delete_excluded;
        return this;
    }

    public boolean isIgnoreMissingArgs() {
        return this.ignore_missing_args;
    }

    public RSync ignoreMissingArgs(boolean ignore_missing_args) {
        this.ignore_missing_args = ignore_missing_args;
        return this;
    }

    public boolean isDeleteMissingArgs() {
        return this.delete_missing_args;
    }

    public RSync deleteMissingArgs(boolean delete_missing_args) {
        this.delete_missing_args = delete_missing_args;
        return this;
    }

    public boolean isIgnoreErrors() {
        return this.ignore_errors;
    }

    public RSync ignoreErrors(boolean ignore_errors) {
        this.ignore_errors = ignore_errors;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public RSync force(boolean force) {
        this.force = force;
        return this;
    }

    public int getMaxDelete() {
        return this.max_delete;
    }

    public RSync maxDelete(int max_delete) {
        this.max_delete = max_delete;
        return this;
    }

    public String getMaxSize() {
        return this.max_size;
    }

    public RSync maxSize(String max_size) {
        this.max_size = max_size;
        return this;
    }

    public String getMinSize() {
        return this.min_size;
    }

    public RSync minSize(String min_size) {
        this.min_size = min_size;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public RSync partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public String getPartialDir() {
        return this.partial_dir;
    }

    public RSync partialDir(String partial_dir) {
        this.partial_dir = partial_dir;
        return this;
    }

    public boolean isDelayUpdates() {
        return this.delay_updates;
    }

    public RSync delayUpdates(boolean delay_updates) {
        this.delay_updates = delay_updates;
        return this;
    }

    public boolean isPruneEmptyDirs() {
        return this.prune_empty_dirs;
    }

    public RSync pruneEmptyDirs(boolean prune_empty_dirs) {
        this.prune_empty_dirs = prune_empty_dirs;
        return this;
    }

    public boolean isNumericIds() {
        return this.numeric_ids;
    }

    public RSync numericIds(boolean numeric_ids) {
        this.numeric_ids = numeric_ids;
        return this;
    }

    public String getUsermap() {
        return this.usermap;
    }

    public RSync usermap(String usermap) {
        this.usermap = usermap;
        return this;
    }

    public String getGroupmap() {
        return this.groupmap;
    }

    public RSync groupmap(String groupmap) {
        this.groupmap = groupmap;
        return this;
    }

    public String getChown() {
        return this.chown;
    }

    public RSync chown(String chown) {
        this.chown = chown;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public RSync timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getContimeout() {
        return this.contimeout;
    }

    public RSync contimeout(int contimeout) {
        this.contimeout = contimeout;
        return this;
    }

    public boolean isIgnoreTimes() {
        return this.ignore_times;
    }

    public RSync ignoreTimes(boolean ignore_times) {
        this.ignore_times = ignore_times;
        return this;
    }

    public String getRemoteOption() {
        return this.remote_option;
    }

    public RSync remoteOption(String remote_option) {
        this.remote_option = remote_option;
        return this;
    }

    public boolean isSizeOnly() {
        return this.size_only;
    }

    public RSync sizeOnly(boolean size_only) {
        this.size_only = size_only;
        return this;
    }

    public int getModifyWindow() {
        return this.modify_window;
    }

    public RSync modifyWindow(int modify_window) {
        this.modify_window = modify_window;
        return this;
    }

    public String getTempDir() {
        return this.temp_dir;
    }

    public RSync tempDir(String temp_dir) {
        this.temp_dir = temp_dir;
        return this;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public RSync fuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
        return this;
    }

    public String[] getCompareDest() {
        return this.compare_dest;
    }

    public RSync compareDest(String ... compare_dest) {
        this.compare_dest = (String[])compare_dest.clone();
        return this;
    }

    public String[] getCopyDest() {
        return this.copy_dest;
    }

    public RSync copyDest(String ... copy_dest) {
        this.copy_dest = (String[])copy_dest.clone();
        return this;
    }

    public String[] getLinkDest() {
        return this.link_dest;
    }

    public RSync linkDest(String ... link_dest) {
        this.link_dest = (String[])link_dest.clone();
        return this;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public RSync compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    public int getCompressLevel() {
        return this.compress_level;
    }

    public RSync compressLevel(int compress_level) {
        this.compress_level = compress_level;
        return this;
    }

    public String getSkipCompress() {
        return this.skip_compress;
    }

    public RSync skipCompress(String skip_compress) {
        this.skip_compress = skip_compress;
        return this;
    }

    public boolean isCvsExclude() {
        return this.cvs_exclude;
    }

    public RSync cvsExclude(boolean cvs_exclude) {
        this.cvs_exclude = cvs_exclude;
        return this;
    }

    public String[] getFilter() {
        return this.includeExcludeSubset("F");
    }

    public RSync filter(String ... filter) {
        return this.addIncludeExclude("F", filter);
    }

    protected String[] includeExcludeSubset(String id) {
        ArrayList<String> result = new ArrayList<String>();
        id = id + "\t";
        for (String ie : this.include_exclude) {
            if (!ie.startsWith(id)) continue;
            result.add(ie.substring(id.length()));
        }
        return result.toArray(new String[0]);
    }

    protected RSync addIncludeExclude(String id, String ... list) {
        for (String l : list) {
            this.include_exclude.add(id + "\t" + l);
        }
        return this;
    }

    protected String[] getIncludeExclude() {
        return this.include_exclude.toArray(new String[0]);
    }

    public String[] getExclude() {
        return this.includeExcludeSubset("E");
    }

    public RSync exclude(String ... exclude) {
        return this.addIncludeExclude("E", exclude);
    }

    public String[] getExcludeFrom() {
        return this.includeExcludeSubset("EF");
    }

    public RSync excludeFrom(String ... exclude_from) {
        for (int i = 0; i < exclude_from.length; ++i) {
            exclude_from[i] = Binaries.convertPath(exclude_from[i]);
        }
        return this.addIncludeExclude("EF", exclude_from);
    }

    public String[] getInclude() {
        return this.includeExcludeSubset("I");
    }

    public RSync include(String ... include) {
        return this.addIncludeExclude("I", include);
    }

    public String[] getIncludeFrom() {
        return this.includeExcludeSubset("IF");
    }

    public RSync includeFrom(String ... include_from) {
        for (int i = 0; i < include_from.length; ++i) {
            include_from[i] = Binaries.convertPath(include_from[i]);
        }
        return this.addIncludeExclude("IF", include_from);
    }

    public String getFilesFrom() {
        return this.files_from;
    }

    public RSync filesFrom(String files_from) {
        this.files_from = Binaries.convertPath(files_from);
        return this;
    }

    public boolean isFrom0() {
        return this.from0;
    }

    public RSync from0(boolean from0) {
        this.from0 = from0;
        return this;
    }

    public boolean isProtectArgs() {
        return this.protect_args;
    }

    public RSync protectArgs(boolean protect_args) {
        this.protect_args = protect_args;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public RSync address(String address) {
        this.address = address;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public RSync port(int port) {
        this.port = port;
        return this;
    }

    public String getSockopts() {
        return this.sockopts;
    }

    public RSync sockopts(String sockopts) {
        this.sockopts = sockopts;
        return this;
    }

    public boolean isBlockingIO() {
        return this.blocking_io;
    }

    public RSync blockingIO(boolean blocking_io) {
        this.blocking_io = blocking_io;
        return this;
    }

    public boolean isStats() {
        return this.stats;
    }

    public RSync stats(boolean stats) {
        this.stats = stats;
        return this;
    }

    public boolean isEightBitOutput() {
        return this.eight_bit_output;
    }

    public RSync eightBitOutput(boolean eight_bit_output) {
        this.eight_bit_output = eight_bit_output;
        return this;
    }

    public boolean isHumanReadable() {
        return this.human_readable;
    }

    public RSync humanReadable(boolean human_readable) {
        this.human_readable = human_readable;
        return this;
    }

    public boolean isProgress() {
        return this.progress;
    }

    public RSync progress(boolean progress) {
        this.progress = progress;
        return this;
    }

    public boolean isItemizeChanges() {
        return this.itemize_changes;
    }

    public RSync itemizeChanges(boolean itemize_changes) {
        this.itemize_changes = itemize_changes;
        return this;
    }

    public String getOutFormat() {
        return this.out_format;
    }

    public RSync outFormat(String out_format) {
        this.out_format = out_format;
        return this;
    }

    public String getLogFile() {
        return this.log_file;
    }

    public RSync logFile(String log_file) {
        this.log_file = Binaries.convertPath(log_file);
        return this;
    }

    public String getLogFileFormat() {
        return this.log_file_format;
    }

    public RSync logFileFormat(String log_file_format) {
        this.log_file_format = log_file_format;
        return this;
    }

    public String getPasswordFile() {
        return this.password_file;
    }

    public RSync passwordFile(String password_file) {
        this.password_file = Binaries.convertPath(password_file);
        return this;
    }

    public boolean isListOnly() {
        return this.list_only;
    }

    public RSync listOnly(boolean list_only) {
        this.list_only = list_only;
        return this;
    }

    public String getBwlimit() {
        return this.bwlimit;
    }

    public RSync bwlimit(String bwlimit) {
        this.bwlimit = bwlimit;
        return this;
    }

    public char getOutbuf() {
        return this.outbuf;
    }

    public RSync outbuf(char outbuf) {
        this.outbuf = outbuf;
        return this;
    }

    public String getWriteBatch() {
        return this.write_batch;
    }

    public RSync writeBatch(String write_batch) {
        this.write_batch = Binaries.convertPath(write_batch);
        return this;
    }

    public String getOnlyWriteBatch() {
        return this.only_write_batch;
    }

    public RSync onlyWriteBatch(String only_write_batch) {
        this.only_write_batch = Binaries.convertPath(only_write_batch);
        return this;
    }

    public String getReadBatch() {
        return this.read_batch;
    }

    public RSync readBatch(String read_batch) {
        this.read_batch = Binaries.convertPath(read_batch);
        return this;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public RSync protocol(int protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getIconv() {
        return this.iconv;
    }

    public RSync iconv(String iconv) {
        this.iconv = iconv;
        return this;
    }

    public int getChecksumSeed() {
        return this.checksum_seed;
    }

    public RSync checksumSeed(int checksum_seed) {
        this.checksum_seed = checksum_seed;
        return this;
    }

    public boolean isIpv4() {
        return this.ipv4;
    }

    public RSync ipv4(boolean ipv4) {
        this.ipv4 = ipv4;
        return this;
    }

    public boolean isIpv6() {
        return this.ipv6;
    }

    public RSync ipv6(boolean ipv6) {
        this.ipv6 = ipv6;
        return this;
    }

    public boolean isVersion() {
        return this.version;
    }

    public RSync version(boolean version) {
        this.version = version;
        return this;
    }

    public boolean isTrustSender() {
        return this.trust_sender;
    }

    public RSync trustSender(boolean trust_sender) {
        this.trust_sender = trust_sender;
        return this;
    }

    public boolean isFsync() {
        return this.fsync;
    }

    public RSync fsync(boolean fsync) {
        this.fsync = fsync;
        return this;
    }

    public boolean isCopyDevices() {
        return this.copy_devices;
    }

    public RSync copyDevices(boolean copy_devices) {
        this.copy_devices = copy_devices;
        return this;
    }

    public String getStopAfter() {
        return this.stop_after;
    }

    public RSync stopAfter(String stop_after) {
        this.stop_after = stop_after;
        return this;
    }

    public String getStopAt() {
        return this.stop_at;
    }

    public RSync stopAt(String stop_at) {
        this.stop_at = stop_at;
        return this;
    }

    public boolean isCrtimes() {
        return this.crtimes;
    }

    public RSync crtimes(boolean crtimes) {
        this.crtimes = crtimes;
        return this;
    }

    public boolean isMkpath() {
        return this.mkpath;
    }

    public RSync mkpath(boolean mkpath) {
        this.mkpath = mkpath;
        return this;
    }

    public String getMaxAlloc() {
        return this.max_alloc;
    }

    public RSync maxAlloc(String max_alloc) {
        this.max_alloc = max_alloc;
        return this;
    }

    public String getEarlyInput() {
        return this.early_input;
    }

    public RSync earlyInput(String early_input) {
        this.early_input = early_input;
        return this;
    }

    public boolean isAtimes() {
        return this.atimes;
    }

    public RSync atimes(boolean atimes) {
        this.atimes = atimes;
        return this;
    }

    public boolean isOpenNoatime() {
        return this.open_noatime;
    }

    public RSync openNoatime(boolean open_noatime) {
        this.open_noatime = open_noatime;
        return this;
    }

    public boolean isWriteDevices() {
        return this.write_devices;
    }

    public RSync writeDevices(boolean write_devices) {
        this.write_devices = write_devices;
        return this;
    }

    public String getCopyAs() {
        return this.copy_as;
    }

    public RSync copyAs(String copy_as) {
        this.copy_as = copy_as;
        return this;
    }

    public String getChecksumChoice() {
        return this.checksum_choice;
    }

    public RSync checksumChoice(String checksum_choice) {
        this.checksum_choice = checksum_choice;
        return this;
    }

    public String[] getAdditional() {
        return this.additional;
    }

    public RSync additional(String ... additional) {
        this.additional = (String[])additional.clone();
        for (int i = 0; i < this.additional.length; ++i) {
            this.additional[i] = this.additional[i].replaceFirst("^[+][+]", "--").replaceFirst("^[+]", "-");
        }
        return this;
    }

    public RSync sshPass(SshPass value) {
        this.sshPass = value;
        return this;
    }

    public SshPass getSshPass() {
        return this.sshPass;
    }

    @Override
    public List<String> options() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isVerbose()) {
            result.add("--verbose");
        }
        if (!this.getInfo().isEmpty()) {
            result.add("--info=" + this.getInfo());
        }
        if (!this.getDebug().isEmpty()) {
            result.add("--debug=" + this.getDebug());
        }
        if (this.isMsgs2stderr()) {
            result.add("--msgs2stderr");
        }
        if (this.isQuiet()) {
            result.add("--quiet");
        }
        if (this.isNoMotd()) {
            result.add("--no-motd");
        }
        if (this.isChecksum()) {
            result.add("--checksum");
        }
        if (this.isArchive()) {
            result.add("--archive");
        }
        if (this.isRecursive()) {
            result.add("--recursive");
        }
        if (this.isRelative()) {
            result.add("--relative");
        }
        if (this.isNoImpliedDirs()) {
            result.add("--no-implied-dirs");
        }
        if (this.isBackup()) {
            result.add("--backup");
        }
        if (!this.getBackupDir().isEmpty()) {
            result.add("--backup-dir=" + this.getBackupDir());
        }
        if (!this.getSuffix().isEmpty()) {
            result.add("--suffix=" + this.getSuffix());
        }
        if (this.isUpdate()) {
            result.add("--update");
        }
        if (this.isInplace()) {
            result.add("--inplace");
        }
        if (this.isAppend()) {
            result.add("--append");
        }
        if (this.isAppendVerify()) {
            result.add("--append-verify");
        }
        if (this.isDirs()) {
            result.add("--dirs");
        }
        if (this.isLinks()) {
            result.add("--links");
        }
        if (this.isCopyLinks()) {
            result.add("--copy-links");
        }
        if (this.isCopyUnsafeLinks()) {
            result.add("--copy-unsafe-links");
        }
        if (this.isSafeLinks()) {
            result.add("--safe-links");
        }
        if (this.isMungeLinks()) {
            result.add("--munge-links");
        }
        if (this.isCopyDirlinks()) {
            result.add("--copy-dirlinks");
        }
        if (this.isKeepDirlinks()) {
            result.add("--keep-dirlinks");
        }
        if (this.isHardLinks()) {
            result.add("--hard-links");
        }
        if (this.isPerms()) {
            result.add("--perms");
        }
        if (this.isExecutability()) {
            result.add("--executability");
        }
        if (!this.getChmod().isEmpty()) {
            result.add("--chmod=" + this.getChmod());
        }
        if (this.isAcls()) {
            result.add("--acls");
        }
        if (this.isXattrs()) {
            result.add("--xattrs");
        }
        if (this.isOwner()) {
            result.add("--owner");
        }
        if (this.isGroup()) {
            result.add("--group");
        }
        if (this.isDevices()) {
            result.add("--devices");
        }
        if (this.isSpecials()) {
            result.add("--specials");
        }
        if (this.isTimes()) {
            result.add("--times");
        }
        if (this.isOmitDirTimes()) {
            result.add("--omit-dir-times");
        }
        if (this.isOmitLinkTimes()) {
            result.add("--omit-link-times");
        }
        if (this.isSuper_()) {
            result.add("--super");
        }
        if (this.isFakeSuper()) {
            result.add("--fake-super");
        }
        if (this.isSparse()) {
            result.add("--sparse");
        }
        if (this.isPreallocate()) {
            result.add("--preallocate");
        }
        if (this.isDryRun()) {
            result.add("--dry-run");
        }
        if (this.isWholeFile()) {
            result.add("--whole-file");
        }
        if (this.isOneFileSystem()) {
            result.add("--one-file-system");
        }
        if (!this.getBlockSize().isEmpty()) {
            result.add("--block-size=" + this.getBlockSize());
        }
        if (!this.getRsh().isEmpty()) {
            result.add("--rsh");
            if (SystemUtils.IS_OS_WINDOWS) {
                if (this.getRsh().equalsIgnoreCase("ssh")) {
                    result.add(Binaries.sshBinary());
                } else {
                    result.add(this.getRsh());
                }
            } else {
                result.add(this.getRsh());
            }
        }
        if (!this.getRsyncPath().isEmpty()) {
            result.add("--rsync-path=" + this.getRsyncPath());
        }
        if (this.isExisting()) {
            result.add("--existing");
        }
        if (this.isIgnoreExisting()) {
            result.add("--ignore-existing");
        }
        if (this.isRemoveSourceFiles()) {
            result.add("--remove-source-files");
        }
        if (this.isDelete()) {
            result.add("--delete");
        }
        if (this.isDeleteBefore()) {
            result.add("--delete-before");
        }
        if (this.isDeleteDuring()) {
            result.add("--delete-during");
        }
        if (this.isDeleteDelay()) {
            result.add("--delete-delay");
        }
        if (this.isDeleteAfter()) {
            result.add("--delete-after");
        }
        if (this.isDeleteExcluded()) {
            result.add("--delete-excluded");
        }
        if (this.isIgnoreMissingArgs()) {
            result.add("--ignore-missing-args");
        }
        if (this.isDeleteMissingArgs()) {
            result.add("--delete-missing-args");
        }
        if (this.isIgnoreErrors()) {
            result.add("--ignore-errors");
        }
        if (this.isForce()) {
            result.add("--force");
        }
        if (this.getMaxDelete() > -1) {
            result.add("--max-delete=" + this.getMaxDelete());
        }
        if (!this.getMaxSize().isEmpty()) {
            result.add("--max-size=" + this.getMaxSize());
        }
        if (!this.getMinSize().isEmpty()) {
            result.add("--min-size=" + this.getMinSize());
        }
        if (this.isPartial()) {
            result.add("--partial");
        }
        if (!this.getPartialDir().isEmpty()) {
            result.add("--partial-dir=" + this.getPartialDir());
        }
        if (this.isDelayUpdates()) {
            result.add("--delay-updates");
        }
        if (this.isPruneEmptyDirs()) {
            result.add("--prune-empty-dirs");
        }
        if (this.isNumericIds()) {
            result.add("--numeric-ids");
        }
        if (!this.getUsermap().isEmpty()) {
            result.add("--usermap=" + this.getUsermap());
        }
        if (!this.getGroupmap().isEmpty()) {
            result.add("--groupmap=" + this.getGroupmap());
        }
        if (!this.getChown().isEmpty()) {
            result.add("--chown=" + this.getChown());
        }
        if (this.getTimeout() > -1) {
            result.add("--timeout=" + this.getTimeout());
        }
        if (this.getContimeout() > -1) {
            result.add("--contimeout=" + this.getContimeout());
        }
        if (this.isIgnoreTimes()) {
            result.add("--ignore-times");
        }
        if (!this.getRemoteOption().isEmpty()) {
            result.add("--remote-option=" + this.getRemoteOption());
        }
        if (this.isSizeOnly()) {
            result.add("--size-only");
        }
        if (this.getModifyWindow() > -1) {
            result.add("--modify-window=" + this.getModifyWindow());
        }
        if (!this.getTempDir().isEmpty()) {
            result.add("--temp-dir=" + this.getTempDir());
        }
        if (this.isFuzzy()) {
            result.add("--fuzzy");
        }
        for (String compareDest : this.getCompareDest()) {
            result.add("--compare-dest=" + compareDest);
        }
        for (String copyDest : this.getCopyDest()) {
            result.add("--copy-dest=" + copyDest);
        }
        for (String linkDest : this.getLinkDest()) {
            result.add("--link-dest=" + linkDest);
        }
        if (this.isCompress()) {
            result.add("--compress");
        }
        if (this.getCompressLevel() > -1) {
            result.add("--compress-level=" + this.getCompressLevel());
        }
        if (!this.getSkipCompress().isEmpty()) {
            result.add("--skip-compress=" + this.getSkipCompress());
        }
        if (this.isCvsExclude()) {
            result.add("--cvs-exclude");
        }
        block17: for (String ie : this.getIncludeExclude()) {
            String id = ie.substring(0, ie.indexOf(9));
            String s = ie.substring(ie.indexOf(9) + 1);
            switch (id) {
                case "E": {
                    result.add("--exclude=" + s);
                    continue block17;
                }
                case "EF": {
                    result.add("--exclude-from=" + s);
                    continue block17;
                }
                case "I": {
                    result.add("--include=" + s);
                    continue block17;
                }
                case "IF": {
                    result.add("--include-from=" + s);
                    continue block17;
                }
                case "F": {
                    result.add("--filter=" + s);
                    continue block17;
                }
                default: {
                    throw new IllegalStateException("Unhandled ID for include/exclude/include-from/exclude-from/filter list: " + id);
                }
            }
        }
        if (!this.getFilesFrom().isEmpty()) {
            result.add("--files-from=" + this.getFilesFrom());
        }
        if (this.isFrom0()) {
            result.add("--from0");
        }
        if (this.isProtectArgs()) {
            result.add("--protect-args");
        }
        if (!this.getAddress().isEmpty()) {
            result.add("--address=" + this.getAddress());
        }
        if (this.getPort() > -1) {
            result.add("--port=" + this.getPort());
        }
        if (!this.getSockopts().isEmpty()) {
            result.add("--sockopts=" + this.getSockopts());
        }
        if (this.isBlockingIO()) {
            result.add("--blocking-io");
        }
        if (this.isStats()) {
            result.add("--stats");
        }
        if (this.isEightBitOutput()) {
            result.add("--8-bit-output");
        }
        if (this.isHumanReadable()) {
            result.add("--human-readable");
        }
        if (this.isProgress()) {
            result.add("--progress");
        }
        if (this.isItemizeChanges()) {
            result.add("--itemize-changes");
        }
        if (!this.getOutFormat().isEmpty()) {
            result.add("--out-format=" + this.getOutFormat());
        }
        if (!this.getLogFile().isEmpty()) {
            result.add("--log-file=" + this.getLogFile());
        }
        if (!this.getLogFileFormat().isEmpty()) {
            result.add("--log-file-format=" + this.getLogFileFormat());
        }
        if (!this.getPasswordFile().isEmpty()) {
            result.add("--password-file=" + this.getPasswordFile());
        }
        if (this.isListOnly()) {
            result.add("--list-only");
        }
        if (!this.getBwlimit().isEmpty()) {
            result.add("--bwlimit=" + this.getBwlimit());
        }
        if (this.getOutbuf() != '\u0000') {
            result.add("--outbuf=" + this.getOutbuf());
        }
        if (!this.getWriteBatch().isEmpty()) {
            result.add("--write-batch=" + this.getWriteBatch());
        }
        if (!this.getOnlyWriteBatch().isEmpty()) {
            result.add("--only-write-batch=" + this.getOnlyWriteBatch());
        }
        if (!this.getReadBatch().isEmpty()) {
            result.add("--read-batch=" + this.getReadBatch());
        }
        if (this.getProtocol() > -1) {
            result.add("--protocol=" + this.getProtocol());
        }
        if (!this.getIconv().isEmpty()) {
            result.add("--iconv=" + this.getIconv());
        }
        if (this.getChecksumSeed() > -1) {
            result.add("--checksum-seed=" + this.getChecksumSeed());
        }
        if (this.isIpv4()) {
            result.add("--ipv4");
        }
        if (this.isIpv6()) {
            result.add("--ipv6");
        }
        if (this.isVersion()) {
            result.add("--version");
        }
        if (this.isTrustSender()) {
            result.add("--trust-sender");
        }
        if (this.isFsync()) {
            result.add("--fsync");
        }
        if (this.isCopyDevices()) {
            result.add("--copy-devices");
        }
        if (!this.getStopAfter().isEmpty()) {
            result.add("--stop-after=" + this.getStopAfter());
        }
        if (!this.getStopAt().isEmpty()) {
            result.add("--stop-at=" + this.getStopAt());
        }
        if (this.isCrtimes()) {
            result.add("--crtimes");
        }
        if (this.isMkpath()) {
            result.add("--mkpath");
        }
        if (!this.getMaxAlloc().isEmpty()) {
            result.add("--max-alloc=" + this.getMaxAlloc());
        }
        if (!this.getEarlyInput().isEmpty()) {
            result.add("--early-input=" + this.getEarlyInput());
        }
        if (this.isAtimes()) {
            result.add("--atimes");
        }
        if (this.isOpenNoatime()) {
            result.add("--open-noatime");
        }
        if (this.isWriteDevices()) {
            result.add("--write-devices");
        }
        if (!this.getCopyAs().isEmpty()) {
            result.add("--copy-as=" + this.getCopyAs());
        }
        if (!this.getChecksumChoice().isEmpty()) {
            result.add("--checksum-choice=" + this.getChecksumChoice());
        }
        if (this.additional != null) {
            for (String a : this.additional) {
                if (a == null || a.isEmpty()) continue;
                result.add(a);
            }
        }
        return result;
    }

    @Override
    public List<String> commandLineArgs() throws Exception {
        String binary = Binaries.rsyncBinary();
        List<String> result = this.options();
        result.add(0, binary);
        if (this.getSources().isEmpty()) {
            throw new IllegalStateException("No source(s) defined!");
        }
        result.addAll(this.getSources());
        if (this.getDestination() == null && !this.isListOnly()) {
            throw new IllegalStateException("No destination defined!");
        }
        if (this.getDestination() != null) {
            result.add(this.getDestination());
        }
        if (this.getSshPass() != null) {
            List<String> sshPassArgs = this.getSshPass().commandLineArgs();
            for (int i = sshPassArgs.size() - 1; i >= 0; --i) {
                result.add(0, sshPassArgs.get(i));
            }
        }
        return result;
    }

    @Override
    protected String description() {
        return "A fast, versatile, remote (and local) file-copying tool.\nSee man page:\nhttps://linux.die.net/man/1/rsync";
    }

    @Override
    protected ArgumentParser getParser() {
        ArgumentParser parser = super.getParser();
        parser.addArgument(new String[]{"-v", "--verbose"}).dest("verbose").help("increase verbosity").setDefault((Object)false).action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--info"}).setDefault((Object)"").help("fine-grained informational verbosity");
        parser.addArgument(new String[]{"--debug"}).setDefault((Object)"").help("fine-grained debug verbosity");
        parser.addArgument(new String[]{"--msgs2stderr"}).setDefault((Object)false).dest("msgs2stderr").help("special output handling for debugging").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-q", "--quiet"}).setDefault((Object)false).dest("quiet").help("suppress non-error messages").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--no-motd"}).setDefault((Object)false).dest("nomotd").help("suppress daemon-mode MOTD").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-c", "--checksum"}).setDefault((Object)false).dest("checksum").help("skip based on checksum, not mod-time & size").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-a", "--archive"}).setDefault((Object)false).dest("archive").help("archive mode; equals -rlptgoD (no -H,-A,-X)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-r", "--recursive"}).setDefault((Object)false).dest("recursive").help("recurse into directories").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-R", "--relative"}).setDefault((Object)false).dest("relative").help("use relative path names").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--no-implied-dirs"}).setDefault((Object)false).dest("noimplieddirs").help("use relative path names").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-b", "--backup"}).setDefault((Object)false).dest("backup").help("make backups (see --suffix & --backup-dir)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--backup-dir"}).setDefault((Object)"").dest("backupdir").help("make backups into hierarchy based in DIR");
        parser.addArgument(new String[]{"--suffix"}).setDefault((Object)"").dest("suffix").help("set backup suffix (default ~ w/o --backup-dir)");
        parser.addArgument(new String[]{"-u", "--update"}).setDefault((Object)false).dest("update").help("skip files that are newer on the receiver").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--inplace"}).setDefault((Object)false).dest("inplace").help("update destination files in-place").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--append"}).setDefault((Object)false).dest("append").help("append data onto shorter files").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--append-verify"}).setDefault((Object)false).dest("appendverify").help("like --append, but with old data in file checksum").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-d", "--dirs"}).setDefault((Object)false).dest("dirs").help("transfer directories without recursing").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-l", "--links"}).setDefault((Object)false).dest("links").help("copy symlinks as symlinks").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-L", "--copy-links"}).setDefault((Object)false).dest("copylinks").help("transform symlink into referent file/dir").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--copy-unsafe-links"}).setDefault((Object)false).dest("copyunsafelinks").help("only \"unsafe\" symlinks are transformed").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--safe-links"}).setDefault((Object)false).dest("safelinks").help("ignore symlinks that point outside the source tree").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--munge-links"}).setDefault((Object)false).dest("mungelinks").help("munge symlinks to make them safer (but unusable)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-k", "--copy-dirlinks"}).setDefault((Object)false).dest("copydirlinks").help("transform symlink to a dir into referent dir").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-K", "--keep-dirlinks"}).setDefault((Object)false).dest("keepdirlinks").help("treat symlinked dir on receiver as dir").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-H", "--hard-links"}).setDefault((Object)false).dest("hardlinks").help("preserve hard links").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-p", "--perms"}).setDefault((Object)false).dest("perms").help("preserve permissions").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-E", "--executability"}).setDefault((Object)false).dest("executability").help("preserve the file's executability").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--chmod"}).setDefault((Object)"").dest("chmod").help("affect file and/or directory permissions");
        parser.addArgument(new String[]{"-X", "--xattrs"}).setDefault((Object)false).dest("xattrs").help("preserve extended attributes").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-o", "--owner"}).setDefault((Object)false).dest("owner").help("preserve owner (super-user only)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-g", "--group"}).setDefault((Object)false).dest("group").help("preserve group").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--devices"}).setDefault((Object)false).dest("devices").help("preserve device files (super-user only)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--specials"}).setDefault((Object)false).dest("specials").help("preserve special files").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-t", "--times"}).setDefault((Object)false).dest("times").help("preserve modification times").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-O", "--omit-dir-times"}).setDefault((Object)false).dest("omitdirtimes").help("omit directories from --times").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-J", "--omit-link-times"}).setDefault((Object)false).dest("omitlinktimes").help("omit symlinks from --times").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--super"}).setDefault((Object)false).dest("super_").help("receiver attempts super-user activities").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--fake-super"}).setDefault((Object)false).dest("fakesuper").help("store/recover privileged attrs using xattrs").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-S", "--sparse"}).setDefault((Object)false).dest("sparse").help("handle sparse files efficiently").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--preallocate"}).setDefault((Object)false).dest("preallocate").help("allocate dest files before writing them").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-n", "--dry-run"}).setDefault((Object)false).dest("dryrun").help("perform a trial run with no changes made").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-W", "--whole-file"}).setDefault((Object)false).dest("wholefile").help("copy files whole (without delta-xfer algorithm)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-x", "--one-file-system"}).setDefault((Object)false).dest("onefilesystem").help("don't cross filesystem boundaries").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-B", "--block-size"}).setDefault((Object)"").dest("blocksize").help("force a fixed checksum block-size");
        parser.addArgument(new String[]{"-e", "--rsh"}).setDefault((Object)"").dest("rsh").help("specify the remote shell to use.\nOn Windows, use 'ssh' to use built-in ssh binary; otherwise use absolute path, eg 'C:\\somewhere\\ssh' or '/usr/bin/ssh'.\nUses plain protocol if left empty.");
        parser.addArgument(new String[]{"--rsync-path"}).setDefault((Object)"").dest("rsyncpath").help("specify the rsync to run on the remote machine");
        parser.addArgument(new String[]{"--existing"}).setDefault((Object)false).dest("existing").help("skip creating new files on receiver").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--ignore-existing"}).setDefault((Object)false).dest("ignoreexisting").help("skip updating files that already exist on receiver").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--remove-source-files"}).setDefault((Object)false).dest("removesourcefiles").help("sender removes synchronized files (non-dirs)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete"}).setDefault((Object)false).dest("delete").help("delete extraneous files from destination dirs").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete-before"}).setDefault((Object)false).dest("deletebefore").help("receiver deletes before transfer, not during").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete-during"}).setDefault((Object)false).dest("deleteduring").help("receiver deletes during the transfer").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete-delay"}).setDefault((Object)false).dest("deletedelay").help("find deletions during, delete after").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete-after"}).setDefault((Object)false).dest("deleteafter").help("receiver deletes after transfer, not during").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete-excluded"}).setDefault((Object)false).dest("deleteexcluded").help("also delete excluded files from destination dirs").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--ignore-missing-args"}).setDefault((Object)false).dest("ignoremissingargs").help("ignore missing source args without error").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--delete-missing-args"}).setDefault((Object)false).dest("deletemissingargs").help("delete missing source args from destination").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--ignore-errors"}).setDefault((Object)false).dest("ignoreerrors").help("delete even if there are I/O errors").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--force"}).setDefault((Object)false).dest("force").help("force deletion of directories even if not empty").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--max-delete"}).setDefault((Object)-1).type(Integer.class).dest("maxdelete").help("don't delete more than NUM files");
        parser.addArgument(new String[]{"--max-size"}).setDefault((Object)"").dest("maxsize").help("don't transfer any file larger than SIZE");
        parser.addArgument(new String[]{"--min-size"}).setDefault((Object)"").dest("minsize").help("don't transfer any file smaller than SIZE");
        parser.addArgument(new String[]{"--partial"}).setDefault((Object)false).dest("partial").help("keep partially transferred files").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--partial-dir"}).setDefault((Object)false).dest("partialdir").help("put a partially transferred file into DIR");
        parser.addArgument(new String[]{"--delay-updates"}).setDefault((Object)false).dest("delayupdates").help("put all updated files into place at transfer's end").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-m", "--prune-empty-dirs"}).setDefault((Object)false).dest("pruneemptydirs").help("prune empty directory chains from the file-list").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--numeric-ids"}).setDefault((Object)false).dest("numericids").help("don't map uid/gid values by user/group name").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--usermap"}).setDefault((Object)"").dest("usermap").help("custom username mapping");
        parser.addArgument(new String[]{"--groupmap"}).setDefault((Object)"").dest("groupmap").help("custom groupname mapping");
        parser.addArgument(new String[]{"--chown"}).setDefault((Object)"").dest("chown").help("simple username/groupname mapping");
        parser.addArgument(new String[]{"--timeout"}).setDefault((Object)-1).type(Integer.class).dest("timeout").help("set I/O timeout in seconds");
        parser.addArgument(new String[]{"--contimeout"}).setDefault((Object)-1).type(Integer.class).dest("contimeout").help("set daemon connection timeout in seconds");
        parser.addArgument(new String[]{"-I", "--ignore-times"}).setDefault((Object)false).dest("ignoretimes").help("don't skip files that match in size and mod-time").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-M", "--remote-option"}).setDefault((Object)"").dest("remoteoption").help("send OPTION to the remote side only");
        parser.addArgument(new String[]{"--size-only"}).setDefault((Object)false).dest("sizeonly").help("skip files that match in size").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--modify-window"}).setDefault((Object)-1).type(Integer.class).dest("modifywindow").help("compare mod-times with reduced accuracy");
        parser.addArgument(new String[]{"-T", "--temp-dir"}).setDefault((Object)"").dest("tempdir").help("create temporary files in directory DIR");
        parser.addArgument(new String[]{"-y", "--fuzzy"}).setDefault((Object)false).dest("fuzzy").help("find similar file for basis if no dest file").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--compare-dest"}).setDefault(new ArrayList()).dest("comparedest").action((ArgumentAction)Arguments.append()).help("also compare destination files relative to DIR");
        parser.addArgument(new String[]{"--copy-dest"}).setDefault(new ArrayList()).dest("copydest").action((ArgumentAction)Arguments.append()).help("... and include copies of unchanged files");
        parser.addArgument(new String[]{"--link-dest"}).setDefault(new ArrayList()).dest("linkdest").action((ArgumentAction)Arguments.append()).help("hardlink to files in DIR when unchanged");
        parser.addArgument(new String[]{"-z", "--compress"}).setDefault((Object)false).dest("compress").help("compress file data during the transfer").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--compress-level"}).setDefault((Object)-1).type(Integer.class).dest("compresslevel").help("explicitly set compression level");
        parser.addArgument(new String[]{"--skip-compress"}).setDefault((Object)"").dest("skipcompress").help("skip compressing files with a suffix in LIST");
        parser.addArgument(new String[]{"-C", "--cvs-exclude"}).setDefault((Object)false).dest("cvsexclude").help("auto-ignore files the same way CVS does").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-f", "--filter"}).setDefault(new ArrayList()).dest("filter").action((ArgumentAction)Arguments.append()).help("add a file-filtering RULE");
        parser.addArgument(new String[]{"--exclude"}).setDefault(new ArrayList()).dest("exclude").action((ArgumentAction)Arguments.append()).help("exclude files matching PATTERN");
        parser.addArgument(new String[]{"--exclude-from"}).setDefault(new ArrayList()).dest("excludefrom").help("read exclude patterns from FILE");
        parser.addArgument(new String[]{"--include"}).setDefault(new ArrayList()).dest("include").action((ArgumentAction)Arguments.append()).help("include files matching PATTERN");
        parser.addArgument(new String[]{"--include-from"}).setDefault(new ArrayList()).dest("includefrom").help("read include patterns from FILE");
        parser.addArgument(new String[]{"--files-from"}).setDefault((Object)"").dest("filesfrom").help("read list of source-file names from FILE");
        parser.addArgument(new String[]{"-0", "--from0"}).setDefault((Object)false).dest("from0").help("all *-from/filter files are delimited by 0s").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-s", "--protect-args"}).setDefault((Object)false).dest("protectargs").help("no space-splitting; only wildcard special-chars").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--address"}).setDefault((Object)"").dest("address").help("bind address for outgoing socket to daemon");
        parser.addArgument(new String[]{"--port"}).setDefault((Object)-1).type(Integer.class).dest("port").help("specify double-colon alternate port number");
        parser.addArgument(new String[]{"--sockopts"}).setDefault((Object)"").dest("sockopts").help("specify custom TCP options");
        parser.addArgument(new String[]{"--blocking-io"}).setDefault((Object)false).dest("blockingio").help("use blocking I/O for the remote shell").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--stats"}).setDefault((Object)false).dest("stats").help("give some file-transfer stats").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-8", "--8-bit-output"}).setDefault((Object)false).dest("eightbitoutput").help("leave high-bit chars unescaped in output").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--human-readable"}).setDefault((Object)false).dest("humanreadable").help("output numbers in a human-readable format").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--progress"}).setDefault((Object)false).dest("progress").help("show progress during transfer").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-i", "--itemize-changes"}).setDefault((Object)false).dest("itemizechanges").help("output a change-summary for all updates").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--out-format"}).setDefault((Object)"").dest("outformat").help("output updates using the specified FORMAT");
        parser.addArgument(new String[]{"--log-file"}).setDefault((Object)"").dest("logfile").help("log what we're doing to the specified FILE");
        parser.addArgument(new String[]{"--log-file-format"}).setDefault((Object)"").dest("logfileformat").help("log updates using the specified FMT");
        parser.addArgument(new String[]{"--password-file"}).setDefault((Object)"").dest("passwordfile").help("read daemon-access password from FILE");
        parser.addArgument(new String[]{"--list-only"}).setDefault((Object)false).dest("listonly").help("list the files instead of copying them (no target required)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--bwlimit"}).setDefault((Object)"").dest("bwlimit").help("limit socket I/O bandwidth");
        parser.addArgument(new String[]{"--outbuf"}).setDefault((Object)Character.valueOf('\u0000')).dest("outbuf").help("set output buffering to None, Line, or Block (N|L|B)");
        parser.addArgument(new String[]{"--write-batch"}).setDefault((Object)"").dest("writebatch").help("write a batched update to FILE");
        parser.addArgument(new String[]{"--only-write-batch"}).setDefault((Object)"").dest("onlywritebatch").help("like --write-batch but w/o updating destination");
        parser.addArgument(new String[]{"--read-batch"}).setDefault((Object)"").dest("readbatch").help("read a batched update from FILE");
        parser.addArgument(new String[]{"--protocol"}).setDefault((Object)-1).type(Integer.class).dest("protocol").help("force an older protocol version to be used");
        parser.addArgument(new String[]{"--iconv"}).setDefault((Object)"").dest("iconv").help("request charset conversion of filenames");
        parser.addArgument(new String[]{"--checkum-seed"}).setDefault((Object)-1).dest("checksumseed").help("set block/file checksum seed (advanced)");
        parser.addArgument(new String[]{"-4", "--ipv4"}).setDefault((Object)false).dest("ipv4").help("prefer IPv4").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-6", "--ipv6"}).setDefault((Object)false).dest("ipv6").help("prefer IPv6").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--version"}).setDefault((Object)false).dest("version").help("print version number").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--checksum-choice"}).setDefault((Object)"auto").dest("checksumchoice").help("choose the checksum algorithm: auto, xxh128, xxh3, xxh64/xxhash, md5, md4, sha1, none (since 3.1.3)");
        parser.addArgument(new String[]{"-U", "--atimes"}).setDefault((Object)false).dest("atimes").help("preserve access (use) times (since 3.2.0)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--open-noatime"}).setDefault((Object)false).dest("opennoatime").help("avoid changing the atime on opened files (since 3.2.0)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--write-devices"}).setDefault((Object)false).dest("writedevices").help("write to devices as files, implies --inplace (since 3.2.0)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--copy-as"}).setDefault((Object)"").dest("copyas").help("specify user & optional group for the copy 'USER[:GROUP]' (since 3.2.0)");
        parser.addArgument(new String[]{"--early-input"}).setDefault((Object)"").dest("earlyinput").help("use FILE for daemon's early exec input (since 3.2.1)");
        parser.addArgument(new String[]{"--max-alloc"}).setDefault((Object)"").dest("maxalloc").help("change a limit relating to memory alloc (since 3.2.2)");
        parser.addArgument(new String[]{"--mkpath"}).setDefault((Object)false).dest("mkpath").help("create destination's missing path components (since 3.2.3)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"-N", "--crtimes"}).setDefault((Object)false).dest("crtimes").help("preserve create times (newness) (since 3.2.3)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--stop-at"}).setDefault((Object)"").dest("stopat").help("stop rsync at the specified point in time 'y-m-dTh:m' (since 3.2.3)");
        parser.addArgument(new String[]{"--stop-after"}).setDefault((Object)"").dest("stopafter").help("stop rsync after MINS minutes have elapsed (since 3.2.3)");
        parser.addArgument(new String[]{"--copy-devices"}).setDefault((Object)false).dest("copydevices").help("copy device contents as a regular file (since 3.2.4)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--fsync"}).setDefault((Object)false).dest("fsync").help("fsync every written file (since 3.2.4)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--trust-sender"}).setDefault((Object)false).dest("trustsender").help("trust the remote sender's file list (since 3.2.5)").action((ArgumentAction)Arguments.storeTrue());
        parser.addArgument(new String[]{"--additional"}).setDefault(new ArrayList()).dest("additional").action((ArgumentAction)Arguments.append()).help("generic option to pass on to rsync; for command-line parsing to work though, leading dashes must get replaced with '+', eg '--additional \"++exclude=*~\"'");
        parser.addArgument(new String[]{"source(s)/destination"}).nargs("*").help("Multiple local/remote paths (path or [user@]host:path), with the last one being the target and the others the source(s).");
        return parser;
    }

    @Override
    protected boolean setOptions(Namespace ns) {
        boolean result = super.setOptions(ns);
        if (!result) {
            return false;
        }
        this.verbose(ns.getBoolean("verbose"));
        this.info(ns.getString("info"));
        this.debug(ns.getString("debug"));
        this.msgs2stderr(ns.getBoolean("msgs2stderr"));
        this.quiet(ns.getBoolean("quiet"));
        this.noMotd(ns.getBoolean("nomotd"));
        this.checksum(ns.getBoolean("checksum"));
        this.archive(ns.getBoolean("archive"));
        this.recursive(ns.getBoolean("recursive"));
        this.relative(ns.getBoolean("relative"));
        this.noImpliedDirs(ns.getBoolean("noimplieddirs"));
        this.backup(ns.getBoolean("backup"));
        this.backupDir(ns.getString("backupdir"));
        this.suffix(ns.getString("suffix"));
        this.update(ns.getBoolean("update"));
        this.inplace(ns.getBoolean("inplace"));
        this.append(ns.getBoolean("append"));
        this.appendVerify(ns.getBoolean("appendverify"));
        this.dirs(ns.getBoolean("dirs"));
        this.links(ns.getBoolean("links"));
        this.copyLinks(ns.getBoolean("copylinks"));
        this.copyUnsafeLinks(ns.getBoolean("copyunsafelinks"));
        this.safeLinks(ns.getBoolean("safelinks"));
        this.mungeLinks(ns.getBoolean("mungelinks"));
        this.copyDirlinks(ns.getBoolean("copydirlinks"));
        this.keepDirlinks(ns.getBoolean("keepdirlinks"));
        this.hardLinks(ns.getBoolean("hardlinks"));
        this.perms(ns.getBoolean("perms"));
        this.executability(ns.getBoolean("executability"));
        this.chmod(ns.getString("chmod"));
        this.xattrs(ns.getBoolean("xattrs"));
        this.owner(ns.getBoolean("owner"));
        this.group(ns.getBoolean("group"));
        this.devices(ns.getBoolean("devices"));
        this.specials(ns.getBoolean("specials"));
        this.times(ns.getBoolean("times"));
        this.omitDirTimes(ns.getBoolean("omitdirtimes"));
        this.omitLinkTimes(ns.getBoolean("omitlinktimes"));
        this.super_(ns.getBoolean("super_"));
        this.fakeSuper(ns.getBoolean("fakesuper"));
        this.sparse(ns.getBoolean("sparse"));
        this.preallocate(ns.getBoolean("preallocate"));
        this.dryRun(ns.getBoolean("dryrun"));
        this.wholeFile(ns.getBoolean("wholefile"));
        this.oneFileSystem(ns.getBoolean("onefilesystem"));
        this.blockSize(ns.getString("blocksize"));
        this.rsh(ns.getString("rsh"));
        this.rsyncPath(ns.getString("rsyncpath"));
        this.existing(ns.getBoolean("existing"));
        this.ignoreExisting(ns.getBoolean("ignoreexisting"));
        this.removeSourceFiles(ns.getBoolean("removesourcefiles"));
        this.delete(ns.getBoolean("delete"));
        this.deleteBefore(ns.getBoolean("deletebefore"));
        this.deleteDuring(ns.getBoolean("deleteduring"));
        this.deleteDelay(ns.getBoolean("deletedelay"));
        this.deleteAfter(ns.getBoolean("deleteafter"));
        this.deleteExcluded(ns.getBoolean("deleteexcluded"));
        this.ignoreMissingArgs(ns.getBoolean("ignoremissingargs"));
        this.deleteMissingArgs(ns.getBoolean("deletemissingargs"));
        this.ignoreErrors(ns.getBoolean("ignoreerrors"));
        this.force(ns.getBoolean("force"));
        this.maxDelete(ns.getInt("maxdelete"));
        this.maxSize(ns.getString("maxsize"));
        this.minSize(ns.getString("minsize"));
        this.partial(ns.getBoolean("partial"));
        this.delayUpdates(ns.getBoolean("delayupdates"));
        this.pruneEmptyDirs(ns.getBoolean("pruneemptydirs"));
        this.numericIds(ns.getBoolean("numericids"));
        this.usermap(ns.getString("usermap"));
        this.groupmap(ns.getString("groupmap"));
        this.chown(ns.getString("chown"));
        this.timeout(ns.getInt("timeout"));
        this.contimeout(ns.getInt("contimeout"));
        this.ignoreTimes(ns.getBoolean("ignoretimes"));
        this.remoteOption(ns.getString("remoteoption"));
        this.sizeOnly(ns.getBoolean("sizeonly"));
        this.modifyWindow(ns.getInt("modifywindow"));
        this.tempDir(ns.getString("tempdir"));
        this.fuzzy(ns.getBoolean("fuzzy"));
        this.compareDest(ns.getList("comparedest").toArray(new String[0]));
        this.copyDest(ns.getList("copydest").toArray(new String[0]));
        this.linkDest(ns.getList("linkdest").toArray(new String[0]));
        this.compress(ns.getBoolean("compress"));
        this.compressLevel(ns.getInt("compresslevel"));
        this.skipCompress(ns.getString("skipcompress"));
        this.cvsExclude(ns.getBoolean("cvsexclude"));
        this.filter(ns.getList("filter").toArray(new String[0]));
        this.include(ns.getList("include").toArray(new String[0]));
        this.includeFrom(ns.getList("includefrom").toArray(new String[0]));
        this.exclude(ns.getList("exclude").toArray(new String[0]));
        this.excludeFrom(ns.getList("excludefrom").toArray(new String[0]));
        this.filesFrom(ns.getString("filesfrom"));
        this.from0(ns.getBoolean("from0"));
        this.protectArgs(ns.getBoolean("protectargs"));
        this.address(ns.getString("address"));
        this.port(ns.getInt("port"));
        this.sockopts(ns.getString("sockopts"));
        this.blockingIO(ns.getBoolean("blockingio"));
        this.stats(ns.getBoolean("stats"));
        this.eightBitOutput(ns.getBoolean("eightbitoutput"));
        this.humanReadable(ns.getBoolean("humanreadable"));
        this.progress(ns.getBoolean("progress"));
        this.itemizeChanges(ns.getBoolean("itemizechanges"));
        this.outFormat(ns.getString("outformat"));
        this.logFile(ns.getString("logfile"));
        this.logFileFormat(ns.getString("logfileformat"));
        this.passwordFile(ns.getString("passwordfile"));
        this.listOnly(ns.getBoolean("listonly"));
        this.bwlimit(ns.getString("bwlimit"));
        this.outbuf(ns.getString("outbuf").charAt(0));
        this.writeBatch(ns.getString("writebatch"));
        this.onlyWriteBatch(ns.getString("onlywritebatch"));
        this.readBatch(ns.getString("readbatch"));
        this.protocol(ns.getInt("protocol"));
        this.iconv(ns.getString("iconv"));
        this.checksumSeed(ns.getInt("checksumseed"));
        this.ipv4(ns.getBoolean("ipv4"));
        this.ipv6(ns.getBoolean("ipv6"));
        this.version(ns.getBoolean("version"));
        this.trustSender(ns.getBoolean("trustsender"));
        this.fsync(ns.getBoolean("fsync"));
        this.copyDevices(ns.getBoolean("copydevices"));
        this.stopAfter(ns.getString("stopafter"));
        this.stopAt(ns.getString("stopat"));
        this.crtimes(ns.getBoolean("crtimes"));
        this.mkpath(ns.getBoolean("mkpath"));
        this.maxAlloc(ns.getString("maxalloc"));
        this.earlyInput(ns.getString("earlyinput"));
        this.atimes(ns.getBoolean("atimes"));
        this.openNoatime(ns.getBoolean("opennoatime"));
        this.writeDevices(ns.getBoolean("writedevices"));
        this.copyAs(ns.getString("copyas"));
        this.checksumChoice(ns.getString("checksumchoice"));
        this.additional(ns.getList("additional").toArray(new String[0]));
        List src_dest = ns.getList("source(s)/destination");
        if (src_dest.isEmpty() && this.isListOnly()) {
            System.err.println("Source required!");
            return false;
        }
        if (src_dest.size() < 2 && !this.isListOnly()) {
            System.err.println("Source and destination required!");
            return false;
        }
        if (!this.isListOnly()) {
            this.destination((String)src_dest.get(src_dest.size() - 1));
            src_dest.remove(src_dest.size() - 1);
        }
        this.sources(src_dest);
        return true;
    }

    public static void main(String[] args) throws Exception {
        RSync.run(new RSync(), args);
    }
}

