/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;

public class Binaries {
    public static final String RESOURCE_DIR = "com/github/fracpete/rsync4j/";
    public static final String WINDOWS_DIR_32 = "windows-x86/";
    public static final String WINDOWS_DIR_64 = "windows-x86_64/";
    public static final String WINDOWS_HOME_DIR = "RSYNC4J_HOME";
    public static final String LIBRARIES = "libraries.txt";
    protected static Boolean binariesExtracted;
    protected static String rsyncBinary;
    protected static String sshBinary;
    protected static String sshkeygenBinary;
    protected static Logger LOGGER;

    public static synchronized int getBitness() {
        String arch = System.getProperty("os.arch");
        if (arch.endsWith("86")) {
            return 32;
        }
        if (arch.endsWith("64")) {
            return 64;
        }
        throw new IllegalStateException("Cannot interpret 'os.arch' for bitness: " + arch);
    }

    protected static String copyResourceTo(String inDir, String name, String outDir) throws Exception {
        String result = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            String resource = inDir;
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            resource = resource + name;
            String outFull = outDir + File.separator + name;
            LOGGER.info("Copying resource '" + resource + "' to '" + outFull + "'");
            is = Binaries.class.getClassLoader().getResourceAsStream(resource);
            bis = new BufferedInputStream(is);
            File out = new File(outFull);
            fos = new FileOutputStream(out);
            bos = new BufferedOutputStream(fos);
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            result = out.getAbsolutePath();
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, "Copying failed!", e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    protected static String homeDir() {
        File dir;
        String result = System.getProperty("user.home") + File.separator + "rsync4j";
        if (SystemUtils.IS_OS_WINDOWS && System.getenv(WINDOWS_HOME_DIR) != null && (!(dir = new File(System.getenv(WINDOWS_HOME_DIR))).exists() || dir.isDirectory())) {
            result = dir.getAbsolutePath();
        }
        return result;
    }

    protected static String getWindowsDir() {
        if (Binaries.getBitness() == 32) {
            return WINDOWS_DIR_32;
        }
        return WINDOWS_DIR_64;
    }

    protected static List<String> getLibraries() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String resource = RESOURCE_DIR + Binaries.getWindowsDir() + LIBRARIES;
        InputStream is = null;
        try {
            int c;
            StringBuilder buf = new StringBuilder();
            is = Binaries.class.getClassLoader().getResourceAsStream(resource);
            while ((c = is.read()) != -1) {
                buf.append((char)c);
            }
            result.addAll(Arrays.asList(buf.toString().split("\n")));
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException("Failed to read list of libraries from: " + resource);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return result;
    }

    protected static void extractBinaries() throws Exception {
        sshBinary = "/usr/bin/ssh";
        rsyncBinary = "/usr/bin/rsync";
        sshkeygenBinary = "/usr/bin/ssh-keygen";
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            if (!new File(rsyncBinary).exists()) {
                throw new IllegalStateException("rsync not installed (" + rsyncBinary + ")?");
            }
            if (!new File(sshBinary).exists()) {
                throw new IllegalStateException("ssh not installed (" + sshBinary + ")?");
            }
            if (!new File(sshkeygenBinary).exists()) {
                throw new IllegalStateException("ssh-keygen not installed (" + sshkeygenBinary + ")?");
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            String homeDir = Binaries.homeDir();
            String binDir = homeDir + File.separator + "bin";
            String sshDir = homeDir + File.separator + "home" + File.separator + System.getProperty("user.name") + File.separator + ".ssh";
            if (!new File(binDir + File.separator + "rsync.exe").exists()) {
                LOGGER.info("Setting up rsync4j environment in '" + homeDir + "'...");
                File dir = new File(binDir);
                if (!dir.exists()) {
                    LOGGER.info("Creating directory: " + dir);
                    if (!dir.mkdirs()) {
                        throw new IllegalStateException("Failed to create directory: " + dir);
                    }
                }
                if (!(dir = new File(sshDir)).exists()) {
                    LOGGER.info("Creating directory: " + dir);
                    if (!dir.mkdirs()) {
                        throw new IllegalStateException("Failed to create directory: " + dir);
                    }
                }
                LOGGER.info("Copy your public key pairs into: " + dir);
                String winDir = Binaries.getWindowsDir();
                for (String lib : Binaries.getLibraries()) {
                    Binaries.copyResourceTo(RESOURCE_DIR + winDir, lib, binDir);
                }
                sshBinary = Binaries.copyResourceTo(RESOURCE_DIR + winDir, "ssh.exe", binDir);
                rsyncBinary = Binaries.copyResourceTo(RESOURCE_DIR + winDir, "rsync.exe", binDir);
                sshkeygenBinary = Binaries.copyResourceTo(RESOURCE_DIR + winDir, "ssh-keygen.exe", binDir);
            } else {
                sshBinary = binDir + File.separator + "ssh.exe";
                rsyncBinary = binDir + File.separator + "rsync.exe";
                sshkeygenBinary = binDir + File.separator + "ssh-keygen.exe";
            }
        } else {
            throw new IllegalStateException("Unsupported operating system: " + SystemUtils.OS_NAME + "/" + SystemUtils.OS_ARCH + "/" + SystemUtils.OS_VERSION);
        }
        binariesExtracted = true;
    }

    public static String rsyncBinary() throws Exception {
        if (binariesExtracted == null) {
            Binaries.extractBinaries();
        }
        return rsyncBinary;
    }

    public static String sshBinary() throws Exception {
        if (binariesExtracted == null) {
            Binaries.extractBinaries();
        }
        return sshBinary;
    }

    public static String sshkeygenBinary() throws Exception {
        if (binariesExtracted == null) {
            Binaries.extractBinaries();
        }
        return sshkeygenBinary;
    }

    public static String convertPath(String path) {
        String result = path;
        if (SystemUtils.IS_OS_WINDOWS && (result = result.replace("\\", "/")).matches("^[a-zA-Z]:.*")) {
            result = "/cygdrive/" + result.substring(0, 1).toLowerCase() + "/" + result.substring(2);
        }
        return result;
    }

    static {
        LOGGER = Logger.getLogger(Binaries.class.getName());
    }
}

