/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j;

import com.github.fracpete.rsync4j.core.AbstractBinary;
import com.github.fracpete.rsync4j.core.Binaries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;

public class SshKeyGen
extends AbstractBinary {
    protected boolean forAll;
    protected int rounds;
    protected boolean bubbleBabble;
    protected int bits;
    protected String comment;
    protected String pkcs11;
    protected String fingerprint;
    protected boolean export;
    protected String findHost;
    protected String keyFile;
    protected String candidatePrimes;
    protected boolean genericDnsFormat;
    protected boolean hashKnownHosts;
    protected boolean createHostCertificate;
    protected String certificateIdentity;
    protected boolean importUnencrypted;
    protected int screenNumLines;
    protected int screenStartLine;
    protected String screenCheckPoint;
    protected boolean generateKRL;
    protected boolean printContents;
    protected boolean showFingerprint;
    protected int memory;
    protected String keyFormat;
    protected String newPassPhrase;
    protected String principals;
    protected List<String> option;
    protected boolean useOpenSshFormat;
    protected String passPhrase;
    protected boolean changePassPhrase;
    protected boolean testRevoked;
    protected boolean quiet;
    protected String removeKeys;
    protected String printFingerprint;
    protected String startPoint;
    protected String signCaKey;
    protected String testCandidatePrimes;
    protected String keyType;
    protected boolean updateKRL;
    protected String validityInterval;
    protected int verbose;
    protected String generator;
    protected boolean readPrivatePrintPublicOpenSsh;
    protected String serialNumber;
    protected List<String> file;

    @Override
    public void reset() {
        super.reset();
        this.forAll = false;
        this.rounds = -1;
        this.bubbleBabble = false;
        this.bits = -1;
        this.comment = "";
        this.pkcs11 = "";
        this.fingerprint = "";
        this.export = false;
        this.findHost = "";
        this.keyFile = "";
        this.candidatePrimes = "";
        this.genericDnsFormat = false;
        this.hashKnownHosts = false;
        this.createHostCertificate = false;
        this.certificateIdentity = "";
        this.importUnencrypted = false;
        this.screenNumLines = -1;
        this.screenStartLine = -1;
        this.screenCheckPoint = "";
        this.generateKRL = false;
        this.printContents = false;
        this.showFingerprint = false;
        this.memory = -1;
        this.keyFormat = "";
        this.newPassPhrase = null;
        this.principals = "";
        this.option = new ArrayList<String>();
        this.useOpenSshFormat = false;
        this.passPhrase = null;
        this.changePassPhrase = false;
        this.testRevoked = false;
        this.quiet = false;
        this.removeKeys = "";
        this.printFingerprint = "";
        this.startPoint = "";
        this.signCaKey = "";
        this.testCandidatePrimes = "";
        this.keyType = "";
        this.updateKRL = false;
        this.validityInterval = "";
        this.verbose = 0;
        this.generator = "";
        this.readPrivatePrintPublicOpenSsh = false;
        this.serialNumber = "";
        this.file = new ArrayList<String>();
    }

    public SshKeyGen forAll(boolean value) {
        this.forAll = value;
        return this;
    }

    public boolean isForAll() {
        return this.forAll;
    }

    public SshKeyGen rounds(int value) {
        this.rounds = value;
        return this;
    }

    public int getRounds() {
        return this.rounds;
    }

    public SshKeyGen bubbleBabble(boolean value) {
        this.bubbleBabble = value;
        return this;
    }

    public boolean isBubbleBabble() {
        return this.bubbleBabble;
    }

    public SshKeyGen bits(int value) {
        this.bits = value;
        return this;
    }

    public int getBits() {
        return this.bits;
    }

    public SshKeyGen comment(String value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public SshKeyGen pkcs11(String value) {
        this.pkcs11 = value;
        return this;
    }

    public String getPkcs11() {
        return this.pkcs11;
    }

    public SshKeyGen fingerprint(String value) {
        this.fingerprint = value;
        return this;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public SshKeyGen export(boolean value) {
        this.export = value;
        return this;
    }

    public boolean isExport() {
        return this.export;
    }

    public SshKeyGen findHost(String value) {
        this.findHost = value;
        return this;
    }

    public String getFindHost() {
        return this.findHost;
    }

    public SshKeyGen keyFile(String value) {
        this.keyFile = value;
        return this;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public SshKeyGen candidatePrimes(String value) {
        this.candidatePrimes = value;
        return this;
    }

    public String getCandidatePrimes() {
        return this.candidatePrimes;
    }

    public SshKeyGen genericDnsFormat(boolean value) {
        this.genericDnsFormat = value;
        return this;
    }

    public boolean isGenericDnsFormat() {
        return this.genericDnsFormat;
    }

    public SshKeyGen hashKnownHosts(boolean value) {
        this.hashKnownHosts = value;
        return this;
    }

    public boolean isHashKnownHosts() {
        return this.hashKnownHosts;
    }

    public SshKeyGen createHostCertificate(boolean value) {
        this.createHostCertificate = value;
        return this;
    }

    public boolean isCreateHostCertificate() {
        return this.createHostCertificate;
    }

    public SshKeyGen certificateIdentity(String value) {
        this.certificateIdentity = value;
        return this;
    }

    public String getCertificateIdentity() {
        return this.certificateIdentity;
    }

    public SshKeyGen importUnencrypted(boolean value) {
        this.importUnencrypted = value;
        return this;
    }

    public boolean isImportUnencrypted() {
        return this.importUnencrypted;
    }

    public SshKeyGen screenNumLines(int value) {
        if (value >= -1) {
            this.screenNumLines = value;
        }
        return this;
    }

    public int getScreenNumLines() {
        return this.screenNumLines;
    }

    public SshKeyGen screenStartLine(int value) {
        if (value >= -1) {
            this.screenStartLine = value;
        }
        return this;
    }

    public int getScreenStartLine() {
        return this.screenStartLine;
    }

    public SshKeyGen screenCheckPoint(String value) {
        this.screenCheckPoint = value;
        return this;
    }

    public String getScreenCheckPoint() {
        return this.screenCheckPoint;
    }

    public SshKeyGen generateKRL(boolean value) {
        this.generateKRL = value;
        return this;
    }

    public boolean isGenerateKRL() {
        return this.generateKRL;
    }

    public SshKeyGen printContents(boolean value) {
        this.printContents = value;
        return this;
    }

    public boolean isPrintContents() {
        return this.printContents;
    }

    public SshKeyGen showFingerprint(boolean value) {
        this.showFingerprint = value;
        return this;
    }

    public boolean isShowFingerprint() {
        return this.showFingerprint;
    }

    public SshKeyGen memory(int value) {
        if (value == -1 || value > 0) {
            this.memory = value;
        }
        return this;
    }

    public int getMemory() {
        return this.memory;
    }

    public SshKeyGen keyFormat(String value) {
        this.keyFormat = value;
        return this;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public SshKeyGen newPassPhrase(String value) {
        this.newPassPhrase = value;
        return this;
    }

    public String getNewPassPhrase() {
        return this.newPassPhrase;
    }

    public SshKeyGen principals(String value) {
        this.principals = value;
        return this;
    }

    public String getPrincipals() {
        return this.principals;
    }

    public SshKeyGen option(String ... value) {
        this.option = new ArrayList<String>(Arrays.asList(value));
        return this;
    }

    public SshKeyGen option(List<String> value) {
        this.option = new ArrayList<String>(value);
        return this;
    }

    public List<String> getOption() {
        return this.option;
    }

    public SshKeyGen useOpenSshFormat(boolean value) {
        this.useOpenSshFormat = value;
        return this;
    }

    public boolean isUseOpenSshFormat() {
        return this.useOpenSshFormat;
    }

    public SshKeyGen passPhrase(String value) {
        this.passPhrase = value;
        return this;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public SshKeyGen changePassPhrase(boolean value) {
        this.changePassPhrase = value;
        return this;
    }

    public boolean isChangePassPhrase() {
        return this.changePassPhrase;
    }

    public SshKeyGen testRevoked(boolean value) {
        this.testRevoked = value;
        return this;
    }

    public boolean isTestRevoked() {
        return this.testRevoked;
    }

    public SshKeyGen quiet(boolean value) {
        this.quiet = value;
        return this;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public SshKeyGen removeKeys(String value) {
        this.removeKeys = value;
        return this;
    }

    public String getRemoveKeys() {
        return this.removeKeys;
    }

    public SshKeyGen printFingerprint(String value) {
        this.printFingerprint = value;
        return this;
    }

    public String getPrintFingerprint() {
        return this.printFingerprint;
    }

    public SshKeyGen startPoint(String value) {
        this.startPoint = value;
        return this;
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public SshKeyGen signCaKey(String value) {
        this.signCaKey = value;
        return this;
    }

    public String getSignCaKey() {
        return this.signCaKey;
    }

    public SshKeyGen testCandidatePrimes(String value) {
        this.testCandidatePrimes = value;
        return this;
    }

    public String getTestCandidatePrimes() {
        return this.testCandidatePrimes;
    }

    public SshKeyGen keyType(String value) {
        this.keyType = value;
        return this;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public SshKeyGen updateKRL(boolean value) {
        this.updateKRL = value;
        return this;
    }

    public boolean isUpdateKRL() {
        return this.updateKRL;
    }

    public SshKeyGen validityInterval(String value) {
        this.validityInterval = value;
        return this;
    }

    public String getValidityInterval() {
        return this.validityInterval;
    }

    public SshKeyGen verbose(int value) {
        if (value >= -1 && value <= 3) {
            this.verbose = value;
        }
        return this;
    }

    public int getVerbose() {
        return this.verbose;
    }

    public SshKeyGen generator(String value) {
        this.generator = value;
        return this;
    }

    public String getGenerator() {
        return this.generator;
    }

    public SshKeyGen readPrivatePrintPublicOpenSsh(boolean value) {
        this.readPrivatePrintPublicOpenSsh = value;
        return this;
    }

    public boolean isReadPrivatePrintPublicOpenSsh() {
        return this.readPrivatePrintPublicOpenSsh;
    }

    public SshKeyGen serialNumber(String value) {
        this.serialNumber = value;
        return this;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public SshKeyGen file(String ... value) {
        this.file = new ArrayList<String>(Arrays.asList(value));
        return this;
    }

    public SshKeyGen file(List<String> value) {
        this.file = new ArrayList<String>(value);
        return this;
    }

    public List<String> getFile() {
        return this.file;
    }

    @Override
    public SshKeyGen outputCommandline(boolean value) {
        return (SshKeyGen)super.outputCommandline(value);
    }

    @Override
    public List<String> options() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isForAll()) {
            result.add("-A");
        }
        if (this.getRounds() > -1) {
            result.add("-a");
            result.add("" + this.getRounds());
        }
        if (this.isBubbleBabble()) {
            result.add("-B");
        }
        if (this.getBits() > -1) {
            result.add("-b");
            result.add("" + this.getBits());
        }
        if (!this.getComment().isEmpty()) {
            result.add("-C");
            result.add(this.getComment());
        }
        if (!this.getPkcs11().isEmpty()) {
            result.add("-D");
            result.add(this.getPkcs11());
        }
        if (!this.getFingerprint().isEmpty()) {
            result.add("-E");
            result.add(this.getFingerprint());
        }
        if (this.isExport()) {
            result.add("-e");
        }
        if (!this.getFindHost().isEmpty()) {
            result.add("-F");
            result.add(this.getFindHost());
        }
        if (!this.getKeyFile().isEmpty()) {
            result.add("-f");
            result.add(this.getKeyFile());
        }
        if (!this.getCandidatePrimes().isEmpty()) {
            result.add("-G");
            result.add(this.getCandidatePrimes());
        }
        if (this.isGenericDnsFormat()) {
            result.add("-g");
        }
        if (this.isHashKnownHosts()) {
            result.add("-H");
        }
        if (this.isCreateHostCertificate()) {
            result.add("-h");
        }
        if (!this.getCertificateIdentity().isEmpty()) {
            result.add("-I");
            result.add(this.getCertificateIdentity());
        }
        if (this.isImportUnencrypted()) {
            result.add("-i");
        }
        if (this.getScreenNumLines() > -1) {
            result.add("-J");
            result.add("" + this.getScreenNumLines());
        }
        if (this.getScreenStartLine() > -1) {
            result.add("-j");
            result.add("" + this.getScreenStartLine());
        }
        if (!this.getScreenCheckPoint().isEmpty()) {
            result.add("-K");
            result.add(this.getScreenCheckPoint());
        }
        if (this.isGenerateKRL()) {
            result.add("-k");
        }
        if (this.isPrintContents()) {
            result.add("-L");
        }
        if (this.isShowFingerprint()) {
            result.add("-l");
        }
        if (this.getMemory() > -1) {
            result.add("-M");
            result.add("" + this.getMemory());
        }
        if (!this.getKeyFormat().isEmpty()) {
            result.add("-m");
            result.add(this.getKeyFormat());
        }
        if (this.getNewPassPhrase() != null) {
            result.add("-N");
            result.add(this.getNewPassPhrase());
        }
        if (!this.getPrincipals().isEmpty()) {
            result.add("-n");
            result.add(this.getPrincipals());
        }
        for (String o : this.getOption()) {
            result.add("-O");
            result.add(o);
        }
        if (this.isUseOpenSshFormat()) {
            result.add("-o");
        }
        if (this.getPassPhrase() != null) {
            result.add("-P");
            result.add(this.getPassPhrase());
        }
        if (this.isChangePassPhrase()) {
            result.add("-p");
        }
        if (this.isTestRevoked()) {
            result.add("-Q");
        }
        if (this.isQuiet()) {
            result.add("-q");
        }
        if (!this.getRemoveKeys().isEmpty()) {
            result.add("-R");
            result.add(this.getRemoveKeys());
        }
        if (!this.getPrintFingerprint().isEmpty()) {
            result.add("-r");
            result.add(this.getPrintFingerprint());
        }
        if (!this.getStartPoint().isEmpty()) {
            result.add("-S");
            result.add(this.getStartPoint());
        }
        if (!this.getSignCaKey().isEmpty()) {
            result.add("-s");
            result.add(this.getSignCaKey());
        }
        if (!this.getTestCandidatePrimes().isEmpty()) {
            result.add("-T");
            result.add(this.getTestCandidatePrimes());
        }
        if (!this.getKeyType().isEmpty()) {
            result.add("-t");
            result.add(this.getKeyType());
        }
        if (this.isUpdateKRL()) {
            result.add("-u");
        }
        if (!this.getValidityInterval().isEmpty()) {
            result.add("-V");
            result.add(this.getValidityInterval());
        }
        if (this.getVerbose() == 1) {
            result.add("-v");
        }
        if (this.getVerbose() == 2) {
            result.add("-vv");
        }
        if (this.getVerbose() == 3) {
            result.add("-vvv");
        }
        if (!this.getGenerator().isEmpty()) {
            result.add("-W");
            result.add(this.getGenerator());
        }
        if (this.isReadPrivatePrintPublicOpenSsh()) {
            result.add("-y");
        }
        if (!this.getSerialNumber().isEmpty()) {
            result.add("-z");
            result.add(this.getSerialNumber());
        }
        result.addAll(this.getFile());
        return result;
    }

    @Override
    public List<String> commandLineArgs() throws Exception {
        String binary = Binaries.sshkeygenBinary();
        List<String> result = this.options();
        result.add(0, binary);
        return result;
    }

    @Override
    protected String description() {
        return "Authentication key generation, management and conversion.\nSee man page:\nhttps://linux.die.net/man/1/ssh-keygen";
    }

    @Override
    protected ArgumentParser getParser() {
        ArgumentParser parser = super.getParser();
        parser.addArgument(new String[]{"-A"}).dest("forAll").help("For each of the key types (rsa1, rsa, dsa, ecdsa and ed25519) for which host keys do not exist, generate the host keys with the default key file path, an empty passphrase, default bits for the key type, and default comment.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-a"}).dest("rounds").help("When saving a new-format private key (i.e. an ed25519 key or any SSH protocol 2 key when the -o flag is set), this option specifies the number of KDF (key derivation function) rounds used.").setDefault((Object)-1);
        parser.addArgument(new String[]{"-B"}).dest("bubbleBabble").help("Show the bubblebabble digest of specified private or public key file.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-b"}).dest("bits").help("Specifies the number of bits in the key to create.").setDefault((Object)-1);
        parser.addArgument(new String[]{"-C"}).dest("comment").help("Provides a new comment.").setDefault((Object)"");
        parser.addArgument(new String[]{"-D"}).dest("pkcs11").help("Download the RSA public keys provided by the PKCS#11 shared library pkcs11.").setDefault((Object)"");
        parser.addArgument(new String[]{"-E"}).dest("fingerprint").help("Specifies the hash algorithm used when displaying key fingerprints.").setDefault((Object)"");
        parser.addArgument(new String[]{"-e"}).dest("export").help("This option will read a private or public OpenSSH key file and print to stdout the key in one of the formats specified by the -m option.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-F"}).dest("findHost").help("Search for the specified hostname in a known_hosts file, listing any occurrences found.").setDefault((Object)"");
        parser.addArgument(new String[]{"-f"}).dest("keyFile").help("Specifies the filename of the key file.").setDefault((Object)"");
        parser.addArgument(new String[]{"-G"}).dest("candidatePrimes").help("Generate candidate primes for DH-GEX..").setDefault((Object)"");
        parser.addArgument(new String[]{"-g"}).dest("genericDnsFormat").help("Use generic DNS format when printing fingerprint resource records using the -r command.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-H"}).dest("hashKnownHosts").help("Hash a known_hosts file.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"--host"}).dest("createHostCertificate").help("When signing a key, create a host certificate instead of a user certificate.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-i"}).dest("importUnencrypted").help("This option will read an unencrypted private (or public) key file in the format specified by the -m option and print an OpenSSH compatible private (or public) key to stdout.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-J"}).dest("screenNumLines").help("Exit after screening the specified number of lines while performing DH candidate screening using the -T option.").setDefault((Object)-1);
        parser.addArgument(new String[]{"-j"}).dest("screenStartLine").help("Start screening at the specified line number while performing DH candidate screening using the -T option.").setDefault((Object)-1);
        parser.addArgument(new String[]{"-K"}).dest("screenCheckPoint").help("Write the last line processed to the file checkpt while performing DH candidate screening using the -T option.").setDefault((Object)"");
        parser.addArgument(new String[]{"-k"}).dest("generateKRL").help("Generate a KRL file.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-L"}).dest("printContents").help("Prints the contents of one or more certificates.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-l"}).dest("showFingerprint").help("Show fingerprint of specified public key file.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-M"}).dest("memory").help("Specify the amount of memory to use (in megabytes) when generating candidate moduli for DH-GEX.").setDefault((Object)-1);
        parser.addArgument(new String[]{"-m"}).dest("keyFormat").help("Specify a key format for the -i (import) or -e (export) conversion options.").setDefault((Object)"");
        parser.addArgument(new String[]{"-N"}).dest("newPassPhrase").help("Provides the new passphrase.").required(false);
        parser.addArgument(new String[]{"-n"}).dest("principals").help("Specify one or more principals (user or host names) to be included in a certificate when signing a key.").setDefault((Object)"");
        parser.addArgument(new String[]{"-O"}).dest("option").help("Specify a certificate option when signing a key.").setDefault(new ArrayList());
        parser.addArgument(new String[]{"-o"}).dest("useOpenSshFormat").help("Causes ssh-keygen to save private keys using the new OpenSSH format rather than the more compatible PEM format.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-P"}).dest("passPhrase").help("Provides the (old) passphrase.").required(false);
        parser.addArgument(new String[]{"-p"}).dest("changePassPhrase").help("Requests changing the passphrase of a private key file instead of creating a new private key.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-Q"}).dest("testRevoked").help("Test whether keys have been revoked in a KRL.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-q"}).dest("quiet").help("Silence ssh-keygen.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-R"}).dest("removeKeys").help("Removes all keys belonging to hostname from a known_hosts file.").setDefault((Object)"");
        parser.addArgument(new String[]{"-r"}).dest("printFingerprint").help("Print the SSHFP fingerprint resource record named hostname for the specified public key file.").setDefault((Object)"");
        parser.addArgument(new String[]{"-S"}).dest("startPoint").help("Specify start point (in hex) when generating candidate moduli for DH-GEX.").setDefault((Object)"");
        parser.addArgument(new String[]{"-s"}).dest("signCaKey").help("Certify (sign) a public key using the specified CA key.").setDefault((Object)"");
        parser.addArgument(new String[]{"-T"}).dest("testCandidatePrimes").help("Test DH group exchange candidate primes (generated using the -G option) for safety.").setDefault((Object)"");
        parser.addArgument(new String[]{"-t"}).dest("keyType").help("Specifies the type of key to create.").setDefault((Object)"");
        parser.addArgument(new String[]{"-u"}).dest("updateKRL").help("Update a KRL.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-V"}).dest("validityInterval").help("Specify a validity interval when signing a certificate.").setDefault((Object)"");
        parser.addArgument(new String[]{"-v"}).dest("verbose").help("Verbose mode.").action((ArgumentAction)Arguments.storeConst()).setConst((Object)1).setDefault((Object)0);
        parser.addArgument(new String[]{"-vv"}).dest("verbose").help("Very verbose mode.").action((ArgumentAction)Arguments.storeConst()).setConst((Object)2).setDefault((Object)0);
        parser.addArgument(new String[]{"-vvv"}).dest("verbose").help("Very, very verbose mode.").action((ArgumentAction)Arguments.storeConst()).setConst((Object)3).setDefault((Object)0);
        parser.addArgument(new String[]{"-W"}).dest("generator").help("Specify desired generator when testing candidate moduli for DH-GEX.").setDefault((Object)"");
        parser.addArgument(new String[]{"-y"}).dest("readPrivatePrintPublicOpenSsh").help("This option will read a private OpenSSH format file and print an OpenSSH public key to stdout.").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)false);
        parser.addArgument(new String[]{"-z"}).dest("serialNumber").help("Specifies a serial number to be embedded in the certificate to distinguish this certificate from others from the same CA.").setDefault((Object)"");
        parser.addArgument(new String[]{"file"}).nargs("*").dest("file").help("The key file(s).").setDefault(new ArrayList());
        return parser;
    }

    @Override
    protected boolean setOptions(Namespace ns) {
        boolean result = super.setOptions(ns);
        if (!result) {
            return false;
        }
        this.forAll(ns.getBoolean("forAll"));
        this.rounds(ns.getInt("rounds"));
        this.bubbleBabble(ns.getBoolean("bubbleBabble"));
        this.bits(ns.getInt("bits"));
        this.comment(ns.getString("comment"));
        this.pkcs11(ns.getString("pkcs11"));
        this.fingerprint(ns.getString("fingerprint"));
        this.export(ns.getBoolean("export"));
        this.findHost(ns.getString("findHost"));
        this.keyFile(ns.getString("keyFile"));
        this.candidatePrimes(ns.getString("candidatePrimes"));
        this.genericDnsFormat(ns.getBoolean("genericDnsFormat"));
        this.hashKnownHosts(ns.getBoolean("hashKnownHosts"));
        this.createHostCertificate(ns.getBoolean("createHostCertificate"));
        this.certificateIdentity(ns.getString("certificateIdentity"));
        this.importUnencrypted(ns.getBoolean("importUnencrypted"));
        this.screenNumLines(ns.getInt("screenNumLines"));
        this.screenStartLine(ns.getInt("screenStartLine"));
        this.screenCheckPoint(ns.getString("screenCheckPoint"));
        this.generateKRL(ns.getBoolean("generateKRL"));
        this.printContents(ns.getBoolean("printContents"));
        this.showFingerprint(ns.getBoolean("showFingerprint"));
        this.memory(ns.getInt("memory"));
        this.keyFormat(ns.getString("keyFormat"));
        this.newPassPhrase(ns.getString("newPassPhrase"));
        this.principals(ns.getString("principals"));
        this.option(ns.getList("option"));
        this.useOpenSshFormat(ns.getBoolean("useOpenSshFormat"));
        this.passPhrase(ns.getString("passPhrase"));
        this.changePassPhrase(ns.getBoolean("changePassPhrase"));
        this.testRevoked(ns.getBoolean("testRevoked"));
        this.quiet(ns.getBoolean("quiet"));
        this.removeKeys(ns.getString("removeKeys"));
        this.printFingerprint(ns.getString("printFingerprint"));
        this.startPoint(ns.getString("startPoint"));
        this.signCaKey(ns.getString("signCaKey"));
        this.testCandidatePrimes(ns.getString("testCandidatePrimes"));
        this.keyType(ns.getString("keyType"));
        this.updateKRL(ns.getBoolean("updateKRL"));
        this.validityInterval(ns.getString("validityInterval"));
        this.verbose(ns.getInt("verbose"));
        this.generator(ns.getString("generator"));
        this.readPrivatePrintPublicOpenSsh(ns.getBoolean("readPrivatePrintPublicOpenSsh"));
        this.serialNumber(ns.getString("serialNumber"));
        this.file(ns.getList("file"));
        return true;
    }

    public static void main(String[] args) throws Exception {
        SshKeyGen.run(new SshKeyGen(), args);
    }
}

