/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.core.impl;

import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;

public class PrefixedStreamingProcessOwner
implements StreamingProcessOwner {
    public static final String DEFAULT_PREFIX_STDOUT = "[OUT] ";
    public static final String DEFAULT_PREFIX_STDERR = "[ERR] ";
    protected String m_PrefixStdOut;
    protected String m_PrefixStdErr;

    public PrefixedStreamingProcessOwner() {
        this(DEFAULT_PREFIX_STDOUT, DEFAULT_PREFIX_STDERR);
    }

    public PrefixedStreamingProcessOwner(String prefixStdOut, String prefixStdErr) {
        this.m_PrefixStdOut = prefixStdOut;
        this.m_PrefixStdErr = prefixStdErr;
    }

    @Override
    public StreamingProcessOutputType getOutputType() {
        return StreamingProcessOutputType.BOTH;
    }

    @Override
    public void processOutput(String line, boolean stdout) {
        System.out.println((stdout ? this.m_PrefixStdOut : this.m_PrefixStdErr) + line);
    }
}

